/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.references.XMLReferencesSettingsForTest;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.junit.jupiter.api.Test;

public class XMLReferencesLinkedEditingRangesExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void teiOnCorresp() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <teiHeader>  \r\n    <fileDesc>\r\n      <titleStmt>\r\n        <title>Title</title>\r\n      </titleStmt>\r\n      <publicationStmt>\r\n        <p>Publication information</p>  \r\n      </publicationStmt>\r\n      <sourceDesc>\r\n        <p>Information about the source</p>\r\n      </sourceDesc>\r\n    </fileDesc>\r\n  </teiHeader>\r\n  <text>\r\n    <body xml:id=\"body-id\">\r\n      <p xml:id=\"p-id\" >Some text here.</p>\r\n      <anchor corresp=\"#bo|dy-id\"></anchor>\r\n      <anchor corresp=\"#body-id\"></anchor>\r\n    </body>\r\n  </text>\r\n</TEI>";
        XMLReferencesLinkedEditingRangesExtensionsTest.testLinkedEditingFor(xml, "file:///test/tei.xml", null);
    }

    @Test
    public void teiOnXMLId() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n  <teiHeader>  \r\n    <fileDesc>\r\n      <titleStmt>\r\n        <title>Title</title>\r\n      </titleStmt>\r\n      <publicationStmt>\r\n        <p>Publication information</p>  \r\n      </publicationStmt>\r\n      <sourceDesc>\r\n        <p>Information about the source</p>\r\n      </sourceDesc>\r\n    </fileDesc>\r\n  </teiHeader>\r\n  <text>\r\n    <body xml:id=\"bod|y-id\">\r\n      <p xml:id=\"p-id\" >Some text here.</p>\r\n      <anchor corresp=\"#body-id\"></anchor>\r\n      <anchor corresp=\"#body-id\"></anchor>\r\n    </body>\r\n  </text>\r\n</TEI>";
        XMLReferencesLinkedEditingRangesExtensionsTest.testLinkedEditingFor(xml, "file:///test/tei.xml", XMLAssert.le(XMLAssert.r(18, 24, 18, 31), XMLAssert.r(19, 24, 19, 31), XMLAssert.r(16, 18, 16, 25)));
    }

    @Test
    public void docbookOnLinked() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book>\r\n    <chapter id=\"chapter-1\">\r\n\r\n        <xref linkend=\"chapt|er-1\" />\r\n\r\n    </chapter>\r\n\r\n    <chapter id=\"chapter-2\">\r\n\r\n    </chapter>\r\n</book>";
        XMLReferencesLinkedEditingRangesExtensionsTest.testLinkedEditingFor(xml, "file:///test/docbook.xml", null);
    }

    @Test
    public void docbookOnChapterId() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book>\r\n    <chapter id=\"chapt|er-1\">\r\n\r\n        <xref linkend=\"chapter-1\" />\r\n\r\n    </chapter>\r\n\r\n    <chapter id=\"chapter-2\">\r\n\r\n    </chapter>\r\n</book>";
        XMLReferencesLinkedEditingRangesExtensionsTest.testLinkedEditingFor(xml, "file:///test/docbook.xml", XMLAssert.le(XMLAssert.r(4, 23, 4, 32), XMLAssert.r(2, 17, 2, 26)));
    }

    @Test
    public void noLinkedEditingRangeForDocument() throws BadLocationException {
        String xml = "|<book />";
        XMLReferencesLinkedEditingRangesExtensionsTest.testLinkedEditingFor(xml, "file:///test/docbook.xml", null);
    }

    @Test
    public void noLinkedEditingRangeForNoneReferencedNodes() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<book>\r\n    <chapter id=\"chapt|er-1\">\r\n\r\n\r\n    </chapter>\r\n\r\n    <chapter id=\"chapter-2\">\r\n\r\n    </chapter>\r\n</book>";
        XMLReferencesLinkedEditingRangesExtensionsTest.testLinkedEditingFor(xml, "file:///test/docbook.xml", null);
    }

    @Test
    public void webOnServletMapping() throws BadLocationException {
        String xml = "<web-app xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  version=\"3.1\">\r\n  <servlet>\r\n    <servlet-name>comingsoon</servlet-name>\r\n    <servlet-class>mysite.server.ComingSoonServlet</servlet-class>\r\n  </servlet>\r\n  <servlet-mapping>\r\n    <servlet-name>co|mingsoon</servlet-name>\r\n    <url-pattern>/*</url-pattern>\r\n  </servlet-mapping>\r\n  <servlet-mapping>\r\n    <servlet-name>comingsoon</servlet-name>\r\n    <url-pattern>/*</url-pattern>\r\n  </servlet-mapping>\r\n</web-app>\r\n";
        XMLReferencesLinkedEditingRangesExtensionsTest.testLinkedEditingFor(xml, "file:///test/web.xml", null);
    }

    @Test
    public void webOnServlet() throws BadLocationException {
        String xml = "<web-app xmlns=\"http://xmlns.jcp.org/xml/ns/javaee\"\r\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n  version=\"3.1\">\r\n  <servlet>\r\n    <servlet-name>comi|ngsoon</servlet-name>\r\n    <servlet-class>mysite.server.ComingSoonServlet</servlet-class>\r\n  </servlet>\r\n  <servlet-mapping>\r\n    <servlet-name>comingsoon</servlet-name>\r\n    <url-pattern>/*</url-pattern>\r\n  </servlet-mapping>\r\n  <servlet-mapping>\r\n    <servlet-name>comingsoon</servlet-name>\r\n    <url-pattern>/*</url-pattern>\r\n  </servlet-mapping>\r\n</web-app>\r\n";
        XMLReferencesLinkedEditingRangesExtensionsTest.testLinkedEditingFor(xml, "file:///test/web.xml", XMLAssert.le(XMLAssert.r(8, 18, 8, 28), XMLAssert.r(12, 18, 12, 28), XMLAssert.r(4, 18, 4, 28)));
    }

    private static void testLinkedEditingFor(String value, String fileURI, LinkedEditingRanges expected) throws BadLocationException {
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        xmlLanguageService.getExtensions();
        xmlLanguageService.doSave((ISaveContext)new XMLAssert.SettingsSaveContext(XMLReferencesSettingsForTest.createXMLReferencesSettings()));
        XMLAssert.testLinkedEditingFor(xmlLanguageService, value, fileURI, expected);
    }
}

