/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.participants;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.references.XMLReferencesManager;
import org.eclipse.lemminx.services.extensions.completion.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class XMLReferencesCompletionParticipant
extends CompletionParticipantAdapter {
    @Override
    public void onXMLContent(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
        int offset = request.getOffset();
        DOMNode node = this.getNodeAt(request.getNode(), offset);
        if (node != null) {
            XMLReferencesManager.getInstance().collect(node, n -> {
                DOMDocument doc = n.getOwnerDocument();
                Range range = XMLPositionUtility.createRange(node.getStart(), node.getEnd(), doc);
                String label = n.getNodeValue();
                CompletionItem item = new CompletionItem();
                item.setLabel(label);
                String insertText = label;
                item.setKind(CompletionItemKind.Property);
                item.setDocumentation(Either.forLeft((Object)label));
                item.setFilterText(insertText);
                item.setTextEdit(Either.forLeft((Object)new TextEdit(range, insertText)));
                item.setInsertTextFormat(InsertTextFormat.PlainText);
                response.addCompletionItem(item);
            });
        }
    }

    private DOMNode getNodeAt(DOMNode node, int offset) {
        if (node == null) {
            return null;
        }
        if (node.hasChildNodes()) {
            for (DOMNode child : node.getChildren()) {
                if (!DOMNode.isIncluded(child, offset + 1)) continue;
                return this.getNodeAt(child, offset + 1);
            }
        }
        return node;
    }
}

