/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;

class CompletionResponse
extends CompletionList
implements ICompletionResponse {
    private transient List<String> seenAttributes;
    private transient boolean hasSomeItemFromGrammar;

    public CompletionResponse() {
        super.setIsIncomplete(false);
    }

    @Override
    public void addCompletionItem(CompletionItem completionItem, boolean fromGrammar) {
        if (fromGrammar) {
            this.hasSomeItemFromGrammar = true;
        }
        this.addCompletionItem(completionItem);
    }

    @Override
    public void addCompletionItem(CompletionItem completionItem) {
        super.getItems().add(completionItem);
    }

    @Override
    public boolean hasSomeItemFromGrammar() {
        return this.hasSomeItemFromGrammar;
    }

    @Override
    public boolean hasAttribute(String attribute) {
        return this.seenAttributes != null ? this.seenAttributes.contains(attribute) : false;
    }

    @Override
    public void addCompletionAttribute(CompletionItem completionItem) {
        if (this.seenAttributes == null) {
            this.seenAttributes = new ArrayList<String>();
        }
        this.seenAttributes.add(completionItem.getLabel());
        this.addCompletionItem(completionItem);
    }
}

