/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDDeclNode;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lsp4j.TextEdit;

public class DOMDocTypeFormatter {
    private final XMLFormatterDocumentNew formatterDocument;

    public DOMDocTypeFormatter(XMLFormatterDocumentNew formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatDocType(DOMDocumentType docType, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        boolean isDTD = docType.getOwnerDocument().isDTD();
        if (isDTD) {
            this.formatDTD(docType, parentConstraints, start, end, edits);
        } else {
            DTDDeclParameter internalSubset;
            List<DTDDeclParameter> parameters = docType.getParameters();
            if (!parameters.isEmpty()) {
                for (DTDDeclParameter parameter : parameters) {
                    this.replaceLeftSpacesWithOneSpace(parameter.getStart(), edits);
                    if (!docType.isInternalSubset(parameter)) continue;
                    XMLFormattingConstraints constraints = new XMLFormattingConstraints();
                    constraints.copyConstraints(parentConstraints);
                    constraints.setIndentLevel(constraints.getIndentLevel() + 1);
                    this.formatDTD(docType, constraints, start, end, edits);
                }
            }
            if ((internalSubset = docType.getInternalSubsetNode()) == null) {
                if (docType.isClosed()) {
                    int endDocType = docType.getEnd() - 1;
                    this.removeLeftSpaces(endDocType, edits);
                }
            } else {
                int endDocType = internalSubset.getEnd() - 1;
                String lineDelimiter = this.formatterDocument.getLineDelimiter();
                this.replaceLeftSpacesWith(endDocType, lineDelimiter, edits);
            }
        }
    }

    private void formatDTD(DOMDocumentType docType, XMLFormattingConstraints parentConstraints, int start, int end, List<TextEdit> edits) {
        boolean addLineSeparator = !docType.getOwnerDocument().isDTD();
        block3: for (DOMNode child : docType.getChildren()) {
            switch (child.getNodeType()) {
                case 6: 
                case 101: 
                case 102: 
                case 104: {
                    DTDDeclNode nodeDecl = (DTDDeclNode)child;
                    this.formatDTDNodeDecl(nodeDecl, parentConstraints, addLineSeparator, edits);
                    addLineSeparator = true;
                    continue block3;
                }
            }
            int width = this.updateLineWidthWithLastLine(child, parentConstraints.getAvailableLineWidth());
            parentConstraints.setAvailableLineWidth(width);
        }
    }

    private int updateLineWidthWithLastLine(DOMNode child, int availableLineWidth) {
        return this.formatterDocument.updateLineWidthWithLastLine(child, availableLineWidth);
    }

    private void formatDTDNodeDecl(DTDDeclNode nodeDecl, XMLFormattingConstraints parentConstraints, boolean addLineSeparator, List<TextEdit> edits) {
        block11: {
            block10: {
                DTDAttlistDecl attlist;
                this.replaceLeftSpacesWithIndentation(parentConstraints.getIndentLevel(), nodeDecl.getStart(), addLineSeparator, edits);
                DTDAttlistDecl dTDAttlistDecl = attlist = nodeDecl.isDTDAttListDecl() ? (DTDAttlistDecl)nodeDecl : null;
                if (attlist == null) break block10;
                int indentLevel = nodeDecl.getOwnerDocument().isDTD() ? 1 : 2;
                List<DTDAttlistDecl> internalDecls = attlist.getInternalChildren();
                if (internalDecls == null) {
                    for (DTDDeclParameter parameter : attlist.getParameters()) {
                        this.replaceLeftSpacesWithOneSpace(parameter.getStart(), edits);
                    }
                } else {
                    DTDDeclParameter parameter;
                    boolean multipleInternalAttlistDecls = false;
                    List<DTDDeclParameter> params = attlist.getParameters();
                    for (int i = 0; i < params.size(); ++i) {
                        parameter = params.get(i);
                        if (attlist.getNameParameter().equals(parameter)) {
                            this.replaceLeftSpacesWithOneSpace(parameter.getStart(), edits);
                            if (attlist.getParameters().size() <= 1) continue;
                            multipleInternalAttlistDecls = true;
                            continue;
                        }
                        if (multipleInternalAttlistDecls && i == 1) {
                            this.replaceLeftSpacesWithIndentation(indentLevel, parameter.getStart(), true, edits);
                            continue;
                        }
                        this.replaceLeftSpacesWithOneSpace(parameter.getStart(), edits);
                    }
                    for (DTDAttlistDecl attlistDecl : internalDecls) {
                        params = attlistDecl.getParameters();
                        for (int i = 0; i < params.size(); ++i) {
                            parameter = params.get(i);
                            if (i == 0) {
                                this.replaceLeftSpacesWithIndentation(indentLevel, parameter.getStart(), true, edits);
                                continue;
                            }
                            this.replaceLeftSpacesWithOneSpace(parameter.getStart(), edits);
                        }
                    }
                }
                break block11;
            }
            List<DTDDeclParameter> parameters = nodeDecl.getParameters();
            if (parameters.isEmpty()) break block11;
            for (DTDDeclParameter parameter : parameters) {
                this.replaceLeftSpacesWithOneSpace(parameter.getStart(), edits);
            }
        }
    }

    private void replaceLeftSpacesWith(int to, String replacement, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWith(to, replacement, edits);
    }

    private void replaceLeftSpacesWithOneSpace(int offset, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithOneSpace(offset, edits);
    }

    private int replaceLeftSpacesWithIndentation(int indentLevel, int offset, boolean addLineSeparator, List<TextEdit> edits) {
        return this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, offset, addLineSeparator, edits);
    }

    private void removeLeftSpaces(int to, List<TextEdit> edits) {
        this.formatterDocument.removeLeftSpaces(to, edits);
    }
}

