/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.BaseCodeActionRequest;
import org.eclipse.lemminx.services.data.DataEntryField;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionResolverRequest;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;

public class ResolveCodeActionRequest
extends BaseCodeActionRequest
implements ICodeActionResolverRequest {
    private final CodeAction unresolved;
    private final String participantId;

    public ResolveCodeActionRequest(CodeAction unresolved, DOMDocument document, IComponentProvider componentProvider, SharedSettings sharedSettings) {
        super(document, componentProvider, sharedSettings);
        this.unresolved = unresolved;
        this.participantId = DataEntryField.getParticipantId(unresolved.getData());
    }

    @Override
    public CodeAction getUnresolved() {
        return this.unresolved;
    }

    @Override
    public String getParticipantId() {
        return this.participantId;
    }

    @Override
    public String getDataProperty(String property) {
        return DataEntryField.getProperty(this.unresolved.getData(), property);
    }
}

