/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.Collection;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.services.format.FormatElementCategory;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lemminx.settings.SharedSettings;

public class ContentModelFormatterParticipant
implements IFormatterParticipant {
    private final ContentModelManager contentModelManager;

    public ContentModelFormatterParticipant(ContentModelManager contentModelManager) {
        this.contentModelManager = contentModelManager;
    }

    @Override
    public FormatElementCategory getFormatElementCategory(DOMElement element, XMLFormattingConstraints parentConstraints, SharedSettings sharedSettings) {
        boolean enabled = sharedSettings.getFormattingSettings().isGrammarAwareFormatting();
        if (!enabled) {
            return null;
        }
        Collection<CMDocument> cmDocuments = this.contentModelManager.findCMDocument(element);
        for (CMDocument cmDocument : cmDocuments) {
            CMElementDeclaration cmElement = cmDocument.findCMElement(element);
            if (cmElement == null) continue;
            if (cmElement.isStringType()) {
                return FormatElementCategory.PreserveSpace;
            }
            if (!cmElement.isMixedContent()) continue;
            return FormatElementCategory.MixedContent;
        }
        return null;
    }
}

