/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.commons;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.eclipse.lemminx.commons.ModelTextDocument;
import org.eclipse.lemminx.commons.TextDocument;
import org.eclipse.lemminx.commons.TextDocuments;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;

public class ModelTextDocuments<T>
extends TextDocuments<ModelTextDocument<T>> {
    private final BiFunction<TextDocument, CancelChecker, T> parse;

    public ModelTextDocuments(BiFunction<TextDocument, CancelChecker, T> parse) {
        this.parse = parse;
    }

    @Override
    public ModelTextDocument<T> createDocument(TextDocumentItem document) {
        ModelTextDocument<T> doc = new ModelTextDocument<T>(document, this.parse);
        doc.setIncremental(this.isIncremental());
        return doc;
    }

    public T getExistingModel(TextDocumentIdentifier documentIdentifier) {
        return this.getExistingModel(documentIdentifier.getUri());
    }

    public T getExistingModel(String uri) {
        ModelTextDocument document = (ModelTextDocument)((Object)this.get(uri));
        if (document != null) {
            return document.getExistingModel();
        }
        return null;
    }

    public T getModel(TextDocumentIdentifier documentIdentifier) {
        return this.getModel(documentIdentifier.getUri());
    }

    public T getModel(String uri) {
        ModelTextDocument document = (ModelTextDocument)((Object)this.get(uri));
        if (document != null) {
            return document.getModel();
        }
        return null;
    }

    public <R> CompletableFuture<R> computeModelAsync(TextDocumentIdentifier documentIdentifier, BiFunction<T, CancelChecker, R> code) {
        return CompletableFutures.computeAsync(cancelChecker -> {
            T model = this.getModel(documentIdentifier);
            if (model == null) {
                return null;
            }
            return code.apply(model, (CancelChecker)cancelChecker);
        });
    }
}

