/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format.experimental;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Test;

public class XMLFormatterMaxLineWithTest {
    @Test
    public void splitText() throws BadLocationException {
        String content = "<a>abcde fghi</a>";
        String expected = "<a>abcde" + System.lineSeparator() + "fghi</a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, 6, XMLAssert.te(0, 8, 0, 9, System.lineSeparator()));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, 6, new TextEdit[0]);
    }

    @Test
    public void splitMixedText() throws BadLocationException {
        String content = "<a><b /> efgh</a>";
        String expected = "<a><b />" + System.lineSeparator() + "efgh</a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, 5, XMLAssert.te(0, 8, 0, 9, System.lineSeparator()));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, 5, new TextEdit[0]);
    }

    @Test
    public void noSplit() throws BadLocationException {
        String content;
        String expected = content = "<a>abcde fghi</a>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, 20, new TextEdit[0]);
    }

    @Test
    public void longText() throws BadLocationException {
        String content = "<foo>\r\n\t<para>    \r\n\t\tvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv\r\n\t</para>\r\n</foo>";
        String expected = "<foo>\r\n  <para>\r\nvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv </para>\r\n</foo>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, 20, XMLAssert.te(0, 5, 1, 1, "\r\n  "), XMLAssert.te(1, 7, 2, 2, "\r\n"), XMLAssert.te(2, 102, 3, 1, " "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, 20, new TextEdit[0]);
    }

    @Test
    public void complex() throws BadLocationException {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<ip_log  version=\"1.0\">\r\n  <project id=\"org.apache.ant\" version=\"1.10.12\" status=\"done\">\r\n    <info>\r\n      <name>Apache            Ant (all-in-one) ffffffffffffffffff        fffffffffffffffffffffffff    ggggggggggggggg</name>\r\n      <repository>scm:git:git.eclipse.org:/gitroot/orbit/recipes.git</repository>\r\n      <location>apache-parent/ant/org.apache.ant</location>\r\n    </info>\r\n    <contact>\r\n      <name>Sarika          \r\n        Sinha</name>\r\n      <email>sarika.\r\n        \r\n        \r\n        sinha@in.ibm.com</email>\r\n      <company>IBM</company>\r\n    </contact>\r\n  </project>\r\n</ip_log>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<ip_log version=\"1.0\">\r\n  <project id=\"org.apache.ant\" version=\"1.10.12\" status=\"done\">\r\n    <info>\r\n      <name>Apache Ant (all-in-one) ffffffffffffffffff fffffffffffffffffffffffff\r\nggggggggggggggg</name>\r\n      <repository>scm:git:git.eclipse.org:/gitroot/orbit/recipes.git</repository>\r\n      <location>apache-parent/ant/org.apache.ant</location>\r\n    </info>\r\n    <contact>\r\n      <name>Sarika Sinha</name>\r\n      <email>sarika. sinha@in.ibm.com</email>\r\n      <company>IBM</company>\r\n    </contact>\r\n  </project>\r\n</ip_log>";
        XMLFormatterMaxLineWithTest.assertFormat(content, expected, 80, XMLAssert.te(1, 7, 1, 9, " "), XMLAssert.te(4, 18, 4, 30, " "), XMLAssert.te(4, 65, 4, 73, " "), XMLAssert.te(4, 98, 4, 102, "\r\n"), XMLAssert.te(9, 18, 10, 8, " "), XMLAssert.te(11, 20, 14, 8, " "));
        XMLFormatterMaxLineWithTest.assertFormat(expected, expected, 80, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String expected, int maxLineWidth, TextEdit ... expectedEdits) throws BadLocationException {
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getFormattingSettings().setMaxLineWidth(maxLineWidth);
        sharedSettings.getFormattingSettings().setExperimental(true);
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, "test.xml", Boolean.FALSE, expectedEdits);
    }
}

