/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.catalog;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.junit.jupiter.api.Test;

public class XMLCatalogExtensionTest {
    @Test
    public void completion() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">\r\n    |";
        XMLAssert.testCompletionFor(xml, 17, XMLAssert.c("public", "<public publicId=\"\" uri=\"\" />"));
    }

    @Test
    public void diagnostics() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\">\r\n    <bad /> // error validation, because \"bad\" doesn't belong to the XML Schema catalog\r\n</catalog> ";
        XMLAssert.testDiagnosticsFor(xml, XMLAssert.d(2, 5, 8, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_4_a), XMLAssert.d(2, 12, 14, (IXMLErrorCode)XMLSchemaErrorCode.cvc_complex_type_2_3));
    }
}

