/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.Arrays;
import java.util.List;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.customservice.AutoCloseTagResponse;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class XMLCompletionTest {
    private XMLLanguageService languageService;

    @BeforeEach
    public void initializeLanguageService() {
        this.languageService = new XMLLanguageService();
    }

    @Test
    public void successfulEndTagCompletion() throws BadLocationException {
        XMLAssert.testCompletionFor("<a>|", 3, XMLAssert.c("End with '</a>'", "</a>", XMLAssert.r(0, 3, 0, 3), "</a>"));
        XMLAssert.testCompletionFor("<a>a|", 3, XMLAssert.c("End with '</a>'", "</a>", XMLAssert.r(0, 3, 0, 4), "</a>"));
        XMLAssert.testCompletionFor("<a><|", 3, XMLAssert.c("End with '</a>'", "/a>", XMLAssert.r(0, 4, 0, 4), "/a>"));
        XMLAssert.testCompletionFor("<a></|", 1, XMLAssert.c("End with '</a>'", "/a>", XMLAssert.r(0, 4, 0, 5), "/a>"));
        XMLAssert.testCompletionFor("<a><b>|</a>", 3, XMLAssert.c("End with '</b>'", "</b>", XMLAssert.r(0, 6, 0, 6), "</b>"));
        XMLAssert.testCompletionFor("<a><b><|</a>", 3, XMLAssert.c("End with '</b>'", "/b>", XMLAssert.r(0, 7, 0, 7), "/b>"));
        XMLAssert.testCompletionFor("<a><b></|</a>", 1, XMLAssert.c("End with '</b>'", "/b>", XMLAssert.r(0, 7, 0, 8), "/b>"));
        XMLAssert.testCompletionFor("<a>   <b>|</a>", 3, XMLAssert.c("End with '</b>'", "</b>", XMLAssert.r(0, 9, 0, 9), "</b>"));
        XMLAssert.testCompletionFor("<a>   <b><|</a>", 3, XMLAssert.c("End with '</b>'", "/b>", XMLAssert.r(0, 10, 0, 10), "/b>"));
        XMLAssert.testCompletionFor("<a>   <b></|</a>", 1, XMLAssert.c("End with '</b>'", "/b>", XMLAssert.r(0, 10, 0, 11), "/b>"));
        XMLAssert.testCompletionFor("<a><b>|", 4, XMLAssert.c("End with '</b>'", "</b>", XMLAssert.r(0, 6, 0, 6), "</b>"), XMLAssert.c("End with '</a>'", "</a>", XMLAssert.r(0, 6, 0, 6), "</a>"));
        XMLAssert.testCompletionFor("<a><b><|", 4, XMLAssert.c("End with '</b>'", "/b>", XMLAssert.r(0, 7, 0, 7), "/b>"), XMLAssert.c("End with '</a>'", "/a>", XMLAssert.r(0, 7, 0, 7), "/a>"));
        XMLAssert.testCompletionFor("<a><b></|", 2, XMLAssert.c("End with '</b>'", "/b>", XMLAssert.r(0, 7, 0, 8), "/b>"), XMLAssert.c("End with '</a>'", "/a>", XMLAssert.r(0, 7, 0, 8), "/a>"));
    }

    @Test
    public void successfulEndTagCompletionWithIndent() throws BadLocationException {
        XMLAssert.testCompletionFor("<a></|", 1, XMLAssert.c("End with '</a>'", "/a>", XMLAssert.r(0, 4, 0, 5), "/a>"));
        XMLAssert.testCompletionFor("  <a>\r\n     <b>\r\n<|", 4, XMLAssert.c("End with '</b>'", "     </b>", XMLAssert.r(2, 0, 2, 1), "</b>"), XMLAssert.c("End with '</a>'", "  </a>", XMLAssert.r(2, 0, 2, 1), "</a>"));
    }

    @Test
    public void unneededEndTagCompletion() throws BadLocationException {
        XMLAssert.testCompletionFor("<a>|</a>", 2, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<a><|</a>", 2, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<a></|</a>", 0, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<a><b>|</b></a>", 2, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<a><b><|</b></a>", 2, new CompletionItem[0]);
        XMLAssert.testCompletionFor("<a><b></|</b></a>", 0, new CompletionItem[0]);
    }

    @Test
    public void startTagOpenBracket() throws BadLocationException {
        XMLAssert.testCompletionFor("<hello><h|</hello>", 3, XMLAssert.c("h", "<h></h>", "<h"));
        XMLAssert.testCompletionFor("<hello><h1/><h2></h2><h|</hello>", 5, XMLAssert.c("h", "<h></h>", "<h"), XMLAssert.c("h1", "<h1 />", "<h1"), XMLAssert.c("h2", "<h2></h2>", "<h2"));
    }

    @Test
    public void replaceRangeOUnusedfCloseTag() throws BadLocationException {
        XMLAssert.testCompletionFor("<hello><h|></hello>", 1, XMLAssert.c("h", "<h></h>", "<h"));
        XMLAssert.testCompletionFor("<hello><h1/><h2></h2><h|</hello>", 5, XMLAssert.c("h", "<h></h>", "<h"), XMLAssert.c("h1", "<h1 />", "<h1"), XMLAssert.c("h2", "<h2></h2>", "<h2"));
    }

    @Test
    public void completionBasedOnParent() throws BadLocationException {
        XMLAssert.testCompletionFor("<a><b />|</a>", 3, XMLAssert.c("b", "<b />", XMLAssert.r(0, 8, 0, 8), "b"));
        XMLAssert.testCompletionFor("<a><b /><|</a>", 3, XMLAssert.c("b", "<b />", XMLAssert.r(0, 8, 0, 9), "<b"));
        XMLAssert.testCompletionFor("<a>|</b></a>", 3, XMLAssert.c("b", "<b>", XMLAssert.r(0, 3, 0, 3), "b"));
        XMLAssert.testCompletionFor("<a><|b</b></a>", XMLAssert.c("b", "<b>", XMLAssert.r(0, 3, 0, 5), "<b"));
    }

    @Test
    public void doTagComplete() throws BadLocationException {
        XMLAssert.testTagCompletion("<div>|", "$0</div>");
        XMLAssert.testTagCompletion("<div>|</div>", null);
        XMLAssert.testTagCompletion("<div class=\"\">|", "$0</div>");
        XMLAssert.testTagCompletion("<img />|", null);
        XMLAssert.testTagCompletion("<div><br /></|", "div>$0");
        XMLAssert.testTagCompletion("<div><br /><span></span></|", "div>$0");
    }

    @Test
    public void testAutoCloseTagCompletion() {
        this.assertAutoCloseEndTagCompletion("<a>|", "$0</a>");
        this.assertAutoCloseEndTagCompletion("<a><b>|</a>", "$0</b>");
        this.assertAutoCloseEndTagCompletion("<a>   <b>|</a>", "$0</b>");
        this.assertAutoCloseEndTagCompletion("<a><b>|", "$0</b>");
        this.assertAutoCloseEndTagCompletion("<a></|", "a>$0");
        this.assertAutoCloseEndTagCompletion("<a/|", ">$0");
        this.assertAutoCloseEndTagCompletion("<a/|</b>", ">$0");
        this.assertAutoCloseEndTagCompletion("<a><a>|</a>", "$0</a>");
    }

    @Test
    public void testAutoCloseTagCompletionWithRange() {
        this.assertAutoCloseEndTagCompletionWithRange("<a/|></a>", ">$0", XMLAssert.r(0, 3, 0, 8));
        this.assertAutoCloseEndTagCompletionWithRange("<a/| </a>", ">$0", XMLAssert.r(0, 3, 0, 8));
        this.assertAutoCloseEndTagCompletionWithRange("<a> <a/|> </a> </a>", ">$0", XMLAssert.r(0, 7, 0, 13));
        this.assertAutoCloseEndTagCompletionWithRange("<a var=\"asd\"/|></a>", ">$0", XMLAssert.r(0, 13, 0, 18));
        this.assertAutoCloseEndTagCompletionWithRange("<a  var=\"asd\"  /| </a>", ">$0", XMLAssert.r(0, 16, 0, 21));
        this.assertAutoCloseEndTagCompletionWithRange("<aB/|></aB>", ">$0", XMLAssert.r(0, 4, 0, 10));
    }

    @Test
    public void testAutoCloseTagCompletionWithSlashAtBadLocations() {
        this.assertAutoCloseEndTagCompletionWithRange("<a zz=\"a/|\"></a>", null, null);
        this.assertAutoCloseEndTagCompletionWithRange("<a zz=/|\"aa\"> </a>", null, null);
        this.assertAutoCloseEndTagCompletionWithRange("<a  /|  > </a>", null, null);
        this.assertAutoCloseEndTagCompletionWithRange("<a> </a/|>", null, null);
        this.assertAutoCloseEndTagCompletionWithRange("<a> </|a>", null, null);
    }

    @Test
    public void testAutoCloseEnabledDisabled() throws BadLocationException {
        XMLAssert.testCompletionFor("<a><div|<a>", false, XMLAssert.c("div", "<div>"));
        XMLAssert.testCompletionFor("<a><div|<a>", true, XMLAssert.c("div", "<div></div>"));
        XMLAssert.testCompletionFor("<a>  <div|    <a>", false, XMLAssert.c("div", "<div>"));
        XMLAssert.testCompletionFor("<a>   <div|    <a>", true, XMLAssert.c("div", "<div></div>"));
        this.assertAutoCloseEndTagCompletionWithRange("<a/|>Text</a>", null, null);
    }

    @Test
    public void testAutoCloseTagCompletionRemovesContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getCompletionSettings().setAutoCloseTags(true);
        settings.getCompletionSettings().setAutoCloseRemovesContent(true);
        String value = "<a/|\n  <b />\n</a>";
        AutoCloseTagResponse closeTagResponse = new AutoCloseTagResponse(">$0", XMLAssert.r(0, 3, 2, 4));
        XMLAssert.testTagCompletion(value, closeTagResponse, settings);
    }

    @Test
    public void testAutoCloseTagCompletionDoesntRemoveContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getCompletionSettings().setAutoCloseTags(true);
        settings.getCompletionSettings().setAutoCloseRemovesContent(false);
        String value = "<a/|\n  <b />\n</a>";
        AutoCloseTagResponse closeTagResponse = new AutoCloseTagResponse(">$0");
        XMLAssert.testTagCompletion(value, closeTagResponse, settings);
    }

    @Test
    public void testAutoCloseTagCompletionWithLeadingTextContent() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getCompletionSettings().setAutoCloseTags(true);
        settings.getCompletionSettings().setAutoCloseRemovesContent(true);
        String value = "<a/|\n  content\n</a>";
        XMLAssert.testTagCompletion(value, (AutoCloseTagResponse)null, settings);
    }

    @Test
    public void testnoCDATANPE() {
        try {
            XMLAssert.testCompletionFor("<a> <![CDATA[<b>foo</b>]]| </a>", 0, new CompletionItem[0]);
        }
        catch (BadLocationException e) {
            Assertions.fail();
        }
    }

    @Test
    public void testNoEndStartTagInAttributeValue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getCompletionSettings().setAutoCloseTags(true);
        String xml = "<aaa attr=\"value>|";
        XMLAssert.testTagCompletion(xml, (AutoCloseTagResponse)null, settings);
        xml = "<aaa attr=\">|value";
        XMLAssert.testTagCompletion(xml, (AutoCloseTagResponse)null, settings);
        xml = "<aaa attr=>|\"";
        XMLAssert.testTagCompletion(xml, new AutoCloseTagResponse("$0</aaa>"), settings);
    }

    @Test
    public void testNoSelfCloseTagInAttributeValue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getCompletionSettings().setAutoCloseTags(true);
        String xml = "<aaa attr=\"value/|";
        XMLAssert.testTagCompletion(xml, (AutoCloseTagResponse)null, settings);
    }

    @Test
    public void testNoEndTagInAttributeValue() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getCompletionSettings().setAutoCloseTags(true);
        String xml = "<aaa attr=\"value</|";
        XMLAssert.testTagCompletion(xml, (AutoCloseTagResponse)null, settings);
    }

    public void assertOpenStartTagCompletion(String xmlText, int expectedStartTagOffset, boolean startWithTagOpen, String ... expectedTag) {
        List<String> expectedTags = Arrays.asList(expectedTag);
        int offset = this.getOffset(xmlText);
        DOMDocument xmlDocument = this.initializeXMLDocument(xmlText, offset);
        CompletionList completionList = this.initializeCompletion(xmlText, xmlDocument, offset);
        Assertions.assertEquals((int)expectedTag.length, (int)completionList.getItems().size());
        for (int i = 0; i < expectedTag.length; ++i) {
            String currentTag = expectedTags.get(i);
            String currentTextEdit = this.createTextEditElement(currentTag);
            CompletionItem completionItem = (CompletionItem)completionList.getItems().get(i);
            Assertions.assertEquals((Object)currentTag, (Object)completionItem.getLabel());
            Assertions.assertEquals((Object)(startWithTagOpen ? "<" + currentTag : currentTag), (Object)completionItem.getFilterText());
            try {
                Range range = ((TextEdit)completionItem.getTextEdit().getLeft()).getRange();
                Assertions.assertEquals((int)expectedStartTagOffset, (int)xmlDocument.offsetAt(range.getStart()));
            }
            catch (Exception e) {
                Assertions.fail((String)"Couldn't get offset at position");
            }
            Assertions.assertEquals((Object)currentTextEdit, (Object)((TextEdit)completionItem.getTextEdit().getLeft()).getNewText());
        }
    }

    public void assertAutoCloseEndTagCompletion(String xmlText, String expectedTextEdit) {
        this.assertAutoCloseEndTagCompletionWithRange(xmlText, expectedTextEdit, null);
    }

    public void assertAutoCloseEndTagCompletionWithRange(String xmlText, String expectedTextEdit, Range range) {
        this.assertAutoCloseEndTagCompletionWithRange(xmlText, expectedTextEdit, range, new SharedSettings());
    }

    public void assertAutoCloseEndTagCompletionWithRange(String xmlText, String expectedTextEdit, Range range, SharedSettings settings) {
        int offset = this.getOffset(xmlText);
        DOMDocument xmlDocument = this.initializeXMLDocument(xmlText, offset);
        Position position = null;
        try {
            position = xmlDocument.positionAt(offset);
        }
        catch (Exception e) {
            Assertions.fail((String)"Couldn't get position at offset");
        }
        AutoCloseTagResponse response = this.languageService.doTagComplete(xmlDocument, settings.getCompletionSettings(), position);
        if (response == null) {
            Assertions.assertNull((Object)expectedTextEdit);
            Assertions.assertNull((Object)range);
            return;
        }
        String completionList = response.snippet;
        Assertions.assertEquals((Object)expectedTextEdit, (Object)completionList);
        Assertions.assertEquals((Object)range, (Object)response.range);
    }

    public int getOffset(String xmlText) {
        return xmlText.indexOf("|");
    }

    public DOMDocument initializeXMLDocument(String xmlText, int offset) {
        xmlText = xmlText.substring(0, offset) + xmlText.substring(offset + 1);
        return DOMParser.getInstance().parse(xmlText, "test:uri", null);
    }

    public CompletionList initializeCompletion(String xmlText, DOMDocument xmlDocument, int offset) {
        Position position = null;
        try {
            position = xmlDocument.positionAt(offset);
        }
        catch (Exception e) {
            Assertions.fail((String)"Couldn't get position at offset");
        }
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getFormattingSettings().setTabSize(4);
        sharedSettings.getFormattingSettings().setInsertSpaces(false);
        CompletionList completionList = this.languageService.doComplete(xmlDocument, position, sharedSettings);
        return completionList;
    }

    public String createTextEditElement(String tag) {
        return tag + ">$0</" + tag + ">";
    }
}

