/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces.xmlmodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelDTDValidator;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelDeclaration;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelSchemaValidator;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelValidator;
import org.eclipse.lemminx.utils.StringUtils;

public class XMLModelHandler
implements XMLComponent,
XMLDocumentFilter {
    private static final String VALIDATION = "http://xml.org/sax/features/validation";
    private static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    private List<XMLModelValidator> xmlModelValidators;
    private XMLComponentManager configuration;
    private XMLDocumentHandler documentHandler;
    private XMLDocumentSource documentSource;
    private XMLLocator locator;

    public void reset(final XMLComponentManager componentManager) throws XMLConfigurationException {
        this.configuration = new XMLComponentManager(){

            public Object getProperty(String propertyId) throws XMLConfigurationException {
                return componentManager.getProperty(propertyId);
            }

            public boolean getFeature(String featureId) throws XMLConfigurationException {
                if (XMLModelHandler.PARSER_SETTINGS.equals(featureId)) {
                    return true;
                }
                if (XMLModelHandler.VALIDATION.equals(featureId)) {
                    return true;
                }
                return componentManager.getFeature(featureId);
            }
        };
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        XMLModelDeclaration model;
        XMLModelValidator validator;
        if ("xml-model".equals(target) && (validator = this.createValidator(model = XMLModelDeclaration.parse(data))) != null) {
            validator.reset(this.configuration);
            validator.setHref(model.getHref());
            if (this.xmlModelValidators == null) {
                this.xmlModelValidators = new ArrayList<XMLModelValidator>();
            }
            this.xmlModelValidators.add(validator);
        }
        if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(target, data, augs);
        }
    }

    private XMLModelValidator createValidator(XMLModelDeclaration model) {
        String href = model.getHref();
        if (StringUtils.isEmpty(href)) {
            return null;
        }
        if (href.endsWith("xsd")) {
            return new XMLModelSchemaValidator();
        }
        if (href.endsWith("dtd")) {
            return new XMLModelDTDValidator();
        }
        return null;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.locator = locator;
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.startDocument(locator, encoding, namespaceContext, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.startDocument(locator, encoding, namespaceContext, augs);
        }
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.xmlDecl(version, encoding, standalone, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.xmlDecl(version, encoding, standalone, augs);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.doctypeDecl(rootElement, publicId, systemId, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.doctypeDecl(rootElement, publicId, systemId, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.comment(text, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.comment(text, augs);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.setLocator(this.locator);
                validator.startElement(element, attributes, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.startElement(element, attributes, augs);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.emptyElement(element, attributes, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.emptyElement(element, attributes, augs);
        }
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.startGeneralEntity(name, identifier, encoding, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.startGeneralEntity(name, identifier, encoding, augs);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.textDecl(version, encoding, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.textDecl(version, encoding, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.endGeneralEntity(name, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.endGeneralEntity(name, augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.characters(text, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.characters(text, augs);
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.ignorableWhitespace(text, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.ignorableWhitespace(text, augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.endElement(element, augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.endElement(element, augs);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.startCDATA(augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.startCDATA(augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.endCDATA(augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.endCDATA(augs);
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        if (this.xmlModelValidators != null) {
            for (XMLModelValidator validator : this.xmlModelValidators) {
                validator.endDocument(augs);
            }
        }
        if (this.documentHandler != null) {
            this.documentHandler.endDocument(augs);
        }
    }

    public void setDocumentSource(XMLDocumentSource source) {
        this.documentSource = source;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.documentSource;
    }

    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.documentHandler = handler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public String[] getRecognizedFeatures() {
        return null;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return null;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String featureId) {
        return null;
    }

    public Object getPropertyDefault(String propertyId) {
        return null;
    }
}

