/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.commands;

import org.eclipse.lemminx.MockXMLLanguageServer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CheckFilePatternCommandTest {
    @Test
    public void checkPatternMatchSucceeds() throws Exception {
        String[] patterns;
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xmlPath = "file:/path/to/src/test/resources/tag.xml";
        for (String pattern : patterns = new String[]{"**/*.xml", "**/tag.xml", "tag.xml", "**/test/*/*.xml"}) {
            Boolean actual = (Boolean)languageServer.executeCommand("xml.check.file.pattern", pattern, xmlPath).get();
            Assertions.assertNotNull((Object)actual);
            Assertions.assertEquals((Object)true, (Object)actual);
        }
    }

    @Test
    public void checkPatternMatchFails() throws Exception {
        String[] patterns;
        MockXMLLanguageServer languageServer = new MockXMLLanguageServer();
        String xmlPath = "file:/path/to/src/test/resources/tag.xml";
        for (String pattern : patterns = new String[]{"**/res/tag.xml", "**/element.xml", "**/tag.html"}) {
            Boolean actual = (Boolean)languageServer.executeCommand("xml.check.file.pattern", pattern, xmlPath).get();
            Assertions.assertNotNull((Object)actual);
            Assertions.assertEquals((Object)false, (Object)actual);
        }
    }
}

