/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

public class BaseFileTempTest {
    private static final Path tempDirPath = Paths.get("target/temp/", new String[0]);
    protected static final URI tempDirUri = tempDirPath.toAbsolutePath().toUri();

    @BeforeAll
    public static void setup() throws FileNotFoundException, IOException {
        BaseFileTempTest.deleteTempDirIfExists();
        BaseFileTempTest.createTempDir();
    }

    @AfterAll
    public static void tearDown() throws IOException {
        BaseFileTempTest.deleteTempDirIfExists();
    }

    private static void deleteTempDirIfExists() throws IOException {
        File tempDir = new File(tempDirUri);
        if (tempDir.exists()) {
            MoreFiles.deleteRecursively((Path)tempDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }

    private static void createTempDir() {
        File tempDir = new File(tempDirUri);
        tempDir.mkdir();
    }

    protected static void createFile(String fileName, String contents) throws IOException {
        URI fileURI = new File(fileName).toURI();
        BaseFileTempTest.createFile(fileURI, contents);
    }

    protected static void createFile(URI fileURI, String contents) throws IOException {
        Path path = Paths.get(fileURI);
        Files.write(path, contents.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    protected static void updateFile(String fileName, String contents) throws IOException {
        URI fileURI = new File(fileName).toURI();
        BaseFileTempTest.updateFile(fileURI, contents);
    }

    protected static void updateFile(URI fileURI, String contents) throws IOException {
        try {
            Thread.sleep(1050L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        BaseFileTempTest.createFile(fileURI, contents);
    }

    protected static Path getTempDirPath() {
        return tempDirPath;
    }
}

