/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Position;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLPositionUtilityTest {
    @Test
    public void testGetMatchingEndTagPositionMiddle() {
        String initialText = "<Apple>\n  <Or|ange></Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange></Or|ange>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingEndTagPositionBeginning() {
        String initialText = "<Apple>\n  <|Orange></Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange></|Orange>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingEndTagPositionEnd() {
        String initialText = "<Apple>\n  <Orange|></Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange></Orange|>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingEndTagPositionAttributes() {
        String initialText = "<Apple>\n  <Orange| amount=\"1\"></Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange amount=\"1\"></Orange|>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingEndTagNoResult() {
        String initialText = "<Apple>\n  |<Orange></Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange></Orange>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingEndTagNoResult2() {
        String initialText = "<Apple>\n  <Orange |></Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange ></Orange>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingEndTagTextBetween() {
        String initialText = "<Apple>\n  <Orange|>Text Between</Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange>Text Between</Orange|>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingEndTagElementBetween() {
        String initialText = "<Apple>\n  <Orange|><Lemon></Lemon></Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange><Lemon></Lemon></Orange|>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingStartTagPositionMiddle() {
        String initialText = "<Apple>\n  <Orange></Or|ange>\n</Apple>";
        String expectedText = "<Apple>\n  <Or|ange></Orange>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingStartTagPositionBeginning() {
        String initialText = "<Apple>\n  <Orange></|Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <|Orange></Orange>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingStartTagPositionEnd() {
        String initialText = "<Apple>\n  <Orange></Orange|>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange|></Orange>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingStartTagPositionAttributes() {
        String initialText = "<Apple>\n  <Orange amount=\"1\"></Orange|>\n</Apple>";
        String expectedText = "<Apple>\n  <Orange| amount=\"1\"></Orange>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingEndTagPositionAttributesPrefixed() {
        String initialText = "<Apple>\n  <prefix:Orange| amount=\"1\"></prefix:Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <prefix:Orange amount=\"1\"></prefix:Orange|>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void testGetMatchingEndTagPositionPrefixed() {
        String initialText = "<Apple>\n  <pref|ix:Orange></prefix:Orange>\n</Apple>";
        String expectedText = "<Apple>\n  <prefix:Orange></pref|ix:Orange>\n</Apple>";
        XMLPositionUtilityTest.testMatchingTagPosition(initialText, expectedText);
    }

    @Test
    public void entityReference() {
        XMLPositionUtilityTest.assertEntityReferenceOffset("|", -1, -1);
        XMLPositionUtilityTest.assertEntityReferenceOffset("ab|cd", -1, -1);
        XMLPositionUtilityTest.assertEntityReferenceOffset("&|", 0, -1);
        XMLPositionUtilityTest.assertEntityReferenceOffset("&a|", 0, -1);
        XMLPositionUtilityTest.assertEntityReferenceOffset("\n&|", 1, -1);
        XMLPositionUtilityTest.assertEntityReferenceOffset("\n&a|", 1, -1);
        XMLPositionUtilityTest.assertEntityReferenceOffset("&ab|cd;&efgh;", 0, 6);
        XMLPositionUtilityTest.assertEntityReferenceOffset("& ab|cd;&efgh;", -1, 7);
    }

    private static void assertEntityReferenceOffset(String xml, int start, int end) {
        int offset = xml.indexOf(124);
        xml = xml.substring(0, offset) + xml.substring(offset + 1, xml.length());
        Assertions.assertEquals((int)start, (int)XMLPositionUtility.getEntityReferenceStartOffset((String)xml, (int)offset), (String)"test for start offset ");
        Assertions.assertEquals((int)end, (int)XMLPositionUtility.getEntityReferenceEndOffset((String)xml, (int)offset), (String)"Test for end offset ");
    }

    private static void testMatchingTagPosition(String initialCursorText, String expectedCursorText) {
        int offset = initialCursorText.indexOf(124);
        initialCursorText = initialCursorText.substring(0, offset) + initialCursorText.substring(offset + 1);
        DOMDocument xmlDocument = DOMParser.getInstance().parse(initialCursorText, "testURI", null);
        int newCursorOffset = -1;
        try {
            Position initialCursorPosition = xmlDocument.positionAt(offset);
            Position newCursorPosition = XMLPositionUtility.getMatchingTagPosition((DOMDocument)xmlDocument, (Position)initialCursorPosition);
            if (newCursorPosition != null) {
                newCursorOffset = xmlDocument.offsetAt(newCursorPosition);
            }
        }
        catch (BadLocationException e) {
            Assertions.fail((String)e.getMessage());
            return;
        }
        StringBuilder sBuffer = new StringBuilder(initialCursorText);
        String actualOutputString = newCursorOffset > -1 ? sBuffer.insert(newCursorOffset, "|").toString() : initialCursorText;
        Assertions.assertEquals((Object)expectedCursorText, (Object)actualOutputString);
    }
}

