/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.XMLCompletions;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public class XMLCodeActions {
    private static final Logger LOGGER = Logger.getLogger(XMLCompletions.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLCodeActions(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public List<CodeAction> doCodeActions(CodeActionContext context, Range range, DOMDocument document, SharedSettings sharedSettings) {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        List diagnostics = context.getDiagnostics();
        if (diagnostics != null) {
            for (Diagnostic diagnostic : context.getDiagnostics()) {
                for (ICodeActionParticipant codeActionParticipant : this.extensionsRegistry.getCodeActionsParticipants()) {
                    try {
                        codeActionParticipant.doCodeAction(diagnostic, range, document, codeActions, sharedSettings, this.extensionsRegistry);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Error while processing code actions for the participant '" + codeActionParticipant.getClass().getName() + "'.", e);
                    }
                }
            }
        }
        return codeActions;
    }
}

