/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.eclipse.lemminx.services.HoverRequest;
import org.eclipse.lemminx.services.extensions.IHoverParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.MarkupContentFactory;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class XMLHover {
    private static final Logger LOGGER = Logger.getLogger(XMLHover.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLHover(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public Hover doHover(DOMDocument xmlDocument, Position position, SharedSettings settings, CancelChecker cancelChecker) {
        HoverRequest hoverRequest = null;
        try {
            hoverRequest = new HoverRequest(xmlDocument, position, settings, this.extensionsRegistry);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Failed creating HoverRequest", e);
            return null;
        }
        int offset = hoverRequest.getOffset();
        DOMNode node = hoverRequest.getNode();
        if (node == null) {
            return null;
        }
        if (node.isElement() && ((DOMElement)node).hasTagName()) {
            DOMElement element = (DOMElement)node;
            if (element.hasEndTag() && offset >= element.getEndTagOpenOffset()) {
                Range tagRange = this.getTagNameRange(TokenType.EndTag, element.getEndTagOpenOffset(), offset, xmlDocument);
                if (tagRange != null) {
                    return this.getTagHover(hoverRequest, tagRange, false);
                }
                return null;
            }
            Range tagRange = this.getTagNameRange(TokenType.StartTag, node.getStart(), offset, xmlDocument);
            if (tagRange != null) {
                return this.getTagHover(hoverRequest, tagRange, true);
            }
        } else {
            if (node.isAttribute()) {
                DOMAttr attr = (DOMAttr)node;
                if (attr.valueContainsOffset(offset)) {
                    Range attrRange = XMLPositionUtility.selectAttributeValue(attr);
                    return this.getAttrValueHover(hoverRequest, attrRange);
                }
                Range attrRange = XMLPositionUtility.selectAttributeName(attr);
                return this.getAttrNameHover(hoverRequest, attrRange);
            }
            if (node.isText()) {
                DOMText text = (DOMText)node;
                Range textRange = XMLPositionUtility.selectText(text);
                return this.getTextHover(hoverRequest, textRange);
            }
        }
        return null;
    }

    private Hover getTagHover(HoverRequest hoverRequest, Range tagRange, boolean open) {
        hoverRequest.setHoverRange(tagRange);
        hoverRequest.setOpen(open);
        ArrayList<Hover> hovers = new ArrayList<Hover>();
        for (IHoverParticipant participant : this.extensionsRegistry.getHoverParticipants()) {
            try {
                Hover hover = participant.onTag(hoverRequest);
                if (hover == null) continue;
                hovers.add(hover);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing IHoverParticipant#onTag", e);
            }
        }
        return XMLHover.mergeHover(hovers, tagRange);
    }

    private Range getTagNameRange(TokenType tokenType, int startOffset, int offset, DOMDocument document) {
        Scanner scanner = XMLScanner.createScanner(document.getText(), startOffset);
        TokenType token = scanner.scan();
        while (token != TokenType.EOS && (scanner.getTokenEnd() < offset || scanner.getTokenEnd() == offset && token != tokenType)) {
            token = scanner.scan();
        }
        if (token == tokenType && offset <= scanner.getTokenEnd()) {
            try {
                return new Range(document.positionAt(scanner.getTokenOffset()), document.positionAt(scanner.getTokenEnd()));
            }
            catch (BadLocationException e) {
                LOGGER.log(Level.SEVERE, "While creating Range in XMLHover the Scanner's Offset was a BadLocation", e);
                return null;
            }
        }
        return null;
    }

    private Hover getAttrNameHover(HoverRequest hoverRequest, Range attrRange) {
        hoverRequest.setHoverRange(attrRange);
        ArrayList<Hover> hovers = new ArrayList<Hover>();
        for (IHoverParticipant participant : this.extensionsRegistry.getHoverParticipants()) {
            try {
                Hover hover = participant.onAttributeName(hoverRequest);
                if (hover == null) continue;
                hovers.add(hover);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing IHoverParticipant#onAttributeName", e);
            }
        }
        return XMLHover.mergeHover(hovers, attrRange);
    }

    private Hover getAttrValueHover(HoverRequest hoverRequest, Range attrRange) {
        hoverRequest.setHoverRange(attrRange);
        ArrayList<Hover> hovers = new ArrayList<Hover>();
        for (IHoverParticipant participant : this.extensionsRegistry.getHoverParticipants()) {
            try {
                Hover hover = participant.onAttributeValue(hoverRequest);
                if (hover == null) continue;
                hovers.add(hover);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing IHoverParticipant#onAttributeValue", e);
            }
        }
        return XMLHover.mergeHover(hovers, attrRange);
    }

    private Hover getTextHover(HoverRequest hoverRequest, Range textRange) {
        hoverRequest.setHoverRange(textRange);
        ArrayList<Hover> hovers = new ArrayList<Hover>();
        for (IHoverParticipant participant : this.extensionsRegistry.getHoverParticipants()) {
            try {
                Hover hover = participant.onText(hoverRequest);
                if (hover == null) continue;
                hovers.add(hover);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "While performing IHoverParticipant#onText", e);
            }
        }
        return XMLHover.mergeHover(hovers, textRange);
    }

    private static Hover mergeHover(List<Hover> hovers, Range defaultRange) {
        if (hovers.isEmpty()) {
            return null;
        }
        if (hovers.size() == 1) {
            Hover hover2 = hovers.get(0);
            if (hover2.getRange() == null) {
                hover2.setRange(defaultRange);
            }
            return hover2;
        }
        List<MarkupContent> contents = hovers.stream().filter(hover -> hover.getContents() != null && hover.getContents().isRight() && hover.getContents().getRight() != null).map(hover -> (MarkupContent)hover.getContents().getRight()).collect(Collectors.toList());
        Range range = defaultRange;
        for (Hover hover3 : hovers) {
            if (hover3.getRange() == null || range != null) continue;
            range = hover3.getRange();
        }
        return MarkupContentFactory.createHover(contents, range);
    }
}

