/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemCapabilities;
import org.junit.jupiter.api.Test;

public class XMLModelCompletionExtensionsTest {
    @Test
    public void completionBasedOnDTDWithXMLModel() throws BadLocationException {
        String xml = "<?xml version=\"1.0\"?>\r\n<?xml-model href=\"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\"?>\r\n\r\n  <catalog xmlns=\"urn:oasis:names:tc:entity:xmlns:xml:catalog\"\r\n           prefer=\"public\">\r\n\r\n    <|";
        XMLModelCompletionExtensionsTest.testCompletionFor(xml, XMLAssert.c("delegatePublic", XMLAssert.te(6, 4, 6, 5, "<delegatePublic publicIdStartString=\"$1\" catalog=\"$2\" />$0"), "<delegatePublic"), XMLAssert.c("public", XMLAssert.te(6, 4, 6, 5, "<public publicId=\"$1\" uri=\"$2\" />$0"), "<public"));
    }

    @Test
    public void completionBasedOnXSDWithXMLModel() throws BadLocationException {
        String xml = "<?xml-model href=\"http://maven.apache.org/xsd/maven-4.0.0.xsd\"?>\r\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\">\r\n\t<|</project>";
        XMLModelCompletionExtensionsTest.testCompletionFor(xml, XMLAssert.c("modelVersion", XMLAssert.te(2, 1, 2, 2, "<modelVersion>$1</modelVersion>$0"), "<modelVersion"), XMLAssert.c("parent", "<parent>$1</parent>$0", "<parent"));
    }

    @Test
    public void completionBasedOnDTDAndXSDBoth() throws BadLocationException {
        String xml = "<?xml-model href=\"grammar.dtd\" ?>\r\n<?xml-model href=\"grammar.xsd\" ?>\r\n<grammar>\r\n\t<|</grammar>";
        XMLAssert.testCompletionFor(xml, null, "src/test/resources/xml-model/grammar.xml", 5, XMLAssert.c("from-xsd", "<from-xsd></from-xsd>"), XMLAssert.c("from-dtd", "<from-dtd></from-dtd>"));
    }

    private static void testCompletionFor(String xml, CompletionItem ... expectedItems) throws BadLocationException {
        XMLModelCompletionExtensionsTest.testCompletionFor(xml, true, null, expectedItems);
    }

    private static void testCompletionFor(String xml, boolean isSnippetsSupported, Integer expectedCount, CompletionItem ... expectedItems) throws BadLocationException {
        CompletionCapabilities completionCapabilities = new CompletionCapabilities();
        CompletionItemCapabilities completionItem = new CompletionItemCapabilities(Boolean.valueOf(isSnippetsSupported));
        completionCapabilities.setCompletionItem(completionItem);
        SharedSettings sharedSettings = new SharedSettings();
        sharedSettings.getCompletionSettings().setCapabilities(completionCapabilities);
        XMLAssert.testCompletionFor(new XMLLanguageService(), xml, "src/test/resources/catalogs/catalog.xml", null, null, expectedCount, sharedSettings, expectedItems);
    }
}

