/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.settings;

import org.eclipse.lemminx.extensions.contentmodel.settings.XMLNamespacesSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLSchemaSettings;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.PublishDiagnosticsCapabilities;

public class XMLValidationSettings {
    private Boolean enabled;
    private XMLNamespacesSettings namespaces;
    private XMLSchemaSettings schema;
    private boolean disallowDocTypeDecl;
    private boolean resolveExternalEntities;
    private String noGrammar;
    private PublishDiagnosticsCapabilities publishDiagnostics;

    public XMLValidationSettings() {
        this.setEnabled(true);
        this.setDisallowDocTypeDecl(false);
        this.setResolveExternalEntities(false);
        this.setNamespaces(new XMLNamespacesSettings());
        this.setSchema(new XMLSchemaSettings());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public XMLNamespacesSettings getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(XMLNamespacesSettings namespaces) {
        this.namespaces = namespaces;
    }

    public XMLSchemaSettings getSchema() {
        return this.schema;
    }

    public void setSchema(XMLSchemaSettings schema) {
        this.schema = schema;
    }

    public void setNoGrammar(String noGrammar) {
        this.noGrammar = noGrammar;
    }

    public String getNoGrammar() {
        return this.noGrammar;
    }

    public boolean isDisallowDocTypeDecl() {
        return this.disallowDocTypeDecl;
    }

    public void setDisallowDocTypeDecl(boolean disallowDocTypeDecl) {
        this.disallowDocTypeDecl = disallowDocTypeDecl;
    }

    public boolean isResolveExternalEntities() {
        return this.resolveExternalEntities;
    }

    public void setResolveExternalEntities(boolean resolveExternalEntities) {
        this.resolveExternalEntities = resolveExternalEntities;
    }

    public static DiagnosticSeverity getNoGrammarSeverity(XMLValidationSettings validationSettings) {
        DiagnosticSeverity defaultSeverity = DiagnosticSeverity.Hint;
        if (validationSettings == null) {
            return defaultSeverity;
        }
        String noGrammar = validationSettings.getNoGrammar();
        if ("ignore".equalsIgnoreCase(noGrammar)) {
            return null;
        }
        if ("info".equalsIgnoreCase(noGrammar)) {
            return DiagnosticSeverity.Information;
        }
        if ("warning".equalsIgnoreCase(noGrammar)) {
            return DiagnosticSeverity.Warning;
        }
        if ("error".equalsIgnoreCase(noGrammar)) {
            return DiagnosticSeverity.Error;
        }
        return defaultSeverity;
    }

    public XMLValidationSettings merge(XMLValidationSettings settings) {
        if (settings != null) {
            this.namespaces = settings.namespaces;
            this.schema = settings.schema;
            this.enabled = settings.enabled;
            this.disallowDocTypeDecl = settings.disallowDocTypeDecl;
            this.resolveExternalEntities = settings.resolveExternalEntities;
        }
        return this;
    }

    public void setCapabilities(PublishDiagnosticsCapabilities publishDiagnostics) {
        this.publishDiagnostics = publishDiagnostics;
    }

    public boolean isRelatedInformation() {
        return this.publishDiagnostics != null && this.publishDiagnostics.getRelatedInformation() != null && this.publishDiagnostics.getRelatedInformation() != false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.disallowDocTypeDecl ? 1231 : 1237);
        result = 31 * result + (this.enabled == null ? 0 : this.enabled.hashCode());
        result = 31 * result + (this.namespaces == null ? 0 : this.namespaces.hashCode());
        result = 31 * result + (this.noGrammar == null ? 0 : this.noGrammar.hashCode());
        result = 31 * result + (this.resolveExternalEntities ? 1231 : 1237);
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLValidationSettings other = (XMLValidationSettings)obj;
        if (this.disallowDocTypeDecl != other.disallowDocTypeDecl) {
            return false;
        }
        if (this.enabled == null ? other.enabled != null : !this.enabled.equals(other.enabled)) {
            return false;
        }
        if (this.namespaces == null ? other.namespaces != null : !this.namespaces.equals(other.namespaces)) {
            return false;
        }
        if (this.noGrammar == null ? other.noGrammar != null : !this.noGrammar.equals(other.noGrammar)) {
            return false;
        }
        if (this.resolveExternalEntities != other.resolveExternalEntities) {
            return false;
        }
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }
}

