/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.general;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.OSUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.junit.jupiter.api.Test;

public class FilePathCompletionTest {
    private static final String userDir = FilesUtils.encodePath((String)System.getProperty("user.dir"));
    private static final String userDirBackSlash = userDir.replace("/", "\\");
    private static final String userDirForwardSlash = userDir.replace("\\", "/");

    @Test
    public void testFilePathCompletion() throws BadLocationException {
        String xml = "<a path=\"./|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 10, 11, "folderA", "folderB", "NestedA");
        FilePathCompletionTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionBackSlash() throws BadLocationException {
        String xml = "<a path=\".\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 10, 11, "folderA", "folderB", "NestedA");
        FilePathCompletionTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionFolderA() throws BadLocationException {
        String xml = "<a path=\"./folderA/|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 18, 19, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionFolderABackSlash() throws BadLocationException {
        String xml = "<a path=\".\\folderA\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 18, 19, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionFolderB() throws BadLocationException {
        String xml = "<a path=\"folderB/|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 16, 17, "xsdB1.xsd", "xmlB1.xml");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionFolderBBackSlash() throws BadLocationException {
        String xml = "<a path=\"folderB\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 16, 17, "xsdB1.xsd", "xmlB1.xml");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionFolderBAbsolutePath() throws BadLocationException {
        String filePath = userDirForwardSlash + "/src/test/resources/filePathCompletion/folderB/";
        int filePathLength = filePath.length();
        String xml = "<a path=\"" + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 9 + filePathLength - 1, 9 + filePathLength, "xsdB1.xsd", "xmlB1.xml");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionFolderBAbsolutePathBackSlash() throws BadLocationException {
        if (!OSUtils.isWindows) {
            return;
        }
        String filePath = userDirBackSlash + "\\src\\test\\resources\\filePathCompletion\\folderB\\";
        int filePathLength = filePath.length();
        String xml = "<a path=\"" + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 9 + filePathLength - 1, 9 + filePathLength, "xsdB1.xsd", "xmlB1.xml");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionFolderBAbsolutePathWithFileScheme() throws BadLocationException {
        String filePath = (OSUtils.isWindows ? "file:///" : "file://") + userDirForwardSlash + "/src/test/resources/filePathCompletion/folderB/";
        int filePathLength = filePath.length();
        String xml = "<a path=\"" + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 9 + filePathLength - 1, 9 + filePathLength, "xsdB1.xsd", "xmlB1.xml");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionNestedA() throws BadLocationException {
        String xml = "<a path=\"NestedA/|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 16, 17, "NestedB");
        FilePathCompletionTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionNestedABackSlash() throws BadLocationException {
        String xml = "<a path=\"NestedA\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 16, 17, "NestedB");
        FilePathCompletionTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionNestedBIncomplete() throws BadLocationException {
        String xml = "<a path=\"NestedA/NestedB/ZZZ|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 24, 28, "nestedXSD.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionNestedBIncompleteBackSlash() throws BadLocationException {
        String xml = "<a path=\"NestedA\\NestedB\\ZZZ|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 24, 28, "nestedXSD.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionExtraTextInValue() throws BadLocationException {
        String xml = "<a path=\"NAMESPACE_IGNORE_ME NestedA/NestedB/|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 44, 45, "nestedXSD.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionExtraTextInValueBackSlash() throws BadLocationException {
        String xml = "<a path=\"NAMESPACE_IGNORE_ME NestedA\\NestedB\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 44, 45, "nestedXSD.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionExtraTextInValueAbsolute() throws BadLocationException {
        String filePath = userDirForwardSlash + "/src/test/resources/filePathCompletion/NestedA/NestedB/";
        int filePathLength = filePath.length();
        String xml = "<a path=\"NAMESPACE_IGNORE_ME " + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 29 + filePathLength - 1, 29 + filePathLength, "nestedXSD.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionExtraTextInValueAbsoluteBackSlash() throws BadLocationException {
        String filePath = userDirBackSlash + "\\src\\test\\resources\\filePathCompletion\\NestedA\\NestedB\\";
        int filePathLength = filePath.length();
        String xml = "<a path=\"NAMESPACE_IGNORE_ME " + filePath + "|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 29 + filePathLength - 1, 29 + filePathLength, "nestedXSD.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 1, items);
    }

    @Test
    public void testFilePathCompletionBadFolder() throws BadLocationException {
        String xml = "<a path=\"NestedA/BAD_FOLDER/|\">";
        FilePathCompletionTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionBadFolderBackSlash() throws BadLocationException {
        String xml = "<a path=\"NestedA\\BAD_FOLDER\\|\">";
        FilePathCompletionTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionStartWithDotDot() throws BadLocationException {
        String xml = "<a path=\"../filePathCompletion/folderA/|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 38, 39, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionStartWithDotDotBackSlash() throws BadLocationException {
        String xml = "<a path=\"..\\filePathCompletion\\folderA\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 38, 39, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionStartWithDot() throws BadLocationException {
        String xml = "<a path=\"./folderA/|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 18, 19, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionStartWithDotBackSlash() throws BadLocationException {
        String xml = "<a path=\".\\folderA\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 18, 19, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionEndsWithFileAndSlash() throws BadLocationException {
        String xml = "<a path=\"./randomFile.aaa/|\">";
        FilePathCompletionTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionEndsWithFileAndBackSlash() throws BadLocationException {
        String xml = "<a path=\".\\randomFile.aaa\\|\">";
        FilePathCompletionTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionNotValue() throws BadLocationException {
        String xml = "<a path=\"|\">";
        FilePathCompletionTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionDTD() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"./|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 23, 24, "folderA", "folderB", "NestedA");
        FilePathCompletionTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionDTDBackSlash() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \".\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 23, 24, "folderA", "folderB", "NestedA");
        FilePathCompletionTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionDTDFolderA() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"./folderA/|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 31, 32, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionDTDFolderABackSlash() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \".\\folderA\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 31, 32, "xsdA1.xsd", "xsdA2.xsd");
        FilePathCompletionTest.testCompletionFor(xml, items);
    }

    @Test
    public void testFilePathCompletionDTDFolderB() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"folderB/|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 29, 30, "xsdB1.xsd", "xmlB1.xml");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionDTDFolderBBackSlash() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"folderB\\|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("\\", 0, 29, 30, "xsdB1.xsd", "xmlB1.xml");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathNoCompletion() throws BadLocationException {
        String xml = "<!DOCTYPE foo SYSTEM \"|\">";
        FilePathCompletionTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathNoCompletionMissingSystemId() throws BadLocationException {
        String xml = "<!DOCTYPE foo \"./|\">";
        FilePathCompletionTest.testCompletionFor(xml, 0, new CompletionItem[0]);
    }

    @Test
    public void testFilePathCompletionWithSpacesFolder() throws BadLocationException {
        String xml = "<a path=\"folderC/|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 16, 17, "a@b", "with%20spaces");
        FilePathCompletionTest.testCompletionFor(xml, 2, items);
    }

    @Test
    public void testFilePathCompletionInsideSpecialChars() throws BadLocationException {
        String xml = "<a path=\"../|\">";
        CompletionItem[] items = FilePathCompletionTest.getCompletionItemList("/", 0, 11, 12, "a@b", "with%20spaces");
        String fileURI = "file://" + userDirForwardSlash + "/src/test/resources/filePathCompletion/folderC/a@b/foo.xml";
        XMLAssert.testCompletionFor(xml, null, fileURI, 2, items);
    }

    private static void testCompletionFor(String xml, CompletionItem ... expectedItems) throws BadLocationException {
        FilePathCompletionTest.testCompletionFor(xml, null, expectedItems);
    }

    private static void testCompletionFor(String xml, Integer expectedItemCount, CompletionItem ... expectedItems) throws BadLocationException {
        String fileURI = "file://" + userDirForwardSlash + "/src/test/resources/filePathCompletion/main.xml";
        XMLAssert.testCompletionFor(xml, null, fileURI, expectedItemCount, expectedItems);
    }

    private static CompletionItem[] getCompletionItemList(String slash, int line, int startChar, int endChar, String ... fileOrFolderNames) {
        String s = slash;
        int fOfSize = fileOrFolderNames.length;
        CompletionItem[] items = new CompletionItem[fOfSize];
        for (int i = 0; i < fOfSize; ++i) {
            String fOf = s + fileOrFolderNames[i];
            items[i] = XMLAssert.c(fOf, XMLAssert.te(line, startChar, line, endChar, fOf), fOf);
        }
        return items;
    }
}

