/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.io.IOException;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.SymbolKind;
import org.junit.jupiter.api.Test;

public class ReferencedGrammarSymbolsTest {
    @Test
    public void withDoctype() throws BadLocationException, URI.MalformedURIException {
        String dtdFileURI = ReferencedGrammarSymbolsTest.getDTDFileURI("src/test/resources/dtd/entities/base.dtd");
        String xml = "<!DOCTYPE root-element SYSTEM \"dtd/entities/base.dtd\">\r\n<root-element>\r\n</root-element>";
        XMLAssert.testDocumentSymbolsFor(xml, "src/test/resources/base.xml", XMLAssert.ds("Grammars", SymbolKind.Module, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds(dtdFileURI, SymbolKind.File, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds("Binding: doctype", SymbolKind.Property, XMLAssert.r(0, 30, 0, 53), XMLAssert.r(0, 30, 0, 53), null, null), XMLAssert.ds("Cache: false", SymbolKind.Property, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null))))), XMLAssert.ds("DOCTYPE:root-element", SymbolKind.Struct, XMLAssert.r(0, 0, 0, 54), XMLAssert.r(0, 0, 0, 54), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("root-element", SymbolKind.Field, XMLAssert.r(1, 0, 2, 15), XMLAssert.r(1, 0, 2, 15), null, Arrays.asList(new DocumentSymbol[0])));
    }

    @Test
    public void withNoNamespaceSchemaLocation() throws BadLocationException, URI.MalformedURIException {
        String xml = "<Configuration\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xsi:noNamespaceSchemaLocation=\"xsd/Format.xsd\">\r\n</Configuration>";
        XMLAssert.testDocumentSymbolsFor(xml, "src/test/resources/Test.Format.ps1xml", XMLAssert.ds("Grammars", SymbolKind.Module, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds(ReferencedGrammarSymbolsTest.getXMLSchemaFileURI("Format.xsd", false), SymbolKind.File, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds("Binding: xsi:noNamespaceSchemaLocation", SymbolKind.Property, XMLAssert.r(2, 34, 2, 50), XMLAssert.r(2, 34, 2, 50), null, null), XMLAssert.ds("Cache: false", SymbolKind.Property, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null))))), XMLAssert.ds("Configuration", SymbolKind.Field, XMLAssert.r(0, 0, 3, 16), XMLAssert.r(0, 0, 3, 16), null, Arrays.asList(new DocumentSymbol[0])));
    }

    @Test
    public void withSchemaLocation() throws BadLocationException, URI.MalformedURIException {
        String xml = "<team\r\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n    xmlns:xsi=\"team_namespace\"\r\n    xsi:schemaLocation=\"team_namespace xsd/team.xsd\">\r\n</team>";
        XMLAssert.testDocumentSymbolsFor(xml, "src/test/resources/team.xml", XMLAssert.ds("Grammars", SymbolKind.Module, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds(ReferencedGrammarSymbolsTest.getXMLSchemaFileURI("team.xsd", false), SymbolKind.File, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds("Binding: xsi:schemaLocation", SymbolKind.Property, XMLAssert.r(3, 39, 3, 51), XMLAssert.r(3, 39, 3, 51), null, null), XMLAssert.ds("Cache: false", SymbolKind.Property, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null))))), XMLAssert.ds("team", SymbolKind.Field, XMLAssert.r(0, 0, 4, 7), XMLAssert.r(0, 0, 4, 7), null, Arrays.asList(new DocumentSymbol[0])));
    }

    @Test
    public void withXMLModel() throws BadLocationException, URI.MalformedURIException {
        String xml = "<?xml-model href=\"xsd/Format.xsd\" ?>\r\n<Configuration>\r\n</Configuration>";
        XMLAssert.testDocumentSymbolsFor(xml, "src/test/resources/Test.Format.ps1xml", XMLAssert.ds("Grammars", SymbolKind.Module, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds(ReferencedGrammarSymbolsTest.getXMLSchemaFileURI("Format.xsd", false), SymbolKind.File, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds("Binding: xml-model", SymbolKind.Property, XMLAssert.r(0, 17, 0, 33), XMLAssert.r(0, 17, 0, 33), null, null), XMLAssert.ds("Cache: false", SymbolKind.Property, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null))))), XMLAssert.ds("xml-model", SymbolKind.Property, XMLAssert.r(0, 0, 0, 36), XMLAssert.r(0, 0, 0, 36), null, Arrays.asList(new DocumentSymbol[0])), XMLAssert.ds("Configuration", SymbolKind.Field, XMLAssert.r(1, 0, 2, 16), XMLAssert.r(1, 0, 2, 16), null, Arrays.asList(new DocumentSymbol[0])));
    }

    @Test
    public void withFileAssociation() throws BadLocationException, URI.MalformedURIException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(ReferencedGrammarSymbolsTest.createXSDAssociations("src/test/resources/xsd/"));
        };
        String xml = "<Configuration></Configuration>";
        XMLAssert.testDocumentSymbolsFor(xml, "file:///test/Test.Format.ps1xml", new XMLSymbolSettings(), configuration, XMLAssert.ds("Grammars", SymbolKind.Module, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds(ReferencedGrammarSymbolsTest.getXMLSchemaFileURI("Format.xsd", false), SymbolKind.File, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds("Binding: with file association", SymbolKind.Property, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null), XMLAssert.ds("Cache: false", SymbolKind.Property, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null))))), XMLAssert.ds("Configuration", SymbolKind.Field, XMLAssert.r(0, 0, 0, 31), XMLAssert.r(0, 0, 0, 31), null, Arrays.asList(new DocumentSymbol[0])));
    }

    @Test
    public void withCache() throws BadLocationException, IOException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(true);
        };
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n</project>";
        String cachedResolvedUri = CacheResourcesManager.getResourceCachePath((String)"http://maven.apache.org/xsd/maven-4.0.0.xsd").toUri().toString();
        XMLAssert.testDocumentSymbolsFor(xml, "pom.xml", new XMLSymbolSettings(), configuration, XMLAssert.ds("Grammars", SymbolKind.Module, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds("http://maven.apache.org/xsd/maven-4.0.0.xsd", SymbolKind.File, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds("Binding: xsi:schemaLocation", SymbolKind.Property, XMLAssert.r(2, 55, 2, 98), XMLAssert.r(2, 55, 2, 98), null, null), XMLAssert.ds("Cache", SymbolKind.Property, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds(cachedResolvedUri, SymbolKind.File, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null))))))), XMLAssert.ds("project", SymbolKind.Field, XMLAssert.r(0, 0, 3, 10), XMLAssert.r(0, 0, 3, 10), null, Arrays.asList(new DocumentSymbol[0])));
    }

    @Test
    public void withCatalog() throws BadLocationException, URI.MalformedURIException {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setUseCache(true);
            contentModelManager.setCatalogs(new String[]{"src/test/resources/catalogs/catalog.xml"});
        };
        String xml = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n</project>";
        XMLAssert.testDocumentSymbolsFor(xml, "pom.xml", new XMLSymbolSettings(), configuration, XMLAssert.ds("Grammars", SymbolKind.Module, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds(ReferencedGrammarSymbolsTest.getXMLSchemaFileURI("maven-4.0.0.xsd", true), SymbolKind.File, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, Arrays.asList(XMLAssert.ds("Binding: xsi:schemaLocation (with catalog)", SymbolKind.Property, XMLAssert.r(2, 55, 2, 98), XMLAssert.r(2, 55, 2, 98), null, null), XMLAssert.ds("Cache: false", SymbolKind.Property, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), null, null))))), XMLAssert.ds("project", SymbolKind.Field, XMLAssert.r(0, 0, 3, 10), XMLAssert.r(0, 0, 3, 10), null, Arrays.asList(new DocumentSymbol[0])));
    }

    private static XMLFileAssociation[] createXSDAssociations(String baseSystemId) {
        XMLFileAssociation format = new XMLFileAssociation();
        format.setPattern("**/*.Format.ps1xml");
        format.setSystemId(baseSystemId + "Format.xsd");
        XMLFileAssociation resources = new XMLFileAssociation();
        resources.setPattern("**/*resources*.xml");
        resources.setSystemId(baseSystemId + "resources.xsd");
        return new XMLFileAssociation[]{format, resources};
    }

    private static String getXMLSchemaFileURI(String schemaURI, boolean replaceSlash) throws URI.MalformedURIException {
        String result = XMLEntityManager.expandSystemId((String)("xsd/" + schemaURI), (String)"src/test/resources/test.xml", (boolean)true);
        if (replaceSlash) {
            return result.replace("///", "/");
        }
        return result;
    }

    private static String getDTDFileURI(String dtdURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)dtdURI, (String)"test.xml", (boolean)true);
    }
}

