/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xmlmodel.contentmodel;

import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.utils.StringUtils;

public class CMXMLModelContentModelProvider
implements ContentModelProvider {
    private final ContentModelManager modelManager;

    public CMXMLModelContentModelProvider(ContentModelManager modelManager) {
        this.modelManager = modelManager;
    }

    @Override
    public boolean adaptFor(DOMDocument document, boolean internal) {
        if (internal) {
            return false;
        }
        return document.hasXMLModel();
    }

    @Override
    public boolean adaptFor(String uri) {
        return false;
    }

    @Override
    public Collection<String> getSystemIds(DOMDocument xmlDocument, String namespaceURI) {
        return xmlDocument.getXMLModels().stream().map(node -> node.getHref()).filter(href -> !StringUtils.isEmpty(href)).collect(Collectors.toList());
    }

    @Override
    public CMDocument createCMDocument(String uri) {
        ContentModelProvider modelProvider = this.modelManager.getModelProviderByURI(uri);
        return modelProvider != null ? modelProvider.createCMDocument(uri) : null;
    }

    @Override
    public CMDocument createInternalCMDocument(DOMDocument xmlDocument) {
        return null;
    }
}

