/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class LSPSAXParser
extends SAXParser {
    private static final String DTD_NOT_FOUND = "Cannot find DTD ''{0}''.\nCreate the DTD file or configure an XML catalog for this DTD.";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private final DOMDocument document;
    private final LSPErrorReporterForXML reporter;
    private final XMLGrammarPool grammarPool;
    private XMLLocator locator;

    public LSPSAXParser(DOMDocument document, LSPErrorReporterForXML reporter, XMLParserConfiguration config, XMLGrammarPool grammarPool) {
        super(config);
        this.document = document;
        this.reporter = reporter;
        this.grammarPool = grammarPool;
        this.init(reporter);
    }

    private void init(LSPErrorReporterForXML reporter) {
        try {
            super.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)reporter);
            super.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            super.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            super.setFeature("http://xml.org/sax/features/namespaces", true);
            super.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.locator = locator;
        super.startDocument(locator, encoding, namespaceContext, augs);
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (systemId != null) {
            String eid = null;
            try {
                eid = XMLEntityManager.expandSystemId((String)systemId, (String)this.locator.getExpandedSystemId(), (boolean)false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!LSPSAXParser.isDTDExists(eid)) {
                try {
                    DOMDocumentType docType = this.document.getDoctype();
                    Range range = new Range(this.document.positionAt(docType.getSystemIdNode().getStart()), this.document.positionAt(docType.getSystemIdNode().getEnd()));
                    this.reporter.addDiagnostic(range, MessageFormat.format(DTD_NOT_FOUND, eid), DiagnosticSeverity.Error, DTDErrorCode.dtd_not_found.getCode());
                }
                catch (BadLocationException docType) {
                    // empty catch block
                }
                ValidationManager fValidationManager = (ValidationManager)this.fConfiguration.getProperty(VALIDATION_MANAGER);
                if (fValidationManager != null) {
                    fValidationManager.setCachedDTD(true);
                }
            } else if (this.grammarPool != null) {
                XMLEntityManager entityManager = (XMLEntityManager)this.fConfiguration.getProperty(ENTITY_MANAGER);
                XMLDTDDescription grammarDesc = new XMLDTDDescription(publicId, systemId, this.locator.getExpandedSystemId(), eid, rootElement);
                DTDGrammar grammar = (DTDGrammar)this.grammarPool.retrieveGrammar((XMLGrammarDescription)grammarDesc);
                if (grammar != null) {
                    LSPSAXParser.fillEntities(grammar, entityManager);
                }
            }
        }
        super.doctypeDecl(rootElement, publicId, systemId, augs);
    }

    private static boolean isDTDExists(String expandedSystemId) {
        if (expandedSystemId == null || expandedSystemId.isEmpty()) {
            return true;
        }
        try {
            URL location = new URL(expandedSystemId);
            URLConnection connect = location.openConnection();
            if (!(connect instanceof HttpURLConnection)) {
                InputStream stream = connect.getInputStream();
                stream.close();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static void fillEntities(DTDGrammar grammar, final XMLEntityManager entityManager) {
        int index = 0;
        XMLEntityDecl entityDecl = new XMLEntityDecl(){

            public void setValues(String name, String publicId, String systemId, String baseSystemId, String notation, String value, boolean isPE, boolean inExternal) {
                if (inExternal) {
                    entityManager.addInternalEntity(name, value);
                }
            }
        };
        while (grammar.getEntityDecl(index, entityDecl)) {
            ++index;
        }
    }
}

