/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.asset;

import java.util.Map;
import org.eclipse.kura.internal.wire.asset.TimestampMode;

class WireAssetOptions {
    public static final String EMIT_ALL_CHANNELS_PROP_NAME = "emit.all.channels";
    public static final String TIMESTAMP_MODE_PROP_NAME = "timestamp.mode";
    public static final String EMIT_ERRORS_PROP_NAME = "emit.errors";
    public static final String EMIT_CONNECTION_ERRORS_PROP_NAME = "emit.connection.errors";
    public static final String EMIT_ON_CHANGE_PROP_NAME = "emit.on.change";
    public static final String EMIT_EMPTY_ENVELOPES_PROP_NAME = "emit.empty.envelopes";
    private boolean emitAllChannels;
    private TimestampMode timestampMode;
    private boolean emitErrors;
    private boolean emitConnectionErrors;
    private boolean emitOnChange;
    private boolean emitEmptyEnvelopes;

    public WireAssetOptions() {
    }

    public WireAssetOptions(Map<String, Object> properties) {
        Object emitAllChannelsProp = properties.get(EMIT_ALL_CHANNELS_PROP_NAME);
        Object emitErrorsProp = properties.get(EMIT_ERRORS_PROP_NAME);
        Object emitConnectionErrorsProp = properties.get(EMIT_CONNECTION_ERRORS_PROP_NAME);
        Object emitOnChangeProp = properties.get(EMIT_ON_CHANGE_PROP_NAME);
        Object emitEmptyEnvelopesProp = properties.get(EMIT_EMPTY_ENVELOPES_PROP_NAME);
        this.emitAllChannels = emitAllChannelsProp instanceof Boolean && (Boolean)emitAllChannelsProp != false;
        this.emitErrors = emitErrorsProp instanceof Boolean && (Boolean)emitErrorsProp != false;
        this.emitConnectionErrors = emitConnectionErrorsProp instanceof Boolean && (Boolean)emitConnectionErrorsProp != false;
        this.emitOnChange = emitOnChangeProp instanceof Boolean && (Boolean)emitOnChangeProp != false;
        this.emitEmptyEnvelopes = !(emitEmptyEnvelopesProp instanceof Boolean) || (Boolean)emitEmptyEnvelopesProp != false;
        this.timestampMode = WireAssetOptions.extractTimestampMode(properties);
    }

    public boolean emitAllChannels() {
        return this.emitAllChannels;
    }

    public TimestampMode getTimestampMode() {
        return this.timestampMode;
    }

    public boolean emitErrors() {
        return this.emitErrors;
    }

    public boolean emitConnectionErrors() {
        return this.emitConnectionErrors;
    }

    public boolean emitOnChange() {
        return this.emitOnChange;
    }

    public boolean emitEmptyEnvelopes() {
        return this.emitEmptyEnvelopes;
    }

    private static TimestampMode extractTimestampMode(Map<String, Object> properties) {
        try {
            return TimestampMode.valueOf(properties.get(TIMESTAMP_MODE_PROP_NAME).toString());
        }
        catch (Exception exception) {
            return TimestampMode.PER_CHANNEL;
        }
    }
}

