/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.session;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.web.session.SecurityHandler;

public class RoutingSecurityHandler
implements SecurityHandler {
    private final List<RouteHandler> handlers = new ArrayList<RouteHandler>();
    private final SecurityHandler defaultHandler;

    public RoutingSecurityHandler(SecurityHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public void addRouteHandler(Predicate<String> uriMatcher, SecurityHandler handler) {
        this.handlers.add(new RouteHandler(uriMatcher, handler));
    }

    @Override
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestURI = request.getRequestURI();
        for (RouteHandler handler : this.handlers) {
            if (!handler.uriMatcher.test(requestURI)) continue;
            return handler.handler.handleSecurity(request, response);
        }
        return this.defaultHandler.handleSecurity(request, response);
    }

    private static class RouteHandler {
        private final Predicate<String> uriMatcher;
        private final SecurityHandler handler;

        public RouteHandler(Predicate<String> uriMatcher, SecurityHandler handler) {
            this.uriMatcher = uriMatcher;
            this.handler = handler;
        }
    }
}

