/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.identity.AdditionalConfigurations;
import org.eclipse.kura.identity.AssignedPermissions;
import org.eclipse.kura.identity.IdentityConfiguration;
import org.eclipse.kura.identity.IdentityConfigurationComponent;
import org.eclipse.kura.identity.IdentityService;
import org.eclipse.kura.identity.PasswordConfiguration;
import org.eclipse.kura.identity.Permission;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.KuraPermission;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtUserConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManager {
    private static final Set<Class<? extends IdentityConfigurationComponent>> ALL_COMPONENTS = new HashSet<Class>(Arrays.asList(PasswordConfiguration.class, AssignedPermissions.class, AdditionalConfigurations.class));
    private static final Logger logger = LoggerFactory.getLogger(UserManager.class);
    private final IdentityService identityService;

    public UserManager(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void update() {
        this.initializeUserAdmin();
    }

    public void authenticateWithPassword(String username, String password) throws GwtKuraException {
        try {
            this.identityService.checkPassword(username, password.toCharArray());
        }
        catch (Exception e) {
            throw this.toGwt(e);
        }
    }

    public void requirePermissions(String username, String ... requiredPermissions) throws GwtKuraException {
        try {
            AssignedPermissions assignedPermissions = (AssignedPermissions)this.identityService.getIdentityConfiguration(username, Collections.singleton(AssignedPermissions.class)).flatMap(i -> i.getComponent(AssignedPermissions.class)).orElseThrow(() -> new KuraException(KuraErrorCode.SECURITY_EXCEPTION, new Object[]{"Identity not found"}));
            if (assignedPermissions.getPermissions().contains(new Permission("admin"))) {
                return;
            }
            String[] stringArray = requiredPermissions;
            int n = requiredPermissions.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredPermission = stringArray[n2];
                if (!assignedPermissions.getPermissions().contains(new Permission(requiredPermission))) {
                    throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION, new Object[]{"identity does not have the " + requiredPermission + " perimission"});
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw this.toGwt(e);
        }
    }

    public boolean isPasswordChangeRequired(String username) throws GwtKuraException {
        try {
            return this.identityService.getIdentityConfiguration(username, Collections.singleton(PasswordConfiguration.class)).flatMap(p -> p.getComponent(PasswordConfiguration.class)).map(p -> p.isPasswordChangeNeeded()).orElse(false);
        }
        catch (Exception e) {
            throw this.toGwt(e);
        }
    }

    public void createUser(String userName) throws GwtKuraException {
        try {
            this.identityService.createIdentity(userName);
        }
        catch (Exception e) {
            logger.warn("failed to create user", (Throwable)e);
            throw this.toGwt(e);
        }
    }

    public void deleteUser(String userName) throws GwtKuraException {
        try {
            this.identityService.deleteIdentity(userName);
        }
        catch (Exception e) {
            logger.warn("failed to delete user", (Throwable)e);
            throw this.toGwt(e);
        }
    }

    public void setUserPassword(String userName, String userPassword) throws GwtKuraException {
        try {
            this.identityService.updateIdentityConfiguration(new IdentityConfiguration(userName, Collections.singletonList(new PasswordConfiguration(false, true, Optional.of(userPassword.toCharArray()), Optional.empty()))));
        }
        catch (Exception e) {
            throw this.toGwt(e);
        }
    }

    public Set<String> getDefinedPermissions() throws GwtKuraException {
        try {
            return this.identityService.getPermissions().stream().map(Permission::getName).collect(Collectors.toSet());
        }
        catch (Exception e) {
            logger.warn("failed to get defined permissions", (Throwable)e);
            throw this.toGwt(e);
        }
    }

    public Set<GwtUserConfig> getUserConfig() throws GwtKuraException {
        return this.getUserConfig(ALL_COMPONENTS);
    }

    public Set<GwtUserConfig> getUserConfig(Set<Class<? extends IdentityConfigurationComponent>> componentsToReturn) throws GwtKuraException {
        try {
            return this.identityService.getIdentitiesConfiguration(componentsToReturn).stream().map(this::getUserConfig).collect(Collectors.toSet());
        }
        catch (Exception e) {
            logger.warn("failed to get user configuration", (Throwable)e);
            throw this.toGwt(e);
        }
    }

    public GwtUserConfig getUserDefaultConfig(String name) throws GwtKuraException {
        return this.getUserDefaultConfig(name, ALL_COMPONENTS);
    }

    public GwtUserConfig getUserDefaultConfig(String name, Set<Class<? extends IdentityConfigurationComponent>> componentsToReturn) throws GwtKuraException {
        try {
            return this.getUserConfig(this.identityService.getIdentityDefaultConfiguration(name, componentsToReturn));
        }
        catch (Exception e) {
            logger.warn("failed to get user default configuration", (Throwable)e);
            throw this.toGwt(e);
        }
    }

    public Optional<GwtUserConfig> getUserConfig(String name) throws GwtKuraException {
        return this.getUserConfig(name, ALL_COMPONENTS);
    }

    public Optional<GwtUserConfig> getUserConfig(String name, Set<Class<? extends IdentityConfigurationComponent>> componentsToReturn) throws GwtKuraException {
        try {
            return this.identityService.getIdentityConfiguration(name, componentsToReturn).map(this::getUserConfig);
        }
        catch (Exception e) {
            throw this.toGwt(e);
        }
    }

    public GwtUserConfig getUserConfig(IdentityConfiguration identity) {
        Optional passwordData = identity.getComponent(PasswordConfiguration.class);
        Set<String> perimissions = identity.getComponent(AssignedPermissions.class).map(AssignedPermissions::getPermissions).orElseGet(Collections::emptySet).stream().map(Permission::getName).collect(Collectors.toSet());
        Map<String, GwtConfigComponent> additionalConfigurations = identity.getComponent(AdditionalConfigurations.class).map(AdditionalConfigurations::getConfigurations).orElseGet(Collections::emptyList).stream().map(GwtServerUtil::toGwtConfigComponent).filter(Objects::nonNull).collect(Collectors.toMap(c -> c.getComponentId(), c -> c));
        return new GwtUserConfig(identity.getName(), perimissions, additionalConfigurations, passwordData.map(PasswordConfiguration::isPasswordAuthEnabled).orElse(false), passwordData.map(PasswordConfiguration::isPasswordChangeNeeded).orElse(false));
    }

    public Optional<Integer> getCredentialsHash(String userName) throws GwtKuraException {
        try {
            return this.identityService.getIdentityConfiguration(userName, Collections.singleton(PasswordConfiguration.class)).flatMap(i -> i.getComponent(PasswordConfiguration.class)).map(i -> i.getPasswordHash().hashCode());
        }
        catch (Exception e) {
            throw this.toGwt(e);
        }
    }

    public void setUserConfig(Set<GwtUserConfig> userConfigs) throws GwtKuraException {
        try {
            ArrayList<IdentityConfiguration> configurations = new ArrayList<IdentityConfiguration>();
            for (GwtUserConfig config : userConfigs) {
                configurations.add(this.buildIdentityConfiguration(config));
            }
            this.runFallibleTasks(configurations, arg_0 -> ((IdentityService)this.identityService).validateIdentityConfiguration(arg_0));
            Set existingIdentityNames = this.identityService.getIdentitiesConfiguration(Collections.emptySet()).stream().map(IdentityConfiguration::getName).collect(Collectors.toSet());
            for (String existingIdentity : existingIdentityNames) {
                if (!userConfigs.stream().noneMatch(data -> data.getUserName().equals(existingIdentity))) continue;
                try {
                    this.deleteUser(existingIdentity);
                }
                catch (Exception exception) {
                    throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{"Failed to delete identity " + existingIdentity});
                }
            }
            for (GwtUserConfig config : userConfigs) {
                if (existingIdentityNames.contains(config.getUserName())) continue;
                try {
                    this.createUser(config.getUserName());
                }
                catch (Exception exception) {
                    throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, new Object[]{"Failed to create identity " + config.getUserName()});
                }
            }
            this.runFallibleTasks(configurations, arg_0 -> ((IdentityService)this.identityService).updateIdentityConfiguration(arg_0));
        }
        catch (Exception e) {
            logger.warn("failed to update user configuration", (Throwable)e);
            throw this.toGwt(e);
        }
    }

    private IdentityConfiguration buildIdentityConfiguration(GwtUserConfig config) throws GwtKuraException {
        Set permissions = config.getPermissions().stream().map(Permission::new).collect(Collectors.toSet());
        AssignedPermissions assignedPermissions = new AssignedPermissions(permissions);
        Optional<char[]> newPassword = config.getNewPassword().map(String::toCharArray);
        PasswordConfiguration passwordData = new PasswordConfiguration(config.isPasswordChangeNeeded(), config.isPasswordAuthEnabled(), newPassword, Optional.empty());
        AdditionalConfigurations additionalConfigurations = new AdditionalConfigurations(config.getAdditionalConfigurations().values().stream().map(c -> GwtServerUtil.fromGwtConfigComponent(c, null)).filter(Objects::nonNull).collect(Collectors.toList()));
        return new IdentityConfiguration(config.getUserName(), Arrays.asList(passwordData, assignedPermissions, additionalConfigurations));
    }

    private void initializeUserAdmin() {
        for (String defaultPermission : KuraPermission.DEFAULT_PERMISSIONS) {
            try {
                this.identityService.createPermission(new Permission(defaultPermission));
            }
            catch (KuraException e) {
                logger.warn("Failed to create permission", (Throwable)e);
            }
        }
    }

    private <T> void runFallibleTasks(List<IdentityConfiguration> configs, FallibleConsumer<IdentityConfiguration> consumer) throws GwtKuraException {
        StringBuilder builder = new StringBuilder();
        boolean hasFailures = false;
        for (IdentityConfiguration config : configs) {
            try {
                consumer.apply(config);
            }
            catch (Exception e) {
                if (hasFailures) {
                    builder.append("; ");
                }
                hasFailures = true;
                builder.append(String.valueOf(config.getName()) + ": " + e.getMessage());
            }
        }
        if (hasFailures) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, null, builder.toString());
        }
    }

    private GwtKuraException toGwt(Exception e) {
        if (e instanceof GwtKuraException) {
            return (GwtKuraException)e;
        }
        return new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, null, e.getMessage());
    }

    private static interface FallibleConsumer<T> {
        public void apply(T var1) throws Exception;
    }
}

