/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.component;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.eclipse.kura.camel.component.Configuration;
import org.eclipse.kura.camel.runner.CamelRunner;
import org.eclipse.kura.camel.runner.ContextFactory;
import org.eclipse.kura.camel.runner.ContextLifecycleListener;
import org.eclipse.kura.util.base.StringUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelComponent {
    static final String PROP_DISABLE_JMX = "org.eclipse.kura.camel.component.disableJmx";
    private static final Logger logger = LoggerFactory.getLogger(AbstractCamelComponent.class);
    protected CamelRunner runner;
    private ServiceRegistration<CamelContext> registration;

    protected void start(Map<String, Object> properties) throws Exception {
        logger.info("Starting camel router");
        final String kuraServiceId = Configuration.asString(properties, "camel.context.id");
        final String contextId = kuraServiceId == null ? Configuration.asString(properties, "kura.service.pid") : kuraServiceId;
        CamelRunner.Builder builder = new CamelRunner.Builder(this.getBundleContext());
        builder.contextFactory(this.getContextFactory());
        builder.disableJmx(Boolean.getBoolean(PROP_DISABLE_JMX));
        builder.addBeforeStart(this::beforeStart);
        if (!StringUtil.isNullOrEmpty((String)kuraServiceId) || !StringUtil.isNullOrEmpty((String)contextId)) {
            builder.addLifecycleListener(new ContextLifecycleListener(){

                @Override
                public void started(CamelContext camelContext) throws Exception {
                    AbstractCamelComponent.this.started(camelContext, kuraServiceId, contextId);
                }

                @Override
                public void stopping(CamelContext camelContext) throws Exception {
                    AbstractCamelComponent.this.stopping();
                }
            });
        }
        this.customizeBuilder(builder, properties);
        this.runner = builder.build();
        this.runner.start();
    }

    protected void started(CamelContext camelContext, String kuraServicePid, String contextId) {
        this.stopping();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (!StringUtil.isNullOrEmpty((String)kuraServicePid)) {
            ((Dictionary)properties).put("kura.service.pid", kuraServicePid);
        }
        if (!StringUtil.isNullOrEmpty((String)contextId)) {
            ((Dictionary)properties).put("service.pid", contextId);
            ((Dictionary)properties).put("camel.context.id", contextId);
        }
        this.registration = this.getBundleContext().registerService(CamelContext.class, (Object)camelContext, properties);
        logger.info("Registered camel context: {}", this.registration);
    }

    protected void stopping() {
        if (this.registration != null) {
            logger.info("Unregister camel context: {}", this.registration);
            this.registration.unregister();
            this.registration = null;
        }
    }

    protected void customizeBuilder(CamelRunner.Builder builder, Map<String, Object> properties) {
    }

    protected void stop() throws Exception {
        logger.info("Stopping camel router");
        if (this.runner != null) {
            this.runner.stop();
            this.runner = null;
        }
    }

    public CamelContext getCamelContext() {
        CamelRunner camelRunner = this.runner;
        return camelRunner != null ? camelRunner.getCamelContext() : null;
    }

    protected void beforeStart(CamelContext camelContext) {
    }

    protected ContextFactory getContextFactory() {
        return CamelRunner.createOsgiFactory(this.getBundleContext());
    }

    protected BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(AbstractCamelComponent.class).getBundleContext();
    }
}

