/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.configuration;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.kura.net.configuration.NetworkConfigurationPropertyNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfigurationMessages {
    private static final Logger logger = LoggerFactory.getLogger(NetworkConfigurationMessages.class);
    private static final String NETWORK_CONFIGURATION_MESSAGES_BUNDLE = "org.eclipse.kura.net.configuration.messages.NetworkConfigurationMessagesBundle";

    private NetworkConfigurationMessages() {
    }

    public static String getMessage(NetworkConfigurationPropertyNames code) {
        return NetworkConfigurationMessages.getLocalizedMessage(Locale.getDefault(), code);
    }

    private static String getLocalizedMessage(Locale locale, NetworkConfigurationPropertyNames code) {
        String message = null;
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(NETWORK_CONFIGURATION_MESSAGES_BUNDLE, locale);
            message = resourceBundle.getString(code.name());
            if (message == null) {
                logger.warn("Could not find Configuration Message for Locale {} and code {}", (Object)locale, (Object)code);
            }
        }
        catch (MissingResourceException mre) {
            logger.warn("Could not find Messages Bundle for Locale " + locale, (Throwable)mre);
        }
        return message;
    }
}

