/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.h2db.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.db.H2DbService;

public final class H2DbServiceHelper {
    private static final Logger logger = LogManager.getLogger(H2DbServiceHelper.class);
    private final H2DbService dbService;

    private H2DbServiceHelper(H2DbService dbService) {
        Objects.requireNonNull(dbService, "DB Service cannot be null");
        this.dbService = dbService;
    }

    public static H2DbServiceHelper of(H2DbService dbService) {
        return new H2DbServiceHelper(dbService);
    }

    public synchronized void execute(Connection c, String sql, Integer ... params) throws SQLException {
        Objects.requireNonNull(sql, "SQL query cannot be null");
        logger.debug("Executing SQL query... {}", (Object)sql);
        Throwable throwable = null;
        Object var5_6 = null;
        try (PreparedStatement stmt = c.prepareStatement(sql);){
            int i = 0;
            while (i < params.length) {
                stmt.setInt(1 + i, params[i]);
                ++i;
            }
            stmt.execute();
            c.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        logger.debug("Executing SQL query... Done");
    }

    public <T> T withConnection(H2DbService.ConnectionCallable<T> callable) throws SQLException {
        return (T)this.dbService.withConnection(callable);
    }

    public String sanitizeSqlTableAndColumnName(String string) {
        Objects.requireNonNull(string, "Provided string cannot be null");
        logger.debug("Sanitizing the provided string... {}", (Object)string);
        String sanitizedName = string.replaceAll("\"", "\"\"");
        return "\"" + sanitizedName + "\"";
    }
}

