/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.publisher;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.internal.wire.publisher.CloudPublisherOptions;
import org.eclipse.kura.internal.wire.publisher.PositionType;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraPosition;
import org.eclipse.kura.position.NmeaPosition;
import org.eclipse.kura.position.PositionService;
import org.eclipse.kura.type.ByteArrayValue;
import org.eclipse.kura.type.StringValue;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireReceiver;
import org.eclipse.kura.wire.WireRecord;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;

public final class CloudPublisher
implements WireReceiver,
ConfigurableComponent {
    private static final Logger logger = LogManager.getLogger(CloudPublisher.class);
    private CloudPublisherOptions cloudPublisherOptions;
    private volatile WireHelperService wireHelperService;
    private PositionService positionService;
    private WireSupport wireSupport;
    private org.eclipse.kura.cloudconnection.publisher.CloudPublisher cloudConnectionPublisher;

    public void bindWireHelperService(WireHelperService wireHelperService) {
        if (Objects.isNull(this.wireHelperService)) {
            this.wireHelperService = wireHelperService;
        }
    }

    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    public void setCloudPublisher(org.eclipse.kura.cloudconnection.publisher.CloudPublisher cloudPublisher) {
        this.cloudConnectionPublisher = cloudPublisher;
    }

    public void unsetCloudPublisher(org.eclipse.kura.cloudconnection.publisher.CloudPublisher cloudPublisher) {
        if (cloudPublisher == this.cloudConnectionPublisher) {
            this.cloudConnectionPublisher = null;
        }
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.debug("Activating Cloud Publisher Wire Component...");
        this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        this.cloudPublisherOptions = new CloudPublisherOptions(properties);
        logger.debug("Activating Cloud Publisher Wire Component... Done");
    }

    public void updated(Map<String, Object> properties) {
        logger.debug("Updating Cloud Publisher Wire Component...");
        this.cloudPublisherOptions = new CloudPublisherOptions(properties);
        logger.debug("Updating Cloud Publisher Wire Component... Done");
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.debug("Deactivating Cloud Publisher Wire Component...");
        logger.debug("Deactivating Cloud Publisher Wire Component... Done");
    }

    public void onWireReceive(WireEnvelope wireEnvelope) {
        Objects.requireNonNull(wireEnvelope, "Wire Envelope cannot be null");
        if (Objects.nonNull(this.cloudConnectionPublisher)) {
            List records = wireEnvelope.getRecords();
            this.publish(records);
        }
    }

    public void producersConnected(Wire[] wires) {
        this.wireSupport.producersConnected(wires);
    }

    public void updated(Wire wire, Object value) {
        this.wireSupport.updated(wire, value);
    }

    private KuraPayload buildKuraPayload(WireRecord wireRecord) {
        Objects.requireNonNull(wireRecord, "Wire Record cannot be null");
        KuraPayload kuraPayload = new KuraPayload();
        kuraPayload.setTimestamp(new Date());
        if (this.cloudPublisherOptions.getPositionType() != PositionType.NONE) {
            KuraPosition kuraPosition = this.getPosition();
            kuraPayload.setPosition(kuraPosition);
        }
        Map wireRecordProperties = wireRecord.getProperties();
        for (Map.Entry entry : wireRecordProperties.entrySet()) {
            kuraPayload.addMetric((String)entry.getKey(), ((TypedValue)entry.getValue()).getValue());
        }
        Optional<String> bodyProperty = this.cloudPublisherOptions.getBodyProperty();
        if (bodyProperty.isPresent()) {
            this.publishBody(kuraPayload, wireRecordProperties, bodyProperty.get());
        }
        return kuraPayload;
    }

    private void publishBody(KuraPayload kuraPayload, Map<String, TypedValue<?>> wireRecordProperties, String bodyProperty) {
        try {
            TypedValue<?> bodyPropertyValue = wireRecordProperties.get(bodyProperty);
            if (bodyPropertyValue == null) {
                logger.warn("The \"{}\" property is missing, message body will not be set", (Object)bodyProperty);
            } else if (bodyPropertyValue instanceof StringValue) {
                kuraPayload.setBody(((String)bodyPropertyValue.getValue()).getBytes(StandardCharsets.UTF_8));
            } else if (bodyPropertyValue instanceof ByteArrayValue) {
                kuraPayload.setBody((byte[])bodyPropertyValue.getValue());
            } else {
                logger.warn("The type of the body property must be STRING or BYTE_ARRAY");
            }
        }
        catch (Exception e) {
            logger.warn("failed to publish body", (Throwable)e);
        }
        boolean isRemoveBodyPropertyFromMetrics = this.cloudPublisherOptions.getRemoveBodyPropertyFromMetrics();
        if (isRemoveBodyPropertyFromMetrics) {
            kuraPayload.removeMetric(bodyProperty);
        }
    }

    private KuraPosition getPosition() {
        NmeaPosition position = this.positionService.getNmeaPosition();
        KuraPosition kuraPosition = new KuraPosition();
        kuraPosition.setAltitude(position.getAltitude());
        kuraPosition.setLatitude(position.getLatitude());
        kuraPosition.setLongitude(position.getLongitude());
        if (this.cloudPublisherOptions.getPositionType() == PositionType.FULL) {
            kuraPosition.setHeading(position.getTrack());
            kuraPosition.setPrecision(position.getDOP());
            kuraPosition.setSpeed(position.getSpeed());
            kuraPosition.setSatellites(position.getNrSatellites());
        }
        return kuraPosition;
    }

    private void publish(List<WireRecord> wireRecords) {
        Objects.requireNonNull(wireRecords, "Wire Records cannot be null");
        try {
            for (WireRecord dataRecord : wireRecords) {
                Map<String, Object> properties = this.buildKuraMessageProperties(dataRecord);
                KuraPayload kuraPayload = this.buildKuraPayload(dataRecord);
                KuraMessage message = new KuraMessage(kuraPayload, properties);
                this.cloudConnectionPublisher.publish(message);
            }
        }
        catch (Exception e) {
            logger.error("Error in publishing wire records using cloud publisher..", (Throwable)e);
        }
    }

    private Map<String, Object> buildKuraMessageProperties(WireRecord wireRecord) {
        Map wireRecordProps = wireRecord.getProperties();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList l = new ArrayList(wireRecordProps.keySet());
        for (String s : l) {
            properties.put(s, ((TypedValue)wireRecordProps.get(s)).getValue());
        }
        Optional<String> bodyProperty = this.cloudPublisherOptions.getBodyProperty();
        boolean isRemoveBodyPropertyFromMetrics = this.cloudPublisherOptions.getRemoveBodyPropertyFromMetrics();
        if (bodyProperty.isPresent() && isRemoveBodyPropertyFromMetrics) {
            properties.remove(bodyProperty.get());
        }
        return properties;
    }
}

