/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.runner;

import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.kura.camel.runner.ServiceConsumer;
import org.eclipse.kura.camel.runner.ServiceDependency;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DefaultServiceDependency<T, C>
implements ServiceDependency<T, C> {
    private final BundleContext bundleContext;
    private final Filter filter;
    private final ServiceConsumer<T, C> consumer;

    public DefaultServiceDependency(BundleContext bundleContext, Filter filter, ServiceConsumer<T, C> consumer) {
        Objects.requireNonNull(bundleContext);
        Objects.requireNonNull(filter);
        this.bundleContext = bundleContext;
        this.filter = filter;
        this.consumer = consumer;
    }

    @Override
    public ServiceDependency.Handle<C> start(Runnable runnable) {
        Objects.requireNonNull(runnable);
        return new HandleImpl(this.bundleContext, this.filter, runnable, this.consumer);
    }

    private final class HandleImpl
    implements ServiceDependency.Handle<C> {
        private final BundleContext bundleContext;
        private final ServiceConsumer<T, C> consumer;
        private final TreeMap<ServiceReference<T>, T> services = new TreeMap();
        private final ServiceTracker<T, T> tracker;
        private Runnable runnable;
        private final ServiceTrackerCustomizer<T, T> customizer = new ServiceTrackerCustomizer<T, T>(){

            public T addingService(ServiceReference<T> reference) {
                return HandleImpl.this.adding(reference);
            }

            public void modifiedService(ServiceReference<T> reference, T service) {
            }

            public void removedService(ServiceReference<T> reference, T service) {
                HandleImpl.this.removed(reference, service);
            }
        };

        public HandleImpl(BundleContext bundleContext, Filter filter, Runnable runnable, ServiceConsumer<T, C> consumer) {
            this.bundleContext = bundleContext;
            this.consumer = consumer;
            this.runnable = runnable;
            this.tracker = new ServiceTracker(bundleContext, filter, this.customizer);
            this.tracker.open();
        }

        protected T adding(ServiceReference<T> reference) {
            Object service = this.bundleContext.getService(reference);
            this.services.put(reference, service);
            this.triggerUpdate();
            return service;
        }

        protected void removed(ServiceReference<T> reference, T service) {
            this.bundleContext.ungetService(reference);
            this.services.remove(reference);
            this.triggerUpdate();
        }

        private void triggerUpdate() {
            Runnable runnableTemp = this.runnable;
            if (runnableTemp != null) {
                runnableTemp.run();
            }
        }

        @Override
        public void stop() {
            this.runnable = null;
            this.tracker.close();
        }

        @Override
        public boolean isSatisfied() {
            return !this.services.isEmpty();
        }

        @Override
        public void consume(C context) {
            this.consumer.consume(context, this.services.firstEntry().getValue());
        }

        public String toString() {
            return String.format("[Service - filter: %s]", DefaultServiceDependency.this.filter);
        }
    }
}

