/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.server.RequiredPermissions;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtUserConfig;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuraRemoteServiceServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = 3473193315046407200L;
    private static final Logger logger = LoggerFactory.getLogger(KuraRemoteServiceServlet.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");

    public void checkXSRFToken(GwtXSRFToken xsrfToken) throws GwtKuraException {
        HttpServletRequest req = (HttpServletRequest)this.perThreadRequest.get();
        KuraRemoteServiceServlet.performXSRFTokenValidation(req, xsrfToken);
    }

    private static void performXSRFTokenValidation(HttpServletRequest req, GwtXSRFToken userToken) throws GwtKuraException {
        if (!KuraRemoteServiceServlet.isValidXSRFToken(req, userToken.getToken())) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, null, "Invalid XSRF token");
        }
    }

    public static boolean isValidXSRFToken(HttpServletRequest req, String userToken) {
        logger.debug("Starting XSRF Token validation...'");
        HttpSession session = req.getSession(false);
        if (session == null) {
            auditLogger.warn("{} UI XSRF - Failure - User is not authenticated", (Object)AuditContext.currentOrInternal());
            return false;
        }
        if (userToken == null) {
            auditLogger.warn("{} UI XSRF - Failure - XSRF Token not provided", (Object)AuditContext.currentOrInternal());
            session.invalidate();
            return false;
        }
        if (Objects.equals(userToken, session.getAttribute(Attributes.XSRF_TOKEN.getValue()))) {
            return true;
        }
        auditLogger.warn("{} UI XSRF - Failure - XSRF Token validation error", (Object)AuditContext.currentOrInternal());
        session.invalidate();
        return false;
    }

    public static void requirePermissions(HttpServletRequest request, RequiredPermissions.Mode mode, String[] permissions) {
        try {
            KuraRemoteServiceServlet.requirePermissionsInternal(request, mode, permissions);
        }
        catch (KuraPermissionException e) {
            auditLogger.warn("{} UI Auth - Failure - User does not have the required permissions", (Object)AuditContext.currentOrInternal());
            throw e;
        }
    }

    private static void requirePermissionsInternal(HttpServletRequest request, RequiredPermissions.Mode mode, String[] permissions) {
        HttpSession session = request.getSession(false);
        UserManager userManager = Console.instance().getUserManager();
        Object rawUserName = session.getAttribute(Attributes.AUTORIZED_USER.getValue());
        if (!(rawUserName instanceof String)) {
            throw new KuraPermissionException();
        }
        String userName = (String)rawUserName;
        Optional<GwtUserConfig> config = userManager.getUserConfig(userName);
        if (!config.isPresent()) {
            throw new KuraPermissionException();
        }
        if (config.get().isAdmin()) {
            return;
        }
        if (mode == RequiredPermissions.Mode.ALL ? !KuraRemoteServiceServlet.containsAll(permissions, config.get().getPermissions()) : !KuraRemoteServiceServlet.containsAny(permissions, config.get().getPermissions())) {
            throw new KuraPermissionException();
        }
    }

    private static boolean containsAll(String[] required, Set<String> actual) {
        String[] stringArray = required;
        int n = required.length;
        int n2 = 0;
        while (n2 < n) {
            String req = stringArray[n2];
            if (!actual.contains(req)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean containsAny(String[] required, Set<String> actual) {
        String[] stringArray = required;
        int n = required.length;
        int n2 = 0;
        while (n2 < n) {
            String req = stringArray[n2];
            if (actual.contains(req)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getFieldFromMultiPartForm(HttpServletRequest req, String fieldName) throws FileUploadException {
        String fieldValue = null;
        ServletFileUpload upload = new ServletFileUpload();
        List items = upload.parseRequest(req);
        for (FileItem item : items) {
            String name;
            if (!item.isFormField() || !(name = item.getFieldName()).equals(fieldName)) continue;
            fieldValue = item.getString();
            logger.debug("Found field name '{}' with value: {}", (Object)name, (Object)fieldValue);
        }
        return fieldValue;
    }

    public static void checkXSRFToken(HttpServletRequest req, GwtXSRFToken token) throws GwtKuraException {
        KuraRemoteServiceServlet.performXSRFTokenValidation(req, token);
    }

    public static void checkXSRFTokenMultiPart(HttpServletRequest req, GwtXSRFToken token) throws GwtKuraException {
        KuraRemoteServiceServlet.performXSRFTokenValidation(req, token);
    }

    protected void doUnexpectedFailure(Throwable e) {
        if (e instanceof KuraPermissionException) {
            try {
                this.getThreadLocalResponse().sendError(403);
                return;
            }
            catch (IOException iOException) {}
        }
        super.doUnexpectedFailure(e);
    }

    public static class KuraPermissionException
    extends RuntimeException {
        private static final long serialVersionUID = 7782509676228955785L;
    }
}

