/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.cluster;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.component.file.cluster.FileLockClusterView;
import org.apache.camel.impl.cluster.AbstractCamelClusterService;
import org.apache.camel.util.ObjectHelper;

public class FileLockClusterService
extends AbstractCamelClusterService<FileLockClusterView> {
    private String root;
    private long acquireLockDelay = 1L;
    private TimeUnit acquireLockDelayUnit = TimeUnit.SECONDS;
    private long acquireLockInterval = 10L;
    private TimeUnit acquireLockIntervalUnit = TimeUnit.SECONDS;
    private ScheduledExecutorService executor;

    @Override
    protected FileLockClusterView createView(String namespace) throws Exception {
        return new FileLockClusterView(this, namespace);
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public long getAcquireLockDelay() {
        return this.acquireLockDelay;
    }

    public void setAcquireLockDelay(long acquireLockDelay) {
        this.acquireLockDelay = acquireLockDelay;
    }

    public void setAcquireLockDelay(long pollDelay, TimeUnit pollDelayUnit) {
        this.setAcquireLockDelay(pollDelay);
        this.setAcquireLockDelayUnit(pollDelayUnit);
    }

    public TimeUnit getAcquireLockDelayUnit() {
        return this.acquireLockDelayUnit;
    }

    public void setAcquireLockDelayUnit(TimeUnit acquireLockDelayUnit) {
        this.acquireLockDelayUnit = acquireLockDelayUnit;
    }

    public long getAcquireLockInterval() {
        return this.acquireLockInterval;
    }

    public void setAcquireLockInterval(long acquireLockInterval) {
        this.acquireLockInterval = acquireLockInterval;
    }

    public void setAcquireLockInterval(long pollInterval, TimeUnit pollIntervalUnit) {
        this.setAcquireLockInterval(pollInterval);
        this.setAcquireLockIntervalUnit(pollIntervalUnit);
    }

    public TimeUnit getAcquireLockIntervalUnit() {
        return this.acquireLockIntervalUnit;
    }

    public void setAcquireLockIntervalUnit(TimeUnit acquireLockIntervalUnit) {
        this.acquireLockIntervalUnit = acquireLockIntervalUnit;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        CamelContext context = this.getCamelContext();
        if (this.executor != null) {
            if (context != null) {
                context.getExecutorServiceManager().shutdown(this.executor);
            } else {
                this.executor.shutdown();
            }
            this.executor = null;
        }
    }

    synchronized ScheduledExecutorService getExecutor() {
        if (this.executor == null) {
            CamelContext context = ObjectHelper.notNull(this.getCamelContext(), "CamelContext");
            this.executor = context.getExecutorServiceManager().newSingleThreadScheduledExecutor(this, "FileLockClusterService-" + this.getId());
        }
        return this.executor;
    }
}

