/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsCallback
implements Runnable {
    private static final String CLASS_NAME = CommsCallback.class.getName();
    private final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private static final int INBOUND_QUEUE_SIZE = 10;
    private MqttCallback mqttCallback;
    private MqttCallbackExtended reconnectInternalCallback;
    private Hashtable<String, IMqttMessageListener> callbacks;
    private ClientComms clientComms;
    private Vector<MqttWireMessage> messageQueue;
    private Vector<MqttToken> completeQueue;
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private Object lifecycle = new Object();
    private Thread callbackThread;
    private String threadName;
    private Future<?> callbackFuture;
    private Object workAvailable = new Object();
    private Object spaceAvailable = new Object();
    private ClientState clientState;
    private boolean manualAcks = false;

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new Vector(10);
        this.completeQueue = new Vector(10);
        this.callbacks = new Hashtable();
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        var3_3 = this.lifecycle;
        synchronized (var3_3) {
            if (this.current_state == State.STOPPED) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.callbackFuture = executorService.submit(this);
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl23
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception var3_4) {
                // empty catch block
            }
lbl23:
            // 3 sources

        } while (!this.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stop() {
        block13: {
            block14: {
                methodName = "stop";
                var2_2 = this.lifecycle;
                synchronized (var2_2) {
                    if (this.callbackFuture != null) {
                        this.callbackFuture.cancel(true);
                    }
                }
                if (!this.isRunning()) break block13;
                this.log.fine(CommsCallback.CLASS_NAME, "stop", "700");
                var2_2 = this.lifecycle;
                synchronized (var2_2) {
                    this.target_state = State.STOPPED;
                }
                if (Thread.currentThread().equals(this.callbackThread)) break block14;
                var2_2 = this.workAvailable;
                synchronized (var2_2) {
                    this.log.fine(CommsCallback.CLASS_NAME, "stop", "701");
                    this.workAvailable.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[2, 6] lbl30 : MonitorExitStatement: MONITOREXIT : var2_2
                    if (true) ** GOTO lbl37
                }
                do {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception var2_3) {
                        // empty catch block
                    }
                    this.clientState.notifyQueueLock();
lbl37:
                    // 2 sources

                } while (this.isRunning());
            }
            this.log.fine(CommsCallback.CLASS_NAME, "stop", "703");
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    public void setReconnectCallback(MqttCallbackExtended callback) {
        this.reconnectInternalCallback = callback;
    }

    public void setManualAcks(boolean manualAcks) {
        this.manualAcks = manualAcks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        methodName = "run";
        this.callbackThread = Thread.currentThread();
        this.callbackThread.setName(this.threadName);
        var2_2 = this.lifecycle;
        synchronized (var2_2) {
            this.current_state = State.RUNNING;
            // MONITOREXIT @DISABLED, blocks:[0, 11] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl87
        }
        do {
            try {
                try {
                    try {
                        var2_2 = this.workAvailable;
                        synchronized (var2_2) {
                            if (this.isRunning() && this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                                this.log.fine(CommsCallback.CLASS_NAME, "run", "704");
                                this.workAvailable.wait();
                            }
                        }
                    }
                    catch (InterruptedException var2_3) {
                        // empty catch block
                    }
                    if (this.isRunning()) {
                        token = null;
                        var3_5 = this.completeQueue;
                        synchronized (var3_5) {
                            if (!this.completeQueue.isEmpty()) {
                                token = this.completeQueue.elementAt(0);
                                this.completeQueue.removeElementAt(0);
                            }
                        }
                        if (token != null) {
                            this.handleActionComplete(token);
                        }
                        message = null;
                        var4_6 = this.messageQueue;
                        synchronized (var4_6) {
                            if (!this.messageQueue.isEmpty()) {
                                message = (MqttPublish)this.messageQueue.elementAt(0);
                                this.messageQueue.removeElementAt(0);
                            }
                        }
                        if (message != null) {
                            this.handleMessage(message);
                        }
                    }
                    if (this.isQuiescing()) {
                        this.clientState.checkQuiesceLock();
                    }
                }
                catch (Throwable ex) {
                    this.log.fine(CommsCallback.CLASS_NAME, "run", "714", null, ex);
                    this.clientComms.shutdownConnection(null, new MqttException(ex));
                    var6_7 = this.spaceAvailable;
                    synchronized (var6_7) {
                        this.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                        this.spaceAvailable.notifyAll();
                        continue;
                    }
                }
            }
            catch (Throwable var5_8) {
                var6_7 = this.spaceAvailable;
                synchronized (var6_7) {
                    this.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                    this.spaceAvailable.notifyAll();
                }
                throw var5_8;
            }
            var6_7 = this.spaceAvailable;
            synchronized (var6_7) {
                this.log.fine(CommsCallback.CLASS_NAME, "run", "706");
                this.spaceAvailable.notifyAll();
            }
lbl87:
            // 3 sources

        } while (this.isRunning());
        var2_2 = this.lifecycle;
        synchronized (var2_2) {
            this.current_state = State.STOPPED;
        }
        this.callbackThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleActionComplete(MqttToken token) throws MqttException {
        String methodName = "handleActionComplete";
        MqttToken mqttToken = token;
        synchronized (mqttToken) {
            this.log.fine(CLASS_NAME, "handleActionComplete", "705", new Object[]{token.internalTok.getKey()});
            if (token.isComplete()) {
                this.clientState.notifyComplete(token);
            }
            token.internalTok.notifyComplete();
            if (!token.internalTok.isNotified()) {
                if (this.mqttCallback != null && token instanceof MqttDeliveryToken && token.isComplete()) {
                    this.mqttCallback.deliveryComplete((MqttDeliveryToken)token);
                }
                this.fireActionEvent(token);
            }
            if (token.isComplete() && token instanceof MqttDeliveryToken) {
                token.internalTok.setNotified(true);
            }
        }
    }

    public void connectionLost(MqttException cause) {
        String methodName = "connectionLost";
        try {
            if (this.mqttCallback != null && cause != null) {
                this.log.fine(CLASS_NAME, "connectionLost", "708", new Object[]{cause});
                this.mqttCallback.connectionLost(cause);
            }
            if (this.reconnectInternalCallback != null && cause != null) {
                this.reconnectInternalCallback.connectionLost(cause);
            }
        }
        catch (Throwable t) {
            this.log.fine(CLASS_NAME, "connectionLost", "720", new Object[]{t});
        }
    }

    public void fireActionEvent(MqttToken token) {
        IMqttActionListener asyncCB;
        String methodName = "fireActionEvent";
        if (token != null && (asyncCB = token.getActionCallback()) != null) {
            if (token.getException() == null) {
                this.log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onSuccess(token);
            } else {
                this.log.fine(CLASS_NAME, "fireActionEvent", "716", new Object[]{token.internalTok.getKey()});
                asyncCB.onFailure(token, token.getException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void messageArrived(MqttPublish sendMessage) {
        String methodName = "messageArrived";
        if (this.mqttCallback == null) {
            if (this.callbacks.size() <= 0) return;
        }
        Object object = this.spaceAvailable;
        synchronized (object) {
            while (this.isRunning() && !this.isQuiescing() && this.messageQueue.size() >= 10) {
                try {
                    this.log.fine(CLASS_NAME, "messageArrived", "709");
                    this.spaceAvailable.wait(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.isQuiescing()) return;
        this.messageQueue.addElement(sendMessage);
        object = this.workAvailable;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "messageArrived", "710");
            this.workAvailable.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce() {
        String methodName = "quiesce";
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.current_state == State.RUNNING) {
                this.current_state = State.QUIESCING;
            }
        }
        object = this.spaceAvailable;
        synchronized (object) {
            this.log.fine(CLASS_NAME, "quiesce", "711");
            this.spaceAvailable.notifyAll();
        }
    }

    public boolean isQuiesced() {
        return this.isQuiescing() && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish publishMessage) throws MqttException, Exception {
        String methodName = "handleMessage";
        String destName = publishMessage.getTopicName();
        this.log.fine(CLASS_NAME, "handleMessage", "713", new Object[]{publishMessage.getMessageId(), destName});
        this.deliverMessage(destName, publishMessage.getMessageId(), publishMessage.getMessage());
        if (!this.manualAcks) {
            if (publishMessage.getMessage().getQos() == 1) {
                this.clientComms.internalSend(new MqttPubAck(publishMessage), new MqttToken(this.clientComms.getClient().getClientId()));
            } else if (publishMessage.getMessage().getQos() == 2) {
                this.clientComms.deliveryComplete(publishMessage);
                MqttPubComp pubComp = new MqttPubComp(publishMessage);
                this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
            }
        }
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        if (qos == 1) {
            this.clientComms.internalSend(new MqttPubAck(messageId), new MqttToken(this.clientComms.getClient().getClientId()));
        } else if (qos == 2) {
            this.clientComms.deliveryComplete(messageId);
            MqttPubComp pubComp = new MqttPubComp(messageId);
            this.clientComms.internalSend(pubComp, new MqttToken(this.clientComms.getClient().getClientId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncOperationComplete(MqttToken token) {
        String methodName = "asyncOperationComplete";
        if (this.isRunning()) {
            this.completeQueue.addElement(token);
            Object object = this.workAvailable;
            synchronized (object) {
                this.log.fine(CLASS_NAME, "asyncOperationComplete", "715", new Object[]{token.internalTok.getKey()});
                this.workAvailable.notifyAll();
            }
        }
        try {
            this.handleActionComplete(token);
        }
        catch (Throwable ex) {
            this.log.fine(CLASS_NAME, "asyncOperationComplete", "719", null, ex);
            this.clientComms.shutdownConnection(null, new MqttException(ex));
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }

    public void setMessageListener(String topicFilter, IMqttMessageListener messageListener) {
        this.callbacks.put(topicFilter, messageListener);
    }

    public void removeMessageListener(String topicFilter) {
        this.callbacks.remove(topicFilter);
    }

    public void removeMessageListeners() {
        this.callbacks.clear();
    }

    protected boolean deliverMessage(String topicName, int messageId, MqttMessage aMessage) throws Exception {
        boolean delivered = false;
        Enumeration<String> keys = this.callbacks.keys();
        while (keys.hasMoreElements()) {
            String topicFilter = keys.nextElement();
            if (!MqttTopic.isMatched(topicFilter, topicName)) continue;
            aMessage.setId(messageId);
            this.callbacks.get(topicFilter).messageArrived(topicName, aMessage);
            delivered = true;
        }
        if (this.mqttCallback != null && !delivered) {
            aMessage.setId(messageId);
            this.mqttCallback.messageArrived(topicName, aMessage);
            delivered = true;
        }
        return delivered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean result;
        Object object = this.lifecycle;
        synchronized (object) {
            result = (this.current_state == State.RUNNING || this.current_state == State.QUIESCING) && this.target_state == State.RUNNING;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQuiescing() {
        boolean result;
        Object object = this.lifecycle;
        synchronized (object) {
            result = this.current_state == State.QUIESCING;
        }
        return result;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        QUIESCING;

    }
}

