/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.asset;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.kura.channel.ChannelFlag;
import org.eclipse.kura.channel.ChannelRecord;
import org.eclipse.kura.type.TypedValue;

public class ValueChangeCache {
    private final Map<String, TypedValue<?>> cache = new HashMap();

    private boolean update(ChannelRecord channelRecord) {
        String key = channelRecord.getChannelName();
        if (channelRecord.getChannelStatus().getChannelFlag() != ChannelFlag.SUCCESS) {
            this.cache.remove(key);
            return true;
        }
        TypedValue value = channelRecord.getValue();
        if (Objects.equals(this.cache.get(key), value)) {
            return false;
        }
        this.cache.put(key, value);
        return true;
    }

    public synchronized List<ChannelRecord> filterRecords(List<ChannelRecord> channelRecords) {
        return channelRecords.stream().filter(this::update).collect(Collectors.toList());
    }
}

