/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.orchestration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.kura.container.orchestration.ContainerPort;
import org.eclipse.kura.container.orchestration.ContainerState;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ContainerInstanceDescriptor {
    private String containerName;
    private String containerImage;
    private String containerImageTag;
    private String containerID;
    private List<ContainerPort> containerPorts = new ArrayList<ContainerPort>();
    private ContainerState containerState = ContainerState.STOPPING;
    private boolean isFrameworkManaged;

    private ContainerInstanceDescriptor() {
    }

    public ContainerState getContainerState() {
        return this.containerState;
    }

    public boolean isFrameworkManaged() {
        return this.isFrameworkManaged;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getContainerImage() {
        return this.containerImage;
    }

    public String getContainerImageTag() {
        return this.containerImageTag;
    }

    public String getContainerId() {
        return this.containerID;
    }

    public List<ContainerPort> getContainerPorts() {
        return this.containerPorts;
    }

    @Deprecated
    public List<Integer> getContainerPortsExternal() {
        return this.containerPorts.stream().map(ContainerPort::getExternalPort).collect(Collectors.toList());
    }

    @Deprecated
    public List<Integer> getContainerPortsInternal() {
        return this.containerPorts.stream().map(ContainerPort::getInternalPort).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerID, this.containerImage, this.containerImageTag, this.containerName, this.containerPorts, this.containerState, this.isFrameworkManaged});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerInstanceDescriptor other = (ContainerInstanceDescriptor)obj;
        return Objects.equals(this.containerID, other.containerID) && Objects.equals(this.containerImage, other.containerImage) && Objects.equals(this.containerImageTag, other.containerImageTag) && Objects.equals(this.containerName, other.containerName) && Objects.equals(this.containerPorts, other.containerPorts) && this.containerState == other.containerState && this.isFrameworkManaged == other.isFrameworkManaged;
    }

    public static ContainerInstanceDescriptorBuilder builder() {
        return new ContainerInstanceDescriptorBuilder();
    }

    /* synthetic */ ContainerInstanceDescriptor(ContainerInstanceDescriptor containerInstanceDescriptor) {
        this();
    }

    public static final class ContainerInstanceDescriptorBuilder {
        private String containerName;
        private String containerImage;
        private String containerImageTag = "latest";
        private String containerId = "";
        private List<Integer> containerPortsExternal = new ArrayList<Integer>();
        private List<Integer> containerPortsInternal = new ArrayList<Integer>();
        private List<ContainerPort> containerPorts = new ArrayList<ContainerPort>();
        private ContainerState containerState = ContainerState.STOPPING;
        private boolean isFrameworkManaged;

        public ContainerInstanceDescriptorBuilder setContainerName(String serviceName) {
            this.containerName = serviceName;
            return this;
        }

        public ContainerInstanceDescriptorBuilder setFrameworkManaged(Boolean isFrameworkManaged) {
            this.isFrameworkManaged = isFrameworkManaged;
            return this;
        }

        public ContainerInstanceDescriptorBuilder setContainerImage(String serviceImage) {
            this.containerImage = serviceImage;
            return this;
        }

        public ContainerInstanceDescriptorBuilder setContainerImageTag(String serviceImageTag) {
            this.containerImageTag = serviceImageTag;
            return this;
        }

        public ContainerInstanceDescriptorBuilder setContainerID(String containerID) {
            this.containerId = containerID;
            return this;
        }

        public ContainerInstanceDescriptorBuilder setContainerPorts(List<ContainerPort> containerPorts) {
            this.containerPorts = containerPorts;
            return this;
        }

        @Deprecated
        public ContainerInstanceDescriptorBuilder setExternalPorts(List<Integer> containerPortsExternal) {
            this.containerPortsExternal = new ArrayList<Integer>(containerPortsExternal);
            return this;
        }

        @Deprecated
        public ContainerInstanceDescriptorBuilder setInternalPorts(List<Integer> containerPortsInternal) {
            this.containerPortsInternal = new ArrayList<Integer>(containerPortsInternal);
            return this;
        }

        public ContainerInstanceDescriptorBuilder setContainerState(ContainerState containerState) {
            this.containerState = containerState;
            return this;
        }

        public ContainerInstanceDescriptor build() {
            ContainerInstanceDescriptor containerDescriptor = new ContainerInstanceDescriptor(null);
            if (this.containerPorts.isEmpty()) {
                Iterator<Integer> extPort = this.containerPortsExternal.iterator();
                Iterator<Integer> intPort = this.containerPortsInternal.iterator();
                while (extPort.hasNext() && intPort.hasNext()) {
                    this.containerPorts.add(new ContainerPort(intPort.next(), extPort.next()));
                }
            }
            containerDescriptor.containerName = this.containerName;
            containerDescriptor.containerImage = this.containerImage;
            containerDescriptor.containerImageTag = this.containerImageTag;
            containerDescriptor.containerID = this.containerId;
            containerDescriptor.containerPorts = this.containerPorts;
            containerDescriptor.containerState = this.containerState;
            containerDescriptor.isFrameworkManaged = this.isFrameworkManaged;
            return containerDescriptor;
        }
    }
}

