/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.tigris.mtoolkit.iagent.event.EventData;
import org.tigris.mtoolkit.iagent.event.EventSynchronizer;
import org.tigris.mtoolkit.iagent.internal.rpc.Activator;
import org.tigris.mtoolkit.iagent.internal.rpc.RemoteBundleAdminImpl;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.rpc.Remote;
import org.tigris.mtoolkit.iagent.rpc.RemoteCapabilitiesManager;
import org.tigris.mtoolkit.iagent.rpc.RemoteServiceAdmin;

public class RemoteServiceAdminImpl
implements RemoteServiceAdmin,
Remote,
AllServiceListener {
    private static final String EVENT_TYPE_KEY = "type";
    private static final int SERVICE_REGISTERED = 1;
    private static final int SERVICE_MODIFIED = 2;
    private static final int SERVICE_UNREGISTERED = 4;
    private static final boolean TRACK_SERVICES_DEBUG = Boolean.getBoolean("iagent.debug.services");
    private Bundle systemBundle;
    private Class[] filterSupportedClasses;
    private BundleContext bc;
    private ServiceRegistration registration;
    private Map services;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public RemoteServiceAdminImpl() {
        Class[] classArray = new Class[17];
        classArray[0] = Integer.TYPE;
        classArray[1] = Long.TYPE;
        classArray[2] = Float.TYPE;
        classArray[3] = Double.TYPE;
        classArray[4] = Byte.TYPE;
        classArray[5] = Short.TYPE;
        classArray[6] = Character.TYPE;
        classArray[7] = Boolean.TYPE;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[8] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[9] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[10] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[11] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[12] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[13] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[14] = clazz7;
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[15] = clazz8;
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[16] = clazz9;
        this.filterSupportedClasses = classArray;
        this.services = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(BundleContext context) {
        this.debug("[register] Registering remote service admin...");
        this.bc = context;
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteServiceAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registration = context.registerService(clazz.getName(), (Object)this, null);
        Map map = this.services;
        synchronized (map) {
            context.addServiceListener((ServiceListener)this);
            try {
                ServiceReference[] refs = context.getAllServiceReferences(null, null);
                this.fillServicesMap(refs);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        RemoteCapabilitiesManager capMan = Activator.getCapabilitiesManager();
        if (capMan != null) {
            capMan.setCapability("remote.service.support", new Boolean(true));
        }
        this.debug("[register] Remote Service Admin Registered.");
    }

    private void fillServicesMap(ServiceReference[] references) {
        if (references == null || references.length == 0) {
            return;
        }
        int i = 0;
        while (i < references.length) {
            ServiceReference ref = references[i];
            Long sid = (Long)ref.getProperty("service.id");
            this.services.put(sid, ref);
            ++i;
        }
    }

    public void unregister(BundleContext context) {
        RemoteCapabilitiesManager capMan;
        this.debug("[unregister] Unregistering...");
        context.removeServiceListener((ServiceListener)this);
        this.services = null;
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        if ((capMan = Activator.getCapabilitiesManager()) != null) {
            capMan.setCapability("remote.service.support", new Boolean(false));
        }
        this.bc = null;
        this.debug("[unregister] Unregistered.");
    }

    public String checkFilter(String filter) {
        this.debug("[checkFilter] >>> filter: " + filter);
        try {
            this.bc.createFilter(filter);
            this.debug("[checkFilter] Filter check is successful");
            return null;
        }
        catch (InvalidSyntaxException e) {
            this.debug("[checkFilter] Unable to create filter", e);
            return e.toString();
        }
    }

    public Dictionary[] getAllRemoteServices(String clazz, String filter) {
        ServiceReference[] refs;
        this.debug("[getAllRemoteServices] >>> clazz: " + clazz + "; filter: " + filter);
        try {
            refs = this.bc.getAllServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        this.debug("[getAllRemoteServices] " + (refs != null ? refs.length : 0) + " services found.");
        return RemoteServiceAdminImpl.convertReferences(refs);
    }

    private ServiceReference getServiceReference(long id) {
        ServiceReference ref = (ServiceReference)this.services.get(new Long(id));
        return ref;
    }

    public Class[] remoteInterfaces() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("org.tigris.mtoolkit.iagent.rpc.RemoteServiceAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }

    public void addService(ServiceReference ref) {
        Long serviceId = (Long)ref.getProperty("service.id");
        if (TRACK_SERVICES_DEBUG) {
            this.debug("[addService] Track service: " + ref + "; id: " + serviceId);
        }
        this.services.put(serviceId, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(ServiceReference ref) {
        Long serviceId = (Long)ref.getProperty("service.id");
        if (TRACK_SERVICES_DEBUG) {
            this.debug("[addService] Stop tracking service: " + ref + "; id: " + serviceId);
        }
        Map map = this.services;
        synchronized (map) {
            this.services.remove(serviceId);
        }
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.addService(event.getServiceReference());
                break;
            }
            case 4: {
                this.removeService(event.getServiceReference());
            }
        }
        this.postRemoteEvent(event);
    }

    private void postRemoteEvent(ServiceEvent event) {
        if (this.systemBundle == null) {
            this.systemBundle = this.bc.getBundle(0L);
        }
        if (this.systemBundle.getState() == 16) {
            return;
        }
        if (this.bc.getBundle().getState() == 16) {
            return;
        }
        EventSynchronizer synchronizer = Activator.getSynchronizer();
        if (synchronizer != null) {
            Dictionary convertedServiceEvent = this.convertServiceEvent(event);
            this.debug("[postRemoteEvent] Posting remote event: " + DebugUtils.convertForDebug(convertedServiceEvent) + "; type: " + "iagent_service_event");
            synchronizer.enqueue(new EventData(convertedServiceEvent, "iagent_service_event"));
        } else {
            this.debug("[postRemoteEvent] Event synchronizer was disabled");
        }
    }

    private Dictionary convertServiceEvent(ServiceEvent event) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        switch (event.getType()) {
            case 1: {
                ((Dictionary)props).put(EVENT_TYPE_KEY, new Integer(1));
                break;
            }
            case 2: {
                ((Dictionary)props).put(EVENT_TYPE_KEY, new Integer(2));
                break;
            }
            case 4: {
                ((Dictionary)props).put(EVENT_TYPE_KEY, new Integer(4));
            }
        }
        ((Dictionary)props).put("service.id", event.getServiceReference().getProperty("service.id"));
        ((Dictionary)props).put("objectClass", event.getServiceReference().getProperty("objectClass"));
        return props;
    }

    public long getBundle(long id) {
        this.debug("[getBundle] >>> id: " + id);
        ServiceReference ref = this.getServiceReference(id);
        if (ref == null) {
            this.info("[getBundle] No such service");
            return -1L;
        }
        long bundleID = ref.getBundle().getBundleId();
        this.debug("[getBundle] bundle id: " + bundleID);
        return bundleID;
    }

    public Dictionary getProperties(long id) {
        this.debug("[getProperties] >>> id: " + id);
        ServiceReference ref = this.getServiceReference(id);
        if (ref == null) {
            this.info("[getProperties] No such service");
            return null;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] keys = ref.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            Object prop = ref.getProperty(keys[i]);
            ((Dictionary)props).put(keys[i], this.convertProperty(prop));
            ++i;
        }
        this.debug("[getProperties] service properties: " + DebugUtils.convertForDebug(props));
        return props;
    }

    private Object convertProperty(Object value) {
        if (value == null) {
            return null;
        }
        if (this.isFilterSupportedClass(value.getClass())) {
            return value;
        }
        if (value.getClass().isArray()) {
            Class<?> componentType = value.getClass().getComponentType();
            if (this.isFilterSupportedClass(componentType)) {
                return value;
            }
            return this.convertCollection(value);
        }
        if (value instanceof Collection) {
            boolean supported = true;
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (this.isFilterSupportedClass(next.getClass())) continue;
                supported = false;
                break;
            }
            if (supported) {
                return value;
            }
            return this.convertCollection(value);
        }
        return value.toString();
    }

    private String[] convertCollection(Object convertible) {
        String[] result;
        if (convertible.getClass().isArray()) {
            Object[] array = (Object[])convertible;
            result = new String[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = array[i] != null ? array[i].toString() : null;
                ++i;
            }
        } else if (convertible instanceof Collection) {
            Collection c = (Collection)convertible;
            result = new String[c.size()];
            int i = 0;
            Iterator it = c.iterator();
            while (it.hasNext() && i < result.length) {
                Object next = it.next();
                result[i] = next != null ? next.toString() : null;
                ++i;
            }
        } else {
            throw new IllegalArgumentException("The passsed convertible is neither array or Collection");
        }
        return result;
    }

    private boolean isFilterSupportedClass(Class clazz) {
        int i = 0;
        while (i < this.filterSupportedClasses.length) {
            if (this.filterSupportedClasses[i].equals(clazz)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public long[] getUsingBundles(long id) {
        this.debug("[getUsingBundles] >>> id: " + id);
        ServiceReference ref = this.getServiceReference(id);
        if (ref == null) {
            this.info("[getUsingBundles] No such service");
            return null;
        }
        Bundle[] bundles = ref.getUsingBundles();
        long[] bids = RemoteBundleAdminImpl.convertBundlesToIds(bundles);
        this.debug("[getUsingBundles] bundles: " + DebugUtils.convertForDebug(bids));
        return bids;
    }

    public boolean isServiceStale(long id) {
        boolean stale = this.services.get(new Long(id)) == null;
        this.debug("[isServiceStale] id: " + id + "; stale: " + stale);
        return stale;
    }

    static Dictionary[] convertReferences(ServiceReference[] refs) {
        if (refs == null) {
            return new Dictionary[0];
        }
        Dictionary[] refsProps = new Dictionary[refs.length];
        int i = 0;
        while (i < refs.length) {
            refsProps[i] = new Hashtable();
            refsProps[i].put("service.id", refs[i].getProperty("service.id"));
            refsProps[i].put("objectClass", refs[i].getProperty("objectClass"));
            ++i;
        }
        return refsProps;
    }

    private final void debug(String message) {
        DebugUtils.debug(this, message);
    }

    private final void debug(String message, Throwable t) {
        DebugUtils.debug(this, message, t);
    }

    private final void info(String message) {
        DebugUtils.info(this, message);
    }

    public long getRemoteServiceID() {
        ServiceReference localRef;
        block5: {
            ServiceRegistration localRegistration;
            block4: {
                try {
                    localRegistration = this.registration;
                    if (localRegistration != null) break block4;
                    return -1L;
                }
                catch (IllegalStateException illegalStateException) {
                    return -1L;
                }
            }
            localRef = localRegistration.getReference();
            if (localRef != null) break block5;
            return -1L;
        }
        return (Long)localRef.getProperty("service.id");
    }
}

