/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.kura.net.NetworkAdminService;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.net.GwtNetworkServiceImpl;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtFirewallNatEntry;
import org.eclipse.kura.web.shared.model.GwtFirewallOpenPortEntry;
import org.eclipse.kura.web.shared.model.GwtFirewallPortForwardEntry;
import org.eclipse.kura.web.shared.model.GwtModemPdpEntry;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiChannelFrequency;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiHotspotEntry;
import org.eclipse.kura.web.shared.model.GwtWifiRadioMode;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtNetworkService;

public class GwtNetworkServiceImplFacade
extends OsgiRemoteServiceServlet
implements GwtNetworkService {
    private static final long serialVersionUID = -4188750359099902616L;

    @Override
    public List<GwtNetInterfaceConfig> findNetInterfaceConfigurations(boolean recompute) throws GwtKuraException {
        if (this.isNet2()) {
            return org.eclipse.kura.web.server.net2.GwtNetworkServiceImpl.findNetInterfaceConfigurations(recompute);
        }
        return GwtNetworkServiceImpl.findNetInterfaceConfigurations(recompute);
    }

    @Override
    public void updateNetInterfaceConfigurations(GwtXSRFToken xsrfToken, GwtNetInterfaceConfig config) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            org.eclipse.kura.web.server.net2.GwtNetworkServiceImpl.updateNetInterfaceConfigurations(config);
        } else {
            GwtNetworkServiceImpl.updateNetInterfaceConfigurations(config);
        }
    }

    public ArrayList<GwtFirewallOpenPortEntry> findDeviceFirewallOpenPorts(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return (ArrayList)org.eclipse.kura.web.server.net2.GwtNetworkServiceImpl.findDeviceFirewallOpenPorts();
        }
        return GwtNetworkServiceImpl.findDeviceFirewallOpenPorts();
    }

    public ArrayList<GwtWifiHotspotEntry> findWifiHotspots(GwtXSRFToken xsrfToken, String interfaceName, String wirelessSsid) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return new ArrayList<GwtWifiHotspotEntry>(org.eclipse.kura.web.server.net2.GwtNetworkServiceImpl.findWifiHotspots(interfaceName));
        }
        return GwtNetworkServiceImpl.findWifiHotspots(interfaceName, wirelessSsid);
    }

    @Override
    public List<GwtModemPdpEntry> findPdpContextInfo(GwtXSRFToken xsrfToken, String interfaceName) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return new ArrayList<GwtModemPdpEntry>();
        }
        return GwtNetworkServiceImpl.findPdpContextInfo(interfaceName);
    }

    @Override
    public boolean verifyWifiCredentials(GwtXSRFToken xsrfToken, String interfaceName, GwtWifiConfig gwtWifiConfig) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return false;
        }
        return GwtNetworkServiceImpl.verifyWifiCredentials(interfaceName, gwtWifiConfig);
    }

    public ArrayList<GwtFirewallPortForwardEntry> findDeviceFirewallPortForwards(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return (ArrayList)org.eclipse.kura.web.server.net2.GwtNetworkServiceImpl.findDeviceFirewallPortForwards();
        }
        return GwtNetworkServiceImpl.findDeviceFirewallPortForwards();
    }

    public ArrayList<GwtFirewallNatEntry> findDeviceFirewallNATs(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return org.eclipse.kura.web.server.net2.GwtNetworkServiceImpl.findDeviceFirewallNATs();
        }
        return GwtNetworkServiceImpl.findDeviceFirewallNATs();
    }

    @Override
    public void updateDeviceFirewallOpenPorts(GwtXSRFToken xsrfToken, List<GwtFirewallOpenPortEntry> entries) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        GwtNetworkServiceImpl.updateDeviceFirewallOpenPorts(entries);
    }

    @Override
    public void updateDeviceFirewallPortForwards(GwtXSRFToken xsrfToken, List<GwtFirewallPortForwardEntry> entries) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        GwtNetworkServiceImpl.updateDeviceFirewallPortForwards(entries);
    }

    @Override
    public void updateDeviceFirewallNATs(GwtXSRFToken xsrfToken, List<GwtFirewallNatEntry> entries) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        GwtNetworkServiceImpl.updateDeviceFirewallNATs(entries);
    }

    @Override
    public void renewDhcpLease(GwtXSRFToken xsrfToken, String interfaceName) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (!this.isNet2()) {
            GwtNetworkServiceImpl.renewDhcpLease(interfaceName);
        }
    }

    @Override
    public List<GwtWifiChannelFrequency> findFrequencies(GwtXSRFToken xsrfToken, String interfaceName, GwtWifiRadioMode radioMode) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return org.eclipse.kura.web.server.net2.GwtNetworkServiceImpl.findFrequencies(interfaceName, radioMode);
        }
        return GwtNetworkServiceImpl.findFrequencies(interfaceName, radioMode);
    }

    @Override
    public String getWifiCountryCode(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return org.eclipse.kura.web.server.net2.GwtNetworkServiceImpl.getWifiCountryCode();
        }
        return GwtNetworkServiceImpl.getWifiCountryCode();
    }

    @Override
    public boolean isIEEE80211ACSupported(GwtXSRFToken xsrfToken, String ifaceName) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return true;
        }
        return GwtNetworkServiceImpl.isIEEE80211ACSupported(ifaceName);
    }

    @Override
    public List<String> getDhcpLeases(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        if (this.isNet2()) {
            return new ArrayList<String>();
        }
        return GwtNetworkServiceImpl.getDhcpLeases();
    }

    @Override
    public boolean isNet2() {
        try {
            ServiceLocator.getInstance().getService(NetworkAdminService.class);
            return false;
        }
        catch (GwtKuraException gwtKuraException) {
            return true;
        }
    }
}

