/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.web.server.GwtSecurityTokenServiceImpl;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuraRemoteServiceServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = 3473193315046407200L;
    private static final Logger logger = LoggerFactory.getLogger(KuraRemoteServiceServlet.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");

    public void checkXSRFToken(GwtXSRFToken xsrfToken) throws GwtKuraException {
        HttpServletRequest req = (HttpServletRequest)this.perThreadRequest.get();
        KuraRemoteServiceServlet.performXSRFTokenValidation(req, xsrfToken);
    }

    private static void performXSRFTokenValidation(HttpServletRequest req, GwtXSRFToken userToken) throws GwtKuraException {
        HttpSession session = req.getSession(false);
        if (!KuraRemoteServiceServlet.isValidXSRFToken(req, userToken.getToken())) {
            logger.info("XSRF token is NOT VALID");
            logger.info("Invalid User Token={}", (Object)userToken.getToken());
            logger.debug("\tSender IP: {}", (Object)req.getRemoteAddr());
            logger.debug("\tSender Host: {}", (Object)req.getRemoteHost());
            logger.debug("\tSender Port: {}", (Object)req.getRemotePort());
            logger.debug("\tFull Request URL\n {}?{}\n\n", (Object)req.getRequestURL(), (Object)req.getQueryString());
            session.invalidate();
            logger.debug("Session invalidated.");
            auditLogger.warn("UI XSRF - Failure - XSRF Token validation error for user: {}, session {}", session.getAttribute(Attributes.AUTORIZED_USER.getValue()), (Object)session.getId());
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, null, "Invalid XSRF token");
        }
    }

    public static boolean isValidXSRFToken(HttpServletRequest req, String userToken) {
        logger.debug("Starting XSRF Token validation...'");
        if (userToken == null) {
            logger.debug("XSRF Token is NOT VALID -> NULL TOKEN");
            return false;
        }
        Optional<Cookie> cookie = Arrays.stream(req.getCookies()).filter(c -> "JSESSIONID".equals(c.getName())).findAny();
        if (!cookie.isPresent() || Objects.isNull(cookie.get().getValue()) || cookie.get().getValue().isEmpty()) {
            throw new RpcTokenException("Unable to generate XSRF cookie: the session cookie is not set or empty!");
        }
        String serverXSRFToken = null;
        BundleContext context = FrameworkUtil.getBundle(GwtSecurityTokenServiceImpl.class).getBundleContext();
        ServiceReference ref = context.getServiceReference(CryptoService.class);
        try {
            try {
                CryptoService cryptoService = (CryptoService)ServiceLocator.getInstance().getService(ref);
                serverXSRFToken = cryptoService.sha1Hash(cookie.get().getValue());
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException | GwtKuraException exception) {
                throw new RpcTokenException("Unable to verify the XSRF token: the crypto service is unavailable!");
            }
        }
        finally {
            context.ungetService(ref);
        }
        if (!Objects.isNull(serverXSRFToken) && serverXSRFToken.equals(userToken)) {
            return true;
        }
        logger.debug("XSRF Token is NOT VALID - {}", (Object)userToken);
        return false;
    }

    public static String getFieldFromMultiPartForm(HttpServletRequest req, String fieldName) throws FileUploadException {
        String fieldValue = null;
        ServletFileUpload upload = new ServletFileUpload();
        List items = upload.parseRequest(req);
        for (FileItem item : items) {
            String name;
            if (!item.isFormField() || !(name = item.getFieldName()).equals(fieldName)) continue;
            fieldValue = item.getString();
            logger.debug("Found field name '{}' with value: {}", (Object)name, (Object)fieldValue);
        }
        return fieldValue;
    }

    public static void checkXSRFToken(HttpServletRequest req, GwtXSRFToken token) throws GwtKuraException {
        KuraRemoteServiceServlet.performXSRFTokenValidation(req, token);
    }

    public static void checkXSRFTokenMultiPart(HttpServletRequest req, GwtXSRFToken token) throws GwtKuraException {
        KuraRemoteServiceServlet.performXSRFTokenValidation(req, token);
    }
}

