/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller;

import com.eclipsesource.json.JsonObject;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.inventory.resources.DockerContainer;
import org.eclipse.kura.core.inventory.resources.DockerContainers;
import org.eclipse.kura.core.inventory.resources.SystemBundleRef;
import org.eclipse.kura.core.inventory.resources.SystemBundles;
import org.eclipse.kura.core.inventory.resources.SystemDeploymentPackages;
import org.eclipse.kura.core.inventory.resources.SystemPackages;
import org.eclipse.kura.core.inventory.resources.SystemResourcesInfo;
import org.eclipse.kura.core.keystore.util.EntryInfo;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.keystore.KeystoreEntryInfoMapper;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.message.CloudPayloadJsonDecoder;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.message.CloudPayloadJsonEncoder;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.system.JsonJavaDockerContainersMapper;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.system.JsonJavaSystemBundleRefMapper;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.system.JsonJavaSystemBundlesMapper;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.system.JsonJavaSystemDeploymentPackagesMapper;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.system.JsonJavaSystemPackagesMapper;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.system.JsonJavaSystemResourcesMapper;
import org.eclipse.kura.internal.json.marshaller.unmarshaller.wiregraph.WireGraphJsonMarshallUnmarshallImpl;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.wire.graph.WireGraphConfiguration;

public class JsonMarshallUnmarshallImpl
implements Marshaller,
Unmarshaller {
    public String marshal(Object object) throws KuraException {
        if (object instanceof WireGraphConfiguration) {
            JsonObject result = WireGraphJsonMarshallUnmarshallImpl.marshalWireGraphConfiguration((WireGraphConfiguration)object);
            return result.toString();
        }
        if (object instanceof KuraPayload) {
            return CloudPayloadJsonEncoder.marshal((KuraPayload)object);
        }
        if (object instanceof SystemDeploymentPackages) {
            return JsonJavaSystemDeploymentPackagesMapper.marshal((SystemDeploymentPackages)object);
        }
        if (object instanceof SystemBundles) {
            return JsonJavaSystemBundlesMapper.marshal((SystemBundles)object);
        }
        if (object instanceof SystemPackages) {
            return JsonJavaSystemPackagesMapper.marshal((SystemPackages)object);
        }
        if (object instanceof DockerContainers) {
            return JsonJavaDockerContainersMapper.marshal((DockerContainers)object);
        }
        if (object instanceof SystemResourcesInfo) {
            return JsonJavaSystemResourcesMapper.marshal((SystemResourcesInfo)object);
        }
        throw new KuraException(KuraErrorCode.INVALID_PARAMETER);
    }

    public <T> T unmarshal(String s, Class<T> clazz) throws KuraException {
        if (clazz.equals(WireGraphConfiguration.class)) {
            return (T)WireGraphJsonMarshallUnmarshallImpl.unmarshalToWireGraphConfiguration(s);
        }
        if (clazz.equals(KuraPayload.class)) {
            return (T)CloudPayloadJsonDecoder.buildFromString(s);
        }
        if (EntryInfo.class.isAssignableFrom(clazz)) {
            return (T)KeystoreEntryInfoMapper.unmarshal(s, clazz);
        }
        if (clazz.equals(SystemBundleRef.class)) {
            return (T)JsonJavaSystemBundleRefMapper.unmarshal(s);
        }
        if (clazz.equals(DockerContainer.class)) {
            return (T)JsonJavaDockerContainersMapper.unmarshal(s);
        }
        throw new IllegalArgumentException("Invalid parameter!");
    }
}

