/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.dependencies;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.dm.BundleDependency;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyService;
import org.apache.felix.dm.InvocationUtil;
import org.apache.felix.dm.impl.DefaultNullObject;
import org.apache.felix.dm.impl.Logger;
import org.apache.felix.dm.impl.dependencies.DependencyBase;
import org.apache.felix.dm.tracker.BundleTracker;
import org.apache.felix.dm.tracker.BundleTrackerCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class BundleDependencyImpl
extends DependencyBase
implements BundleDependency,
BundleTrackerCustomizer,
ComponentDependencyDeclaration {
    private final BundleContext m_context;
    private boolean m_isStarted;
    private BundleTracker m_tracker;
    private int m_stateMask = 38;
    private List m_services = new ArrayList();
    private boolean m_isAvailable;
    private Object m_callbackInstance;
    private String m_callbackAdded;
    private String m_callbackChanged;
    private String m_callbackRemoved;
    private boolean m_autoConfig;
    private Bundle m_bundleInstance;
    private Filter m_filter;
    private long m_bundleId = -1L;
    private String m_autoConfigInstance;
    private Object m_nullObject;
    private boolean m_autoConfigInvoked;
    private boolean m_propagate;
    private Object m_propagateCallbackInstance;
    private String m_propagateCallbackMethod;
    static /* synthetic */ Class class$org$osgi$framework$Bundle;
    static /* synthetic */ Class class$java$lang$Object;

    public BundleDependencyImpl(BundleContext context, Logger logger) {
        super(logger);
        this.m_context = context;
        this.m_autoConfig = true;
    }

    public BundleDependencyImpl(BundleDependencyImpl prototype) {
        super(prototype);
        this.m_context = prototype.m_context;
        this.m_autoConfig = prototype.m_autoConfig;
        this.m_stateMask = prototype.m_stateMask;
        this.m_nullObject = prototype.m_nullObject;
        this.m_bundleInstance = prototype.m_bundleInstance;
        this.m_filter = prototype.m_filter;
        this.m_bundleId = prototype.m_bundleId;
        this.m_propagate = prototype.m_propagate;
        this.m_callbackInstance = prototype.m_callbackInstance;
        this.m_callbackAdded = prototype.m_callbackAdded;
        this.m_callbackChanged = prototype.m_callbackChanged;
        this.m_callbackRemoved = prototype.m_callbackRemoved;
        this.m_autoConfigInstance = prototype.m_autoConfigInstance;
    }

    public Dependency createCopy() {
        return new BundleDependencyImpl(this);
    }

    public BundleDependency setInstanceBound(boolean isInstanceBound) {
        this.setIsInstanceBound(isInstanceBound);
        return this;
    }

    public synchronized boolean isAvailable() {
        return this.m_isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(DependencyService service) {
        boolean needsStarting = false;
        BundleDependencyImpl bundleDependencyImpl = this;
        synchronized (bundleDependencyImpl) {
            this.m_services.add(service);
            if (!this.m_isStarted) {
                this.m_tracker = new BundleTracker(this.m_context, this.m_stateMask, this);
                this.m_isStarted = true;
                needsStarting = true;
            }
        }
        if (needsStarting) {
            this.m_tracker.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DependencyService service) {
        boolean needsStopping = false;
        BundleDependencyImpl bundleDependencyImpl = this;
        synchronized (bundleDependencyImpl) {
            if (this.m_services.size() == 1 && this.m_services.contains(service)) {
                this.m_isStarted = false;
                needsStopping = true;
            }
        }
        if (needsStopping) {
            this.m_tracker.close();
            this.m_tracker = null;
            this.m_services.remove(service);
        }
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        if ((this.m_stateMask & 0x20) != 0) {
            sb.append("active ");
        }
        if ((this.m_stateMask & 2) != 0) {
            sb.append("installed ");
        }
        if ((this.m_stateMask & 4) != 0) {
            sb.append("resolved ");
        }
        if (this.m_filter != null) {
            sb.append(this.m_filter.toString());
        }
        if (this.m_bundleId != -1L) {
            sb.append("bundle.id=" + this.m_bundleId);
        }
        return sb.toString();
    }

    public int getState() {
        return (this.isAvailable() ? 1 : 0) + (this.isRequired() ? 2 : 0);
    }

    public String getType() {
        return "bundle";
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        Dictionary headers;
        long bundleId = bundle.getBundleId();
        if (this.m_bundleId >= 0L && this.m_bundleId != bundleId) {
            return null;
        }
        Filter filter = this.m_filter;
        if (filter != null && !this.m_filter.match(headers = bundle.getHeaders())) {
            return null;
        }
        return bundle;
    }

    public void addedBundle(Bundle bundle, BundleEvent event, Object object) {
        boolean makeAvailable = this.makeAvailable();
        Object[] services = this.m_services.toArray();
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            if (makeAvailable) {
                ds.dependencyAvailable(this);
                if (this.isRequired()) continue;
                this.invokeAdded(ds, bundle);
                continue;
            }
            ds.dependencyChanged(this);
            this.invokeAdded(ds, bundle);
        }
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        Object[] services = this.m_services.toArray();
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            ds.dependencyChanged(this);
            if (!ds.isRegistered()) continue;
            this.invokeChanged(ds, bundle);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        boolean makeUnavailable = this.makeUnavailable();
        Object[] services = this.m_services.toArray();
        for (int i = 0; i < services.length; ++i) {
            DependencyService ds = (DependencyService)services[i];
            if (makeUnavailable) {
                ds.dependencyUnavailable(this);
                if (this.isRequired()) continue;
                this.invokeRemoved(ds, bundle);
                continue;
            }
            ds.dependencyChanged(this);
            this.invokeRemoved(ds, bundle);
        }
    }

    private synchronized boolean makeAvailable() {
        if (!this.isAvailable()) {
            this.m_isAvailable = true;
            return true;
        }
        return false;
    }

    private synchronized boolean makeUnavailable() {
        if (this.isAvailable() && this.m_tracker.getTrackingCount() == 0) {
            this.m_isAvailable = false;
            return true;
        }
        return false;
    }

    public void invokeAdded(DependencyService dependencyService, Bundle service) {
        this.invoke(dependencyService, service, this.m_callbackAdded);
    }

    public void invokeChanged(DependencyService dependencyService, Bundle service) {
        this.invoke(dependencyService, service, this.m_callbackChanged);
    }

    public void invokeRemoved(DependencyService dependencyService, Bundle service) {
        this.invoke(dependencyService, service, this.m_callbackRemoved);
    }

    public void invoke(DependencyService dependencyService, Bundle service, String name) {
        if (name != null) {
            dependencyService.invokeCallbackMethod(this.getCallbackInstances(dependencyService), name, new Class[][]{{class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = BundleDependencyImpl.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle}, {class$java$lang$Object == null ? (class$java$lang$Object = BundleDependencyImpl.class$("java.lang.Object")) : class$java$lang$Object}, new Class[0]}, new Object[][]{{service}, {service}, new Object[0]});
        }
    }

    private synchronized Object[] getCallbackInstances(DependencyService dependencyService) {
        if (this.m_callbackInstance == null) {
            return dependencyService.getCompositionInstances();
        }
        return new Object[]{this.m_callbackInstance};
    }

    public synchronized BundleDependency setCallbacks(String added, String removed) {
        return this.setCallbacks(null, added, null, removed);
    }

    public synchronized BundleDependency setCallbacks(String added, String changed, String removed) {
        return this.setCallbacks(null, added, changed, removed);
    }

    public synchronized BundleDependency setCallbacks(Object instance, String added, String removed) {
        return this.setCallbacks(instance, added, null, removed);
    }

    public synchronized BundleDependency setCallbacks(Object instance, String added, String changed, String removed) {
        this.ensureNotActive();
        if (!(added == null && removed == null && changed == null || this.m_autoConfigInvoked)) {
            this.setAutoConfig(false);
        }
        this.m_callbackInstance = instance;
        this.m_callbackAdded = added;
        this.m_callbackChanged = changed;
        this.m_callbackRemoved = removed;
        return this;
    }

    private void ensureNotActive() {
        if (this.m_tracker != null) {
            throw new IllegalStateException("Cannot modify state while active.");
        }
    }

    public synchronized BundleDependency setAutoConfig(boolean autoConfig) {
        this.ensureNotActive();
        this.m_autoConfig = autoConfig;
        this.m_autoConfigInvoked = true;
        return this;
    }

    public synchronized BundleDependency setAutoConfig(String instanceName) {
        this.ensureNotActive();
        this.m_autoConfig = instanceName != null;
        this.m_autoConfigInstance = instanceName;
        this.m_autoConfigInvoked = true;
        return this;
    }

    public synchronized BundleDependency setRequired(boolean required) {
        this.ensureNotActive();
        this.setIsRequired(required);
        return this;
    }

    public BundleDependency setBundle(Bundle bundle) {
        this.m_bundleId = bundle.getBundleId();
        return this;
    }

    public BundleDependency setFilter(String filter) throws IllegalArgumentException {
        if (filter != null) {
            try {
                this.m_filter = this.m_context.createFilter(filter);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return this;
    }

    public BundleDependency setStateMask(int mask) {
        this.m_stateMask = mask;
        return this;
    }

    public synchronized boolean isAutoConfig() {
        return this.m_autoConfig;
    }

    public Bundle getBundle() {
        Bundle[] bundles = this.m_tracker.getBundles();
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public Object getAutoConfigInstance() {
        return this.lookupBundle();
    }

    public Bundle lookupBundle() {
        Bundle service = null;
        if (this.m_isStarted) {
            service = this.getBundle();
        } else {
            Bundle[] bundles = this.m_context.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                if ((bundles[i].getState() & this.m_stateMask) <= 0) continue;
                Filter filter = this.m_filter;
                if (filter == null) {
                    service = bundles[i];
                    break;
                }
                if (!filter.match(bundles[i].getHeaders())) continue;
                service = bundles[i];
                break;
            }
        }
        if (service == null && this.isAutoConfig() && service == null) {
            service = this.getNullObject();
        }
        return service;
    }

    private Bundle getNullObject() {
        if (this.m_nullObject == null) {
            try {
                this.m_nullObject = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = BundleDependencyImpl.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle}, (InvocationHandler)new DefaultNullObject());
            }
            catch (Exception e) {
                this.m_logger.log(1, "Could not create null object for Bundle.", e);
            }
        }
        return (Bundle)this.m_nullObject;
    }

    public String getAutoConfigName() {
        return this.m_autoConfigInstance;
    }

    public Class getAutoConfigType() {
        return class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = BundleDependencyImpl.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle;
    }

    public void invokeAdded(DependencyService service) {
        this.m_bundleInstance = this.lookupBundle();
        this.invokeAdded(service, this.m_bundleInstance);
    }

    public void invokeRemoved(DependencyService service) {
        this.invokeRemoved(service, this.m_bundleInstance);
        this.m_bundleInstance = null;
    }

    public BundleDependency setPropagate(boolean propagate) {
        this.ensureNotActive();
        this.m_propagate = propagate;
        return this;
    }

    public BundleDependency setPropagate(Object instance, String method) {
        this.setPropagate(instance != null && method != null);
        this.m_propagateCallbackInstance = instance;
        this.m_propagateCallbackMethod = method;
        return this;
    }

    public Dictionary getProperties() {
        Bundle bundle = this.lookupBundle();
        if (bundle != null) {
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                try {
                    return (Dictionary)InvocationUtil.invokeCallbackMethod(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod, new Class[][]{{class$org$osgi$framework$Bundle == null ? (class$org$osgi$framework$Bundle = BundleDependencyImpl.class$("org.osgi.framework.Bundle")) : class$org$osgi$framework$Bundle}}, new Object[][]{{bundle}});
                }
                catch (InvocationTargetException e) {
                    this.m_logger.log(2, "Exception while invoking callback method", e.getCause());
                }
                catch (Exception e) {
                    this.m_logger.log(2, "Exception while trying to invoke callback method", e);
                }
                throw new IllegalStateException("Could not invoke callback");
            }
            return bundle.getHeaders();
        }
        throw new IllegalStateException("cannot find bundle");
    }

    public boolean isPropagated() {
        return this.m_propagate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

