/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.dhcp;

import java.util.List;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.dhcp.DhcpServerCfg;
import org.eclipse.kura.net.dhcp.DhcpServerCfgIP;
import org.eclipse.kura.net.dhcp.DhcpServerConfig;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class DhcpServerConfigIP<T extends IPAddress>
implements DhcpServerConfig {
    private String interfaceName;
    private boolean enabled;
    private T subnet;
    private T routerAddress;
    private T subnetMask;
    private int defaultLeaseTime;
    private int maximumLeaseTime;
    private short prefix;
    private T rangeStart;
    private T rangeEnd;
    private boolean passDns;
    private List<T> dnsServers;

    @Deprecated
    public DhcpServerConfigIP(String interfaceName, boolean enabled, T subnet, T routerAddress, T subnetMask, int defaultLeaseTime, int maximumLeaseTime, short prefix, T rangeStart, T rangeEnd, boolean passDns, List<T> dnsServers) {
        this.interfaceName = interfaceName;
        this.enabled = enabled;
        this.subnet = subnet;
        this.routerAddress = routerAddress;
        this.subnetMask = subnetMask;
        this.defaultLeaseTime = defaultLeaseTime;
        this.maximumLeaseTime = maximumLeaseTime;
        this.prefix = prefix;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
        this.passDns = passDns;
        this.dnsServers = dnsServers;
    }

    public DhcpServerConfigIP(DhcpServerCfg dhcpServerCfg, DhcpServerCfgIP<T> dhcpServerCfgIP) {
        this.interfaceName = dhcpServerCfg.getInterfaceName();
        this.enabled = dhcpServerCfg.isEnabled();
        this.subnet = dhcpServerCfgIP.getSubnet();
        this.routerAddress = dhcpServerCfgIP.getRouterAddress();
        this.subnetMask = dhcpServerCfgIP.getSubnetMask();
        this.defaultLeaseTime = dhcpServerCfg.getDefaultLeaseTime();
        this.maximumLeaseTime = dhcpServerCfg.getMaximumLeaseTime();
        this.prefix = dhcpServerCfgIP.getPrefix();
        this.rangeStart = dhcpServerCfgIP.getRangeStart();
        this.rangeEnd = dhcpServerCfgIP.getRangeEnd();
        this.passDns = dhcpServerCfg.isPassDns();
        this.dnsServers = dhcpServerCfgIP.getDnsServers();
    }

    @Override
    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabledRouterMode(boolean enabled) {
        this.enabled = enabled;
    }

    public T getSubnet() {
        return this.subnet;
    }

    public void setSubnet(T subnet) {
        this.subnet = subnet;
    }

    public T getRouterAddress() {
        return this.routerAddress;
    }

    public void setRouterAddress(T routerAddress) {
        this.routerAddress = routerAddress;
    }

    public T getSubnetMask() {
        return this.subnetMask;
    }

    public void setSubnetMask(T subnetMask) {
        this.subnetMask = subnetMask;
    }

    @Override
    public int getDefaultLeaseTime() {
        return this.defaultLeaseTime;
    }

    public void setDefaultLeaseTime(int defaultLeaseTime) {
        this.defaultLeaseTime = defaultLeaseTime;
    }

    @Override
    public int getMaximumLeaseTime() {
        return this.maximumLeaseTime;
    }

    public void setMaximumLeaseTime(int maximumLeaseTime) {
        this.maximumLeaseTime = maximumLeaseTime;
    }

    @Override
    public short getPrefix() {
        return this.prefix;
    }

    public void setPrefix(short prefix) {
        this.prefix = prefix;
    }

    public T getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(T rangeStart) {
        this.rangeStart = rangeStart;
    }

    public T getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(T rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    @Override
    public boolean isPassDns() {
        return this.passDns;
    }

    public void setPassDns(boolean passDns) {
        this.passDns = passDns;
    }

    public List<T> getDnsServers() {
        return this.dnsServers;
    }

    public void setDnsServers(List<T> dnsServers) {
        this.dnsServers = dnsServers;
    }

    @Override
    public boolean isValid() {
        if (this.interfaceName == null || !this.isValidSubnet()) {
            return false;
        }
        return this.isValidPoolRange() && this.isValidLeaseTime() && this.prefix > 0;
    }

    private boolean isValidSubnet() {
        return this.subnet != null && this.subnetMask != null;
    }

    private boolean isValidPoolRange() {
        return this.rangeStart != null && this.rangeEnd != null;
    }

    private boolean isValidLeaseTime() {
        return this.defaultLeaseTime > 0 && this.maximumLeaseTime > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("# enabled? ").append(this.enabled).append("\n");
        sb.append("# prefix: ").append(this.prefix).append("\n");
        sb.append("# pass DNS? ").append(this.passDns).append("\n\n");
        sb.append("subnet " + ((IPAddress)this.subnet).getHostAddress() + " netmask " + ((IPAddress)this.subnetMask).getHostAddress() + " {\n");
        if (this.passDns && this.dnsServers != null && !this.dnsServers.isEmpty()) {
            sb.append("    option domain-name-servers ");
            int i = 0;
            while (i < this.dnsServers.size()) {
                if (this.dnsServers.get(i) != null) {
                    sb.append(((IPAddress)this.dnsServers.get(i)).getHostAddress());
                }
                if (i + 1 == this.dnsServers.size()) {
                    sb.append(";\n\n");
                } else {
                    sb.append(",");
                }
                ++i;
            }
        }
        if (this.interfaceName != null) {
            sb.append("    interface " + this.interfaceName + ";\n");
        }
        if (this.routerAddress != null) {
            sb.append("    option routers " + ((IPAddress)this.routerAddress).getHostAddress() + ";\n");
        }
        if (!this.passDns) {
            sb.append("    ddns-update-style none;\n");
            sb.append("    ddns-updates off;\n");
        }
        sb.append("    default-lease-time " + this.defaultLeaseTime + ";\n");
        if (this.maximumLeaseTime > -1) {
            sb.append("    max-lease-time " + this.maximumLeaseTime + ";\n");
        }
        sb.append("    pool {\n");
        sb.append("        range " + ((IPAddress)this.rangeStart).getHostAddress() + " " + ((IPAddress)this.rangeEnd).getHostAddress() + ";\n");
        sb.append("    }\n");
        sb.append("}\n");
        return sb.toString();
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 59 * result + (this.enabled ? 1 : 0);
        result = 59 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 59 * result + (this.subnet == null ? 0 : ((IPAddress)this.subnet).hashCode());
        result = 59 * result + (this.subnetMask == null ? 0 : ((IPAddress)this.subnetMask).hashCode());
        result = 59 * result + (this.routerAddress == null ? 0 : ((IPAddress)this.routerAddress).hashCode());
        result = 59 * result + (this.rangeStart == null ? 0 : ((IPAddress)this.rangeStart).hashCode());
        result = 59 * result + (this.rangeEnd == null ? 0 : ((IPAddress)this.rangeEnd).hashCode());
        result = 59 * result + (this.dnsServers == null ? 0 : this.dnsServers.hashCode());
        result = 59 * result + this.defaultLeaseTime;
        result = 59 * result + this.maximumLeaseTime;
        result = 59 * result + this.prefix;
        result = 59 * result + (this.passDns ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DhcpServerConfigIP other = (DhcpServerConfigIP)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        if (this.subnet == null ? other.subnet != null : !((IPAddress)this.subnet).equals(other.subnet)) {
            return false;
        }
        if (this.routerAddress == null ? other.routerAddress != null : !((IPAddress)this.routerAddress).equals(other.routerAddress)) {
            return false;
        }
        if (this.subnetMask == null ? other.subnetMask != null : !((IPAddress)this.subnetMask).equals(other.subnetMask)) {
            return false;
        }
        if (this.defaultLeaseTime != other.defaultLeaseTime) {
            return false;
        }
        if (this.maximumLeaseTime != other.maximumLeaseTime) {
            return false;
        }
        if (this.prefix != other.prefix) {
            return false;
        }
        if (this.rangeStart == null ? other.rangeStart != null : !((IPAddress)this.rangeStart).equals(other.rangeStart)) {
            return false;
        }
        if (this.rangeEnd == null ? other.rangeEnd != null : !((IPAddress)this.rangeEnd).equals(other.rangeEnd)) {
            return false;
        }
        if (this.passDns != other.passDns) {
            return false;
        }
        return !(this.dnsServers == null ? other.dnsServers != null : !this.dnsServers.equals(other.dnsServers));
    }
}

