/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.container.orchestration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.container.orchestration.RegistryCredentials;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ContainerConfiguration {
    private String containerName;
    private String containerImage;
    private String containerImageTag;
    private List<Integer> containerPortsExternal;
    private List<Integer> containerPortsInternal;
    private List<String> containerEnvVars;
    private List<String> containerDevices;
    private Map<String, String> containerVolumes;
    private Boolean containerPrivileged;
    private Boolean isFrameworkManaged = true;
    private Map<String, String> containerLoggerParameters;
    private String containerLoggingType;
    private Optional<RegistryCredentials> registryCredentials;
    private int imageDownloadTimeoutSeconds;

    private ContainerConfiguration() {
    }

    public boolean isFrameworkManaged() {
        return this.isFrameworkManaged;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getContainerImage() {
        return this.containerImage;
    }

    public String getContainerImageTag() {
        return this.containerImageTag;
    }

    public List<Integer> getContainerPortsExternal() {
        return this.containerPortsExternal;
    }

    public List<Integer> getContainerPortsInternal() {
        return this.containerPortsInternal;
    }

    public List<String> getContainerEnvVars() {
        return this.containerEnvVars;
    }

    public List<String> getContainerDevices() {
        return this.containerDevices;
    }

    public Map<String, String> getContainerVolumes() {
        return this.containerVolumes;
    }

    public boolean isContainerPrivileged() {
        return this.containerPrivileged;
    }

    public Map<String, String> getLoggerParameters() {
        return this.containerLoggerParameters;
    }

    public String getContainerLoggingType() {
        return this.containerLoggingType;
    }

    public Optional<RegistryCredentials> getRegistryCredentials() {
        return this.registryCredentials;
    }

    public int getImageDownloadTimeoutSeconds() {
        return this.imageDownloadTimeoutSeconds;
    }

    public static ContainerConfigurationBuilder builder() {
        return new ContainerConfigurationBuilder();
    }

    public int hashCode() {
        return Objects.hash(this.containerDevices, this.containerEnvVars, this.containerImage, this.containerImageTag, this.containerLoggerParameters, this.containerLoggingType, this.containerName, this.containerPortsExternal, this.containerPortsInternal, this.containerPrivileged, this.containerVolumes, this.imageDownloadTimeoutSeconds, this.isFrameworkManaged, this.registryCredentials);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContainerConfiguration)) {
            return false;
        }
        ContainerConfiguration other = (ContainerConfiguration)obj;
        return Objects.equals(this.containerDevices, other.containerDevices) && Objects.equals(this.containerEnvVars, other.containerEnvVars) && Objects.equals(this.containerImage, other.containerImage) && Objects.equals(this.containerImageTag, other.containerImageTag) && Objects.equals(this.containerLoggerParameters, other.containerLoggerParameters) && Objects.equals(this.containerLoggingType, other.containerLoggingType) && Objects.equals(this.containerName, other.containerName) && Objects.equals(this.containerPortsExternal, other.containerPortsExternal) && Objects.equals(this.containerPortsInternal, other.containerPortsInternal) && Objects.equals(this.containerPrivileged, other.containerPrivileged) && Objects.equals(this.containerVolumes, other.containerVolumes) && this.imageDownloadTimeoutSeconds == other.imageDownloadTimeoutSeconds && Objects.equals(this.isFrameworkManaged, other.isFrameworkManaged) && Objects.equals(this.registryCredentials, other.registryCredentials);
    }

    /* synthetic */ ContainerConfiguration(ContainerConfiguration containerConfiguration) {
        this();
    }

    public static final class ContainerConfigurationBuilder {
        private String containerName;
        private String containerImage;
        private String containerImageTag;
        private List<Integer> containerPortsExternal = new ArrayList<Integer>();
        private List<Integer> containerPortsInternal = new ArrayList<Integer>();
        private List<String> containerEnvVars = new LinkedList<String>();
        private List<String> containerDevices = new LinkedList<String>();
        private Map<String, String> containerVolumes = new HashMap<String, String>();
        private Boolean containerPrivileged = false;
        private Boolean isFrameworkManaged = false;
        private Map<String, String> containerLoggerParameters;
        private String containerLoggingType;
        private Optional<RegistryCredentials> registryCredentials;
        private int imageDownloadTimeoutSeconds = 500;

        public ContainerConfigurationBuilder setContainerName(String serviceName) {
            this.containerName = serviceName;
            return this;
        }

        public ContainerConfigurationBuilder setFrameworkManaged(Boolean isFrameworkManaged) {
            this.isFrameworkManaged = isFrameworkManaged;
            return this;
        }

        public ContainerConfigurationBuilder setContainerImage(String serviceImage) {
            this.containerImage = serviceImage;
            return this;
        }

        public ContainerConfigurationBuilder setContainerImageTag(String serviceImageTag) {
            this.containerImageTag = serviceImageTag;
            return this;
        }

        public ContainerConfigurationBuilder setExternalPorts(List<Integer> containerPortsExternal) {
            this.containerPortsExternal = new ArrayList<Integer>(containerPortsExternal);
            return this;
        }

        public ContainerConfigurationBuilder setInternalPorts(List<Integer> containerPortsInternal) {
            this.containerPortsInternal = new ArrayList<Integer>(containerPortsInternal);
            return this;
        }

        public ContainerConfigurationBuilder setEnvVars(List<String> vars) {
            this.containerEnvVars = new LinkedList<String>(vars);
            return this;
        }

        public ContainerConfigurationBuilder setDeviceList(List<String> devices) {
            this.containerDevices = new LinkedList<String>(devices);
            return this;
        }

        public ContainerConfigurationBuilder setVolumes(Map<String, String> volumeMap) {
            this.containerVolumes = new HashMap<String, String>(volumeMap);
            return this;
        }

        public ContainerConfigurationBuilder setLoggerParameters(Map<String, String> paramMap) {
            this.containerLoggerParameters = new HashMap<String, String>(paramMap);
            return this;
        }

        public ContainerConfigurationBuilder setLoggingType(String containerLoggingType) {
            this.containerLoggingType = containerLoggingType;
            return this;
        }

        public ContainerConfigurationBuilder setPrivilegedMode(Boolean containerPrivileged) {
            this.containerPrivileged = containerPrivileged;
            return this;
        }

        public ContainerConfigurationBuilder setRegistryCredentials(Optional<RegistryCredentials> registryCredentials) {
            this.registryCredentials = registryCredentials;
            return this;
        }

        public ContainerConfigurationBuilder setImageDownloadTimeoutSeconds(int imageDownloadTimeoutSeconds) {
            this.imageDownloadTimeoutSeconds = imageDownloadTimeoutSeconds;
            return this;
        }

        public ContainerConfiguration build() {
            ContainerConfiguration result = new ContainerConfiguration(null);
            result.containerName = Objects.requireNonNull(this.containerName, "Request Container Name cannot be null");
            result.containerImage = Objects.requireNonNull(this.containerImage, "Request Container Image cannot be null");
            result.containerImageTag = this.containerImageTag;
            result.containerPortsExternal = this.containerPortsExternal;
            result.containerPortsInternal = this.containerPortsInternal;
            result.containerEnvVars = this.containerEnvVars;
            result.containerDevices = this.containerDevices;
            result.containerVolumes = this.containerVolumes;
            result.containerPrivileged = this.containerPrivileged;
            result.isFrameworkManaged = this.isFrameworkManaged;
            result.containerLoggerParameters = this.containerLoggerParameters;
            result.containerLoggingType = this.containerLoggingType;
            result.registryCredentials = Objects.requireNonNull(this.registryCredentials, "Request Registry Credentials object cannot be null");
            result.imageDownloadTimeoutSeconds = this.imageDownloadTimeoutSeconds;
            return result;
        }
    }
}

