/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.json.marshaller.unmarshaller.system;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Arrays;
import org.eclipse.kura.core.inventory.resources.SystemDeploymentPackage;
import org.eclipse.kura.core.inventory.resources.SystemDeploymentPackages;

public class JsonJavaSystemDeploymentPackagesMapper {
    private static final String DEPLOYMENT_PACKAGES = "deploymentPackages";
    private static final String DP_NAME = "name";
    private static final String DP_VERSION = "version";
    private static final String DP_BUNDLES = "bundles";
    private static final String DP_ID = "id";
    private static final String DP_STATE = "state";

    private JsonJavaSystemDeploymentPackagesMapper() {
    }

    public static String marshal(SystemDeploymentPackages systemDPs) {
        JsonObject json = Json.object();
        JsonArray dps = new JsonArray();
        Arrays.asList(systemDPs.getDeploymentPackages()).stream().forEach(dp -> {
            JsonArray jsonArray2 = dps.add((JsonValue)JsonJavaSystemDeploymentPackagesMapper.getJsonDP(dp));
        });
        json.add(DEPLOYMENT_PACKAGES, (JsonValue)dps);
        return json.toString();
    }

    private static JsonObject getJsonDP(SystemDeploymentPackage dp) {
        JsonArray bundles = new JsonArray();
        Arrays.asList(dp.getBundleInfos()).stream().forEach(b -> {
            JsonObject jsonBundle = new JsonObject();
            jsonBundle.add(DP_NAME, b.getName());
            jsonBundle.add(DP_VERSION, b.getVersion());
            jsonBundle.add(DP_ID, b.getId());
            jsonBundle.add(DP_STATE, b.getState());
            bundles.add((JsonValue)jsonBundle);
        });
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(DP_NAME, dp.getName());
        jsonObject.add(DP_VERSION, dp.getVersion());
        jsonObject.add(DP_BUNDLES, (JsonValue)bundles);
        return jsonObject;
    }
}

