/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.net.AbstractNetInterface;
import org.eclipse.kura.core.net.EthernetInterfaceConfigImpl;
import org.eclipse.kura.core.net.LoopbackInterfaceConfigImpl;
import org.eclipse.kura.core.net.NetInterfaceAddressConfigImpl;
import org.eclipse.kura.core.net.NetInterfaceAddressImpl;
import org.eclipse.kura.core.net.NetworkConfigurationVisitor;
import org.eclipse.kura.core.net.WifiInterfaceAddressConfigImpl;
import org.eclipse.kura.core.net.WifiInterfaceAddressImpl;
import org.eclipse.kura.core.net.WifiInterfaceConfigImpl;
import org.eclipse.kura.core.net.modem.ModemInterfaceAddressConfigImpl;
import org.eclipse.kura.core.net.modem.ModemInterfaceConfigImpl;
import org.eclipse.kura.core.net.util.NetworkUtil;
import org.eclipse.kura.core.util.NetUtil;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IP6Address;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.NetConfigIP4;
import org.eclipse.kura.net.NetConfigIP6;
import org.eclipse.kura.net.NetInterfaceAddress;
import org.eclipse.kura.net.NetInterfaceAddressConfig;
import org.eclipse.kura.net.NetInterfaceConfig;
import org.eclipse.kura.net.NetInterfaceState;
import org.eclipse.kura.net.NetInterfaceStatus;
import org.eclipse.kura.net.NetInterfaceType;
import org.eclipse.kura.net.dhcp.DhcpServerCfg;
import org.eclipse.kura.net.dhcp.DhcpServerCfgIP4;
import org.eclipse.kura.net.dhcp.DhcpServerConfig;
import org.eclipse.kura.net.dhcp.DhcpServerConfig4;
import org.eclipse.kura.net.dhcp.DhcpServerConfigIP4;
import org.eclipse.kura.net.firewall.FirewallAutoNatConfig;
import org.eclipse.kura.net.modem.ModemConfig;
import org.eclipse.kura.net.modem.ModemConnectionStatus;
import org.eclipse.kura.net.modem.ModemConnectionType;
import org.eclipse.kura.net.modem.ModemInterface;
import org.eclipse.kura.net.modem.ModemInterfaceAddress;
import org.eclipse.kura.net.modem.ModemPowerMode;
import org.eclipse.kura.net.modem.ModemTechnologyType;
import org.eclipse.kura.net.wifi.WifiBgscan;
import org.eclipse.kura.net.wifi.WifiCiphers;
import org.eclipse.kura.net.wifi.WifiConfig;
import org.eclipse.kura.net.wifi.WifiInterface;
import org.eclipse.kura.net.wifi.WifiInterfaceAddress;
import org.eclipse.kura.net.wifi.WifiMode;
import org.eclipse.kura.net.wifi.WifiRadioMode;
import org.eclipse.kura.net.wifi.WifiSecurity;
import org.eclipse.kura.usb.UsbDevice;
import org.eclipse.kura.usb.UsbNetDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(NetworkConfiguration.class);
    private final Map<String, NetInterfaceConfig<? extends NetInterfaceAddressConfig>> netInterfaceConfigs;
    private Map<String, Object> properties;
    private boolean recomputeProperties;
    private List<String> modifiedInterfaceNames;

    public NetworkConfiguration() {
        logger.debug("Created empty NetworkConfiguration");
        this.netInterfaceConfigs = new HashMap<String, NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
    }

    /*
     * Unable to fully structure code
     */
    public NetworkConfiguration(Map<String, Object> properties) throws UnknownHostException, KuraException {
        block8: {
            super();
            NetworkConfiguration.logger.debug("Creating NetworkConfiguration from properties");
            this.netInterfaceConfigs = new HashMap<String, NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
            availableInterfaces = null;
            try {
                availableInterfaces = (String[])properties.get("net.interfaces");
                break block8;
            }
            catch (ClassCastException v0) {
                interfaces = (String)properties.get("net.interfaces");
                st = new StringTokenizer(interfaces, ",");
                interfacesArray = new ArrayList<String>();
                ** while (st.hasMoreTokens())
            }
lbl-1000:
            // 1 sources

            {
                interfacesArray.add(st.nextToken());
                continue;
            }
lbl16:
            // 1 sources

            availableInterfaces = interfacesArray.toArray(new String[interfacesArray.size()]);
        }
        if (availableInterfaces != null) {
            NetworkConfiguration.logger.debug("There are {} interfaces to add to the new configuration", (Object)availableInterfaces.length);
            var6_9 = availableInterfaces;
            var5_7 = availableInterfaces.length;
            st = 0;
            while (st < var5_7) {
                currentNetInterface = var6_9[st];
                keyBuffer = new StringBuilder();
                keyBuffer.append("net.interface.").append(currentNetInterface).append(".type");
                type = NetInterfaceType.UNKNOWN;
                if (properties.get(keyBuffer.toString()) != null) {
                    type = NetInterfaceType.valueOf((String)((String)properties.get(keyBuffer.toString())));
                }
                NetworkConfiguration.logger.trace("Adding interface: {} of type {}", (Object)currentNetInterface, (Object)type);
                this.addInterfaceConfiguration(currentNetInterface, type, properties);
                ++st;
            }
        }
        this.modifiedInterfaceNames = new ArrayList<String>();
        modifiedInterfaces = (String)properties.get("modified.interface.names");
        if (modifiedInterfaces != null) {
            var7_11 = modifiedInterfaces.split(",");
            var6_10 = var7_11.length;
            var5_8 = 0;
            while (var5_8 < var6_10) {
                interfaceName = var7_11[var5_8];
                this.modifiedInterfaceNames.add(interfaceName);
                ++var5_8;
            }
        }
        this.recomputeProperties = true;
    }

    public void setModifiedInterfaceNames(List<String> modifiedInterfaceNames) {
        if (modifiedInterfaceNames != null && !modifiedInterfaceNames.isEmpty()) {
            this.modifiedInterfaceNames = modifiedInterfaceNames;
            this.recomputeProperties = true;
        }
    }

    public List<String> getModifiedInterfaceNames() {
        return this.modifiedInterfaceNames;
    }

    public void accept(NetworkConfigurationVisitor visitor) throws KuraException {
        visitor.visit(this);
    }

    public void addNetInterfaceConfig(NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig) {
        this.netInterfaceConfigs.put(netInterfaceConfig.getName(), netInterfaceConfig);
        this.recomputeProperties = true;
    }

    public void addNetConfig(String interfaceName, NetInterfaceType netInterfaceType, NetConfig netConfig) throws KuraException {
        AbstractNetInterface netInterfaceConfig = this.netInterfaceConfigs.get(interfaceName);
        if (netInterfaceConfig == null) {
            switch (netInterfaceType) {
                case LOOPBACK: {
                    netInterfaceConfig = new LoopbackInterfaceConfigImpl(interfaceName);
                    break;
                }
                case ETHERNET: {
                    netInterfaceConfig = new EthernetInterfaceConfigImpl(interfaceName);
                    break;
                }
                case WIFI: {
                    netInterfaceConfig = new WifiInterfaceConfigImpl(interfaceName);
                    break;
                }
                case MODEM: {
                    netInterfaceConfig = new ModemInterfaceConfigImpl(interfaceName);
                    break;
                }
                default: {
                    throw new KuraException(KuraErrorCode.INVALID_PARAMETER);
                }
            }
        }
        List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
        logger.trace("Adding a netConfig: {}", (Object)netConfig);
        for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
            List netConfigs = netInterfaceAddressConfig.getConfigs();
            netConfigs.add(netConfig);
        }
        this.recomputeProperties = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = this.netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.netInterfaceConfigs.get(it.next());
            sb.append("\nname: " + netInterfaceConfig.getName());
            sb.append(" :: Loopback? " + netInterfaceConfig.isLoopback());
            sb.append(" :: Point to Point? " + netInterfaceConfig.isPointToPoint());
            sb.append(" :: Up? " + netInterfaceConfig.isUp());
            sb.append(" :: Virtual? " + netInterfaceConfig.isVirtual());
            sb.append(" :: Driver: " + netInterfaceConfig.getDriver());
            sb.append(" :: Driver Version: " + netInterfaceConfig.getDriverVersion());
            sb.append(" :: Firmware Version: " + netInterfaceConfig.getFirmwareVersion());
            sb.append(" :: MTU: " + netInterfaceConfig.getMTU());
            if (netInterfaceConfig.getHardwareAddress() != null) {
                sb.append(" :: Hardware Address: " + NetworkUtil.macToString(netInterfaceConfig.getHardwareAddress()));
            }
            sb.append(" :: State: " + netInterfaceConfig.getState());
            sb.append(" :: Type: " + netInterfaceConfig.getType());
            sb.append(" :: Usb Device: " + netInterfaceConfig.getUsbDevice());
            List netInterfaceAddresses = netInterfaceConfig.getNetInterfaceAddresses();
            for (NetInterfaceAddress netInterfaceAddress : netInterfaceAddresses) {
                if (netInterfaceAddress.getAddress() != null) {
                    sb.append(" :: Address: " + netInterfaceAddress.getAddress().getHostAddress());
                }
                sb.append(" :: Prefix: " + netInterfaceAddress.getNetworkPrefixLength());
                if (netInterfaceAddress.getNetmask() != null) {
                    sb.append(" :: Netmask: " + netInterfaceAddress.getNetmask().getHostAddress());
                }
                if (netInterfaceAddress.getBroadcast() == null) continue;
                sb.append(" :: Broadcast: " + netInterfaceAddress.getBroadcast().getHostAddress());
            }
            List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
            if (netInterfaceAddressConfigs == null) continue;
            for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
                List netConfigs = netInterfaceAddressConfig.getConfigs();
                if (netConfigs == null) continue;
                for (NetConfig netConfig : netConfigs) {
                    List dnsServers;
                    if (netConfig instanceof NetConfigIP4) {
                        sb.append("\n\tIPv4 ");
                        if (((NetConfigIP4)netConfig).isDhcp()) {
                            sb.append(" :: is DHCP client");
                            Map dhcp4Map = ((NetConfigIP4)netConfig).getProperties();
                            for (Map.Entry entry : dhcp4Map.entrySet()) {
                                String dhcpKey = (String)entry.getKey();
                                sb.append(" :: " + dhcpKey + ": " + entry.getValue());
                            }
                            continue;
                        }
                        if (((NetConfigIP4)netConfig).getAddress() == null) {
                            sb.append(" :: is not configured for STATIC or DHCP");
                            continue;
                        }
                        sb.append(" :: is STATIC client");
                        if (((NetConfigIP4)netConfig).getAddress() != null) {
                            sb.append(" :: Address: " + ((IP4Address)((NetConfigIP4)netConfig).getAddress()).getHostAddress());
                        }
                        sb.append(" :: Prefix: " + ((NetConfigIP4)netConfig).getNetworkPrefixLength());
                        if (((NetConfigIP4)netConfig).getGateway() != null) {
                            sb.append(" :: Gateway: " + ((IP4Address)((NetConfigIP4)netConfig).getGateway()).getHostAddress());
                        }
                        dnsServers = ((NetConfigIP4)netConfig).getDnsServers();
                        List winsServers = ((NetConfigIP4)netConfig).getWinsServers();
                        List domains = ((NetConfigIP4)netConfig).getDomains();
                        if (dnsServers != null) {
                            for (IP4Address dnsServer : dnsServers) {
                                sb.append(" :: DNS : " + dnsServer.getHostAddress());
                            }
                        }
                        if (winsServers != null) {
                            for (IP4Address winsServer : winsServers) {
                                sb.append(" :: WINS Server : " + winsServer.getHostAddress());
                            }
                        }
                        if (domains == null) continue;
                        for (String domain : domains) {
                            sb.append(" :: Domains : " + domain);
                        }
                        continue;
                    }
                    if (netConfig instanceof NetConfigIP6) {
                        sb.append("\n\tIPv6 ");
                        if (((NetConfigIP6)netConfig).isDhcp()) {
                            sb.append(" :: is DHCP client");
                            Map dhcp6Map = ((NetConfigIP6)netConfig).getProperties();
                            for (String dhcpKey : dhcp6Map.keySet()) {
                                sb.append(" :: " + dhcpKey + ": " + dhcp6Map.get(dhcpKey));
                            }
                            continue;
                        }
                        sb.append(" :: is STATIC client");
                        if (((NetConfigIP6)netConfig).getAddress() != null) {
                            sb.append(" :: Address: " + ((IP6Address)((NetConfigIP6)netConfig).getAddress()).getHostAddress());
                        }
                        dnsServers = ((NetConfigIP6)netConfig).getDnsServers();
                        List domains = ((NetConfigIP6)netConfig).getDomains();
                        for (IP6Address dnsServer : dnsServers) {
                            sb.append(" :: DNS : " + dnsServer.getHostAddress());
                        }
                        for (String domain : domains) {
                            sb.append(" :: Domains : " + domain);
                        }
                        continue;
                    }
                    if (netConfig instanceof WifiConfig) {
                        sb.append("\n\tWifiConfig ");
                        sb.append(" :: SSID: " + ((WifiConfig)netConfig).getSSID());
                        sb.append(" :: BgScan: " + ((WifiConfig)netConfig).getBgscan());
                        sb.append(" :: Broadcast: " + ((WifiConfig)netConfig).getBroadcast());
                        int[] channels = ((WifiConfig)netConfig).getChannels();
                        if (channels != null && channels.length > 0) {
                            sb.append(" :: Channels: ");
                            int i = 0;
                            while (i < channels.length) {
                                sb.append(channels[i]);
                                if (i + 1 < channels.length) {
                                    sb.append(",");
                                }
                                ++i;
                            }
                        }
                        sb.append(" :: Group Ciphers: " + ((WifiConfig)netConfig).getGroupCiphers());
                        sb.append(" :: Hardware Mode: " + ((WifiConfig)netConfig).getHardwareMode());
                        sb.append(" :: Mode: " + ((WifiConfig)netConfig).getMode());
                        sb.append(" :: Pairwise Ciphers: " + ((WifiConfig)netConfig).getPairwiseCiphers());
                        sb.append(" :: Passkey: " + ((WifiConfig)netConfig).getPasskey());
                        sb.append(" :: Security: " + ((WifiConfig)netConfig).getSecurity());
                        continue;
                    }
                    if (netConfig instanceof ModemConfig) {
                        sb.append("\n\tModemConfig ");
                        sb.append(" :: APN: " + ((ModemConfig)netConfig).getApn());
                        sb.append(" :: Data Compression: " + ((ModemConfig)netConfig).getDataCompression());
                        sb.append(" :: Dial String: " + ((ModemConfig)netConfig).getDialString());
                        sb.append(" :: Header Compression: " + ((ModemConfig)netConfig).getHeaderCompression());
                        sb.append(" :: Password: " + ((ModemConfig)netConfig).getPasswordAsPassword().toString());
                        sb.append(" :: PPP number: " + ((ModemConfig)netConfig).getPppNumber());
                        sb.append(" :: Profile ID: " + ((ModemConfig)netConfig).getProfileID());
                        sb.append(" :: Username: " + ((ModemConfig)netConfig).getUsername());
                        sb.append(" :: Auth Type: " + ((ModemConfig)netConfig).getAuthType());
                        sb.append(" :: IP Address: " + ((ModemConfig)netConfig).getIpAddress());
                        sb.append(" :: PDP Type: " + ((ModemConfig)netConfig).getPdpType());
                        continue;
                    }
                    if (netConfig instanceof DhcpServerConfig) {
                        sb.append("\n\tDhcpServerConfig ");
                        continue;
                    }
                    if (netConfig instanceof FirewallAutoNatConfig) {
                        sb.append("\n\tFirewallAutoNatConfig ");
                        continue;
                    }
                    if (netConfig != null && netConfig.getClass() != null) {
                        sb.append("\n\tUNKNOWN CONFIG TYPE???: " + netConfig.getClass().getName());
                        continue;
                    }
                    sb.append("\n\tNULL NETCONFIG PRESENT?!?");
                }
            }
        }
        return sb.toString();
    }

    public List<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> getModifiedNetInterfaceConfigs() {
        List<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> newNetInterfaceConfigs = null;
        if (this.modifiedInterfaceNames != null && !this.modifiedInterfaceNames.isEmpty()) {
            newNetInterfaceConfigs = new ArrayList<NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
            for (String interfaceName : this.modifiedInterfaceNames) {
                NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.netInterfaceConfigs.get(interfaceName);
                if (netInterfaceConfig == null) continue;
                newNetInterfaceConfigs.add(this.netInterfaceConfigs.get(interfaceName));
            }
        } else {
            newNetInterfaceConfigs = this.getNetInterfaceConfigs();
        }
        return newNetInterfaceConfigs;
    }

    public List<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> getNetInterfaceConfigs() {
        ArrayList<NetInterfaceConfig<? extends NetInterfaceAddressConfig>> newNetInterfaceConfigs = new ArrayList<NetInterfaceConfig<? extends NetInterfaceAddressConfig>>();
        Iterator<String> it = this.netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            newNetInterfaceConfigs.add(this.netInterfaceConfigs.get(it.next()));
        }
        return newNetInterfaceConfigs;
    }

    public NetInterfaceConfig<? extends NetInterfaceAddressConfig> getNetInterfaceConfig(String interfaceName) {
        return this.netInterfaceConfigs.get(interfaceName);
    }

    public Map<String, Object> getConfigurationProperties() {
        if (this.recomputeProperties) {
            this.recomputeNetworkProperties();
            this.recomputeProperties = false;
        }
        return this.properties;
    }

    public boolean isValid() throws KuraException {
        Iterator<String> it = this.netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.netInterfaceConfigs.get(it.next());
            if (netInterfaceConfig.getMTU() < 0) {
                logger.error("MTU must be greater than 0");
                return false;
            }
            NetInterfaceType type = netInterfaceConfig.getType();
            if (type != NetInterfaceType.ETHERNET && type != NetInterfaceType.WIFI && type != NetInterfaceType.MODEM && type != NetInterfaceType.LOOPBACK) {
                logger.error("Type must be ETHERNET, WIFI, MODEM, or LOOPBACK - type is {}", (Object)type);
                return false;
            }
            List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
            for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
                List netConfigs = netInterfaceAddressConfig.getConfigs();
                if (netConfigs == null) continue;
                for (NetConfig netConfig : netConfigs) {
                    if (netConfig.isValid()) continue;
                    logger.error("Invalid config {}", (Object)netConfig.toString());
                    return false;
                }
            }
        }
        return true;
    }

    private void recomputeNetworkProperties() {
        HashMap<String, Object> newNetworkProperties = new HashMap<String, Object>();
        String netIfPrefix = null;
        String netIfReadOnlyPrefix = null;
        String netIfConfigPrefix = null;
        StringBuilder sbPrefix = null;
        StringBuilder sbInterfaces = new StringBuilder();
        if (this.modifiedInterfaceNames != null && !this.modifiedInterfaceNames.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            for (String interfaceName : this.modifiedInterfaceNames) {
                sb.append(prefix);
                prefix = ",";
                sb.append(interfaceName);
            }
            String result = sb.toString();
            logger.debug("Set modified interface names: {}", (Object)result);
            newNetworkProperties.put("modified.interface.names", result);
        }
        Iterator<String> it = this.netInterfaceConfigs.keySet().iterator();
        while (it.hasNext()) {
            Set<WifiInterface.Capability> capabilities;
            NetInterfaceConfig<? extends NetInterfaceAddressConfig> netInterfaceConfig = this.netInterfaceConfigs.get(it.next());
            if (sbInterfaces.length() != 0) {
                sbInterfaces.append(",");
            }
            sbInterfaces.append(netInterfaceConfig.getName());
            sbPrefix = new StringBuilder("net.interface.").append(netInterfaceConfig.getName()).append(".");
            netIfReadOnlyPrefix = sbPrefix.toString();
            netIfPrefix = sbPrefix.append("config.").toString();
            netIfConfigPrefix = sbPrefix.toString();
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "type", netInterfaceConfig.getType().toString());
            newNetworkProperties.put(String.valueOf(netIfPrefix) + "name", netInterfaceConfig.getName());
            if (netInterfaceConfig.getState() != null) {
                newNetworkProperties.put(String.valueOf(netIfPrefix) + "state", netInterfaceConfig.getState().toString());
            }
            newNetworkProperties.put(String.valueOf(netIfPrefix) + "autoconnect", netInterfaceConfig.isAutoConnect());
            newNetworkProperties.put(String.valueOf(netIfPrefix) + "mtu", netInterfaceConfig.getMTU());
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "driver", netInterfaceConfig.getDriver());
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "driver.version", netInterfaceConfig.getDriverVersion());
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "firmware.version", netInterfaceConfig.getFirmwareVersion());
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "mac", NetUtil.hardwareAddressToString((byte[])netInterfaceConfig.getHardwareAddress()));
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "loopback", netInterfaceConfig.isLoopback());
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "ptp", netInterfaceConfig.isPointToPoint());
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "up", netInterfaceConfig.isUp());
            newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "virtual", netInterfaceConfig.isVirtual());
            if (netInterfaceConfig.getUsbDevice() != null) {
                UsbDevice usbDev = netInterfaceConfig.getUsbDevice();
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.id", usbDev.getVendorId());
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.name", usbDev.getManufacturerName());
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.product.id", usbDev.getProductId());
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.product.name", usbDev.getProductName());
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.busNumber", usbDev.getUsbBusNumber());
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "usb.devicePath", usbDev.getUsbDevicePath());
            }
            if (netInterfaceConfig instanceof EthernetInterfaceConfigImpl) {
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "eth.link.up", ((EthernetInterfaceConfigImpl)netInterfaceConfig).isLinkUp());
            } else if (netInterfaceConfig instanceof WifiInterfaceConfigImpl && (capabilities = ((WifiInterfaceConfigImpl)netInterfaceConfig).getCapabilities()) != null && !capabilities.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (WifiInterface.Capability capability : capabilities) {
                    sb.append(capability.toString());
                    sb.append(",");
                }
                String capabilitiesString = sb.toString();
                capabilitiesString = capabilitiesString.substring(0, capabilitiesString.length() - 1);
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "wifi.capabilities", capabilitiesString);
            }
            if (netInterfaceConfig.getType() == NetInterfaceType.WIFI) {
                StringBuilder sbCapabilities = new StringBuilder();
                Set capabilities2 = ((WifiInterface)netInterfaceConfig).getCapabilities();
                if (capabilities2 != null) {
                    Iterator it2 = capabilities2.iterator();
                    while (it2.hasNext()) {
                        sbCapabilities.append(((WifiInterface.Capability)it2.next()).name()).append(" ");
                    }
                    newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "wifi.capabilities", sbCapabilities.toString());
                }
            }
            if (netInterfaceConfig.getType() == NetInterfaceType.MODEM) {
                String delim;
                StringBuffer revisionIdBuf = new StringBuffer();
                String[] revisionId = ((ModemInterface)netInterfaceConfig).getRevisionId();
                if (revisionId != null) {
                    delim = null;
                    String[] stringArray = revisionId;
                    int n = revisionId.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String rev = stringArray[n2];
                        if (delim != null) {
                            revisionIdBuf.append(delim);
                        }
                        revisionIdBuf.append(rev);
                        delim = ",";
                        ++n2;
                    }
                }
                StringBuilder techTypesBuf = new StringBuilder();
                List techTypes = ((ModemInterface)netInterfaceConfig).getTechnologyTypes();
                if (techTypes != null) {
                    delim = null;
                    for (ModemTechnologyType techType : techTypes) {
                        if (delim != null) {
                            techTypesBuf.append(delim);
                        }
                        techTypesBuf.append(techType.toString());
                        delim = ",";
                    }
                }
                Object powerMode = ModemPowerMode.UNKNOWN;
                if (((ModemInterface)netInterfaceConfig).getPowerMode() != null) {
                    powerMode = ((ModemInterface)netInterfaceConfig).getPowerMode();
                }
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "manufacturer", ((ModemInterface)netInterfaceConfig).getManufacturer());
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "model", ((ModemInterface)netInterfaceConfig).getModel());
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "revisionId", revisionIdBuf.toString());
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "serialNum", ((ModemInterface)netInterfaceConfig).getSerialNumber());
                newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "technologyTypes", techTypesBuf.toString());
                newNetworkProperties.put(String.valueOf(netIfConfigPrefix) + "identifier", ((ModemInterface)netInterfaceConfig).getModemIdentifier());
                newNetworkProperties.put(String.valueOf(netIfConfigPrefix) + "powerMode", powerMode.toString());
                newNetworkProperties.put(String.valueOf(netIfConfigPrefix) + "pppNum", ((ModemInterface)netInterfaceConfig).getPppNum());
                newNetworkProperties.put(String.valueOf(netIfConfigPrefix) + "poweredOn", ((ModemInterface)netInterfaceConfig).isPoweredOn());
            }
            for (NetInterfaceAddress nia : netInterfaceConfig.getNetInterfaceAddresses()) {
                String typePrefix = "ip4.";
                if (nia == null) continue;
                if (nia.getAddress() != null) {
                    newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "address", nia.getAddress().getHostAddress());
                }
                if (nia.getBroadcast() != null) {
                    newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "broadcast", nia.getBroadcast().getHostAddress());
                }
                if (nia.getGateway() != null) {
                    newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "gateway", nia.getGateway().getHostAddress());
                }
                if (nia.getNetmask() != null) {
                    newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "netmask", nia.getNetmask().getHostAddress());
                }
                if (nia.getNetmask() != null) {
                    newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "prefix", nia.getNetworkPrefixLength());
                }
                if (nia.getDnsServers() != null) {
                    StringBuilder dnsServers = new StringBuilder();
                    for (IPAddress dnsServer : nia.getDnsServers()) {
                        if (dnsServers.length() != 0) {
                            dnsServers.append(",");
                        }
                        dnsServers.append(dnsServer);
                    }
                    newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + typePrefix + "dnsServers", dnsServers.toString());
                }
                if (nia instanceof WifiInterfaceAddress) {
                    long bitrate = ((WifiInterfaceAddress)nia).getBitrate();
                    newNetworkProperties.put(String.valueOf(netIfReadOnlyPrefix) + "wifi.bitrate", bitrate);
                    WifiMode wifiMode = ((WifiInterfaceAddress)nia).getMode() != null ? ((WifiInterfaceAddress)nia).getMode() : WifiMode.UNKNOWN;
                    newNetworkProperties.put(String.valueOf(netIfPrefix) + "wifi.mode", wifiMode.toString());
                }
                if (!(nia instanceof ModemInterfaceAddress)) continue;
                if (((ModemInterfaceAddress)nia).getConnectionType() != null) {
                    newNetworkProperties.put(String.valueOf(netIfConfigPrefix) + "connection.type", ((ModemInterfaceAddress)nia).getConnectionType().toString());
                }
                if (((ModemInterfaceAddress)nia).getConnectionStatus() == null) continue;
                newNetworkProperties.put(String.valueOf(netIfConfigPrefix) + "connection.status", ((ModemInterfaceAddress)nia).getConnectionStatus().toString());
            }
            List netInterfaceAddressConfigs = netInterfaceConfig.getNetInterfaceAddresses();
            logger.trace("netInterfaceAddressConfigs.size() for {}: {}", (Object)netInterfaceConfig.getName(), (Object)netInterfaceAddressConfigs.size());
            for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceAddressConfigs) {
                List netConfigs = netInterfaceAddressConfig.getConfigs();
                if (netConfigs == null) continue;
                logger.trace("netConfigs.size(): {}", (Object)netConfigs.size());
                for (NetConfig netConfig : netConfigs) {
                    if (netConfig instanceof WifiConfig) {
                        logger.trace("adding netconfig WifiConfigIP4 for {}", (Object)netInterfaceConfig.getName());
                        NetworkConfiguration.addWifiConfigIP4Properties((WifiConfig)netConfig, netIfConfigPrefix, newNetworkProperties);
                        continue;
                    }
                    if (netConfig instanceof ModemConfig) {
                        logger.trace("adding netconfig ModemConfig for {}", (Object)netInterfaceConfig.getName());
                        this.addModemConfigProperties((ModemConfig)netConfig, netIfConfigPrefix, newNetworkProperties);
                        continue;
                    }
                    if (netConfig instanceof NetConfigIP4) {
                        logger.trace("adding netconfig NetConfigIP4 for {}", (Object)netInterfaceConfig.getName());
                        NetworkConfiguration.addNetConfigIP4Properties((NetConfigIP4)netConfig, netIfConfigPrefix, newNetworkProperties);
                        continue;
                    }
                    if (netConfig instanceof NetConfigIP6) {
                        logger.trace("adding netconfig NetConfigIP6 for {}", (Object)netInterfaceConfig.getName());
                        NetworkConfiguration.addNetConfigIP6Properties((NetConfigIP6)netConfig, netIfConfigPrefix, newNetworkProperties);
                        continue;
                    }
                    if (netConfig instanceof DhcpServerConfig4) {
                        logger.trace("adding netconfig DhcpServerConfig4 for {}", (Object)netInterfaceConfig.getName());
                        this.addDhcpServerConfig4((DhcpServerConfig4)netConfig, netIfConfigPrefix, newNetworkProperties);
                        continue;
                    }
                    if (!(netConfig instanceof FirewallAutoNatConfig)) continue;
                    logger.trace("adding netconfig FirewallNatConfig for {}", (Object)netInterfaceConfig.getName());
                    NetworkConfiguration.addFirewallNatConfig(netIfConfigPrefix, newNetworkProperties);
                }
            }
        }
        newNetworkProperties.put("net.interfaces", sbInterfaces.toString());
        this.properties = newNetworkProperties;
    }

    private static void addWifiConfigIP4Properties(WifiConfig wifiConfig, String netIfConfigPrefix, Map<String, Object> properties) {
        WifiMode mode = wifiConfig.getMode();
        if (mode == null) {
            logger.trace("WifiMode is null - could not add wifiConfig: {}", (Object)wifiConfig);
            return;
        }
        StringBuilder prefix = new StringBuilder(netIfConfigPrefix).append("wifi.").append(mode.toString().toLowerCase());
        int[] channels = wifiConfig.getChannels();
        StringBuilder sbChannel = new StringBuilder();
        if (channels != null) {
            int i = 0;
            while (i < channels.length) {
                sbChannel.append(channels[i]);
                if (i < channels.length - 1) {
                    sbChannel.append(' ');
                }
                ++i;
            }
        }
        properties.put(prefix + ".ssid", wifiConfig.getSSID());
        properties.put(prefix + ".driver", wifiConfig.getDriver());
        properties.put(prefix + ".mode", wifiConfig.getMode().toString());
        if (wifiConfig.getSecurity() != null) {
            properties.put(prefix + ".securityType", wifiConfig.getSecurity().toString());
        } else {
            properties.put(prefix + ".securityType", WifiSecurity.NONE.toString());
        }
        properties.put(prefix + ".channel", sbChannel.toString());
        Password psswd = wifiConfig.getPasskey();
        if (psswd != null) {
            properties.put(prefix + ".passphrase", psswd);
        } else {
            properties.put(prefix + ".passphrase", new Password(""));
        }
        if (wifiConfig.getHardwareMode() != null) {
            properties.put(prefix + ".hardwareMode", wifiConfig.getHardwareMode());
        } else {
            properties.put(prefix + ".hardwareMode", "");
        }
        properties.put(prefix + ".broadcast", wifiConfig.getBroadcast());
        if (wifiConfig.getRadioMode() != null) {
            properties.put(prefix + ".radioMode", wifiConfig.getRadioMode().toString());
        }
        if (wifiConfig.getBgscan() != null) {
            properties.put(prefix + ".bgscan", wifiConfig.getBgscan().toString());
        } else {
            properties.put(prefix + ".bgscan", "");
        }
        if (wifiConfig.getPairwiseCiphers() != null) {
            properties.put(prefix + ".pairwiseCiphers", wifiConfig.getPairwiseCiphers().name());
        }
        if (wifiConfig.getGroupCiphers() != null) {
            properties.put(prefix + ".groupCiphers", wifiConfig.getGroupCiphers().name());
        }
        properties.put(prefix + ".pingAccessPoint", wifiConfig.pingAccessPoint());
        properties.put(prefix + ".ignoreSSID", wifiConfig.ignoreSSID());
    }

    private static WifiConfig getWifiConfig(String netIfConfigPrefix, WifiMode mode, Map<String, Object> properties) throws KuraException {
        Boolean broadcast;
        StringTokenizer st;
        int tokens;
        WifiConfig wifiConfig = new WifiConfig();
        StringBuilder prefix = new StringBuilder(netIfConfigPrefix).append("wifi.").append(mode.toString().toLowerCase());
        logger.trace("mode is {}", (Object)mode.toString());
        wifiConfig.setMode(mode);
        String key = prefix + ".ssid";
        String ssid = (String)properties.get(key);
        if (ssid == null) {
            ssid = "";
        }
        logger.trace("SSID is {}", (Object)ssid);
        wifiConfig.setSSID(ssid);
        key = prefix + ".driver";
        String driver = (String)properties.get(key);
        if (driver == null) {
            driver = "";
        }
        logger.trace("driver is {}", (Object)driver);
        wifiConfig.setDriver(driver);
        key = prefix + ".securityType";
        WifiSecurity wifiSecurity = WifiSecurity.NONE;
        String securityString = (String)properties.get(key);
        logger.trace("securityString is {}", (Object)securityString);
        if (securityString != null && !securityString.isEmpty()) {
            try {
                wifiSecurity = WifiSecurity.valueOf((String)securityString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, new Object[]{"Could not parse wifi security " + securityString});
            }
        }
        wifiConfig.setSecurity(wifiSecurity);
        key = prefix + ".channel";
        String channelsString = (String)properties.get(key);
        logger.trace("channelsString is {}", (Object)channelsString);
        if (channelsString != null && (channelsString = channelsString.trim()).length() > 0 && (tokens = (st = new StringTokenizer(channelsString, " ")).countTokens()) > 0) {
            int[] channels = new int[tokens];
            int i = 0;
            while (i < tokens) {
                String token = st.nextToken();
                try {
                    channels[i] = Integer.parseInt(token);
                }
                catch (Exception e) {
                    logger.error("Error parsing channels!", (Throwable)e);
                }
                ++i;
            }
            wifiConfig.setChannels(channels);
        }
        key = prefix + ".passphrase";
        Object psswdObj = properties.get(key);
        String passphrase = null;
        if (psswdObj instanceof Password) {
            Password psswd = (Password)psswdObj;
            passphrase = new String(psswd.getPassword());
        } else if (psswdObj instanceof String) {
            passphrase = (String)psswdObj;
        }
        logger.trace("passphrase is {}", (Object)passphrase);
        wifiConfig.setPasskey(passphrase);
        key = prefix + ".hardwareMode";
        String hwMode = (String)properties.get(key);
        if (hwMode == null) {
            hwMode = "";
        }
        logger.trace("hwMode is {}", (Object)hwMode);
        wifiConfig.setHardwareMode(hwMode);
        key = prefix + ".ignoreSSID";
        boolean ignoreSSID = false;
        if (properties.get(key) != null) {
            ignoreSSID = (Boolean)properties.get(key);
            logger.trace("Ignore SSID is {}", (Object)ignoreSSID);
        } else {
            logger.trace("Ignore SSID is null");
        }
        wifiConfig.setIgnoreSSID(ignoreSSID);
        key = prefix + ".pairwiseCiphers";
        String pairwiseCiphers = (String)properties.get(key);
        if (pairwiseCiphers != null) {
            wifiConfig.setPairwiseCiphers(WifiCiphers.valueOf((String)pairwiseCiphers));
        }
        if (mode == WifiMode.INFRA) {
            key = prefix + ".bgscan";
            String bgscan = (String)properties.get(key);
            if (bgscan == null) {
                bgscan = "";
            }
            logger.trace("bgscan is {}", (Object)bgscan);
            wifiConfig.setBgscan(new WifiBgscan(bgscan));
            key = prefix + ".groupCiphers";
            String groupCiphers = (String)properties.get(key);
            if (groupCiphers != null) {
                wifiConfig.setGroupCiphers(WifiCiphers.valueOf((String)groupCiphers));
            }
            key = prefix + ".pingAccessPoint";
            boolean pingAccessPoint = false;
            if (properties.get(key) != null) {
                pingAccessPoint = (Boolean)properties.get(key);
                logger.trace("Ping Access Point is {}", (Object)pingAccessPoint);
            } else {
                logger.trace("Ping Access Point is null");
            }
            wifiConfig.setPingAccessPoint(pingAccessPoint);
        }
        if ((broadcast = (Boolean)properties.get(key = prefix + ".broadcast")) != null) {
            wifiConfig.setBroadcast(broadcast.booleanValue());
        }
        logger.trace("hwMode is {}", (Object)hwMode);
        key = prefix + ".radioMode";
        String radioModeString = (String)properties.get(key);
        logger.trace("radioModeString is {}", (Object)radioModeString);
        if (radioModeString != null && !radioModeString.isEmpty()) {
            try {
                WifiRadioMode radioMode = WifiRadioMode.valueOf((String)radioModeString);
                wifiConfig.setRadioMode(radioMode);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, new Object[]{"Could not parse wifi radio mode " + radioModeString});
            }
        }
        if (!wifiConfig.isValid()) {
            return null;
        }
        logger.trace("Returning wifiConfig: {}", (Object)wifiConfig);
        return wifiConfig;
    }

    private void addModemConfigProperties(ModemConfig modemConfig, String prefix, Map<String, Object> properties) {
        properties.put(String.valueOf(prefix) + "apn", modemConfig.getApn());
        properties.put(String.valueOf(prefix) + "authType", modemConfig.getAuthType() != null ? modemConfig.getAuthType().toString() : "");
        properties.put(String.valueOf(prefix) + "dataCompression", modemConfig.getDataCompression());
        properties.put(String.valueOf(prefix) + "dialString", modemConfig.getDialString());
        properties.put(String.valueOf(prefix) + "headerCompression", modemConfig.getHeaderCompression());
        properties.put(String.valueOf(prefix) + "ipAddress", modemConfig.getIpAddress() != null ? modemConfig.getIpAddress().toString() : "");
        properties.put(String.valueOf(prefix) + "password", modemConfig.getPasswordAsPassword());
        properties.put(String.valueOf(prefix) + "pdpType", modemConfig.getPdpType() != null ? modemConfig.getPdpType().toString() : "");
        properties.put(String.valueOf(prefix) + "pppNum", modemConfig.getPppNumber());
        properties.put(String.valueOf(prefix) + "persist", modemConfig.isPersist());
        properties.put(String.valueOf(prefix) + "maxFail", modemConfig.getMaxFail());
        properties.put(String.valueOf(prefix) + "idle", modemConfig.getIdle());
        properties.put(String.valueOf(prefix) + "activeFilter", modemConfig.getActiveFilter());
        properties.put(String.valueOf(prefix) + "resetTimeout", modemConfig.getResetTimeout());
        properties.put(String.valueOf(prefix) + "lcpEchoInterval", modemConfig.getLcpEchoInterval());
        properties.put(String.valueOf(prefix) + "lcpEchoFailure", modemConfig.getLcpEchoFailure());
        properties.put(String.valueOf(prefix) + "profileId", modemConfig.getProfileID());
        properties.put(String.valueOf(prefix) + "username", modemConfig.getUsername());
        properties.put(String.valueOf(prefix) + "enabled", modemConfig.isEnabled());
        properties.put(String.valueOf(prefix) + "gpsEnabled", modemConfig.isGpsEnabled());
        properties.put(String.valueOf(prefix) + "diversityEnabled", modemConfig.isDiversityEnabled());
    }

    private static ModemConfig getModemConfig(String prefix, Map<String, Object> properties) throws KuraException {
        ModemConfig modemConfig = new ModemConfig();
        String apn = NetworkConfiguration.getApn(prefix, properties);
        modemConfig.setApn(apn);
        ModemConfig.AuthType authType = NetworkConfiguration.getAuthenticationType(prefix, properties);
        modemConfig.setAuthType(authType);
        try {
            int dataCompression = NetworkConfiguration.getDataCompression(prefix, properties);
            modemConfig.setDataCompression(dataCompression);
        }
        catch (KuraException kuraException) {}
        String dialString = NetworkConfiguration.getDialString(prefix, properties);
        modemConfig.setDialString(dialString);
        try {
            int headerCompression = NetworkConfiguration.getHeaderCompression(prefix, properties);
            modemConfig.setHeaderCompression(headerCompression);
        }
        catch (KuraException kuraException) {}
        IPAddress ipAddress = NetworkConfiguration.getIpAddress(prefix, properties);
        modemConfig.setIpAddress(ipAddress);
        Password password = NetworkConfiguration.getPassword(prefix, properties);
        modemConfig.setPassword(password);
        ModemConfig.PdpType pdpType = NetworkConfiguration.getPdpType(prefix, properties);
        modemConfig.setPdpType(pdpType);
        try {
            int profileId = NetworkConfiguration.getProfileId(prefix, properties);
            modemConfig.setProfileID(profileId);
        }
        catch (KuraException kuraException) {}
        try {
            int pppNum = NetworkConfiguration.getPppNumber(prefix, properties);
            modemConfig.setPppNumber(pppNum);
        }
        catch (KuraException kuraException) {}
        try {
            boolean persist = NetworkConfiguration.isPersist(prefix, properties);
            modemConfig.setPersist(persist);
        }
        catch (KuraException kuraException) {}
        try {
            int maxFail = NetworkConfiguration.getMaximumFailures(prefix, properties);
            modemConfig.setMaxFail(maxFail);
        }
        catch (KuraException kuraException) {}
        try {
            int resetTimeout = NetworkConfiguration.getResetTimeout(prefix, properties);
            modemConfig.setResetTimeout(resetTimeout);
        }
        catch (KuraException kuraException) {}
        try {
            int idle = NetworkConfiguration.getIdle(prefix, properties);
            modemConfig.setIdle(idle);
        }
        catch (KuraException kuraException) {}
        try {
            String activeFilter = NetworkConfiguration.getActiveFilter(prefix, properties);
            modemConfig.setActiveFilter(activeFilter);
        }
        catch (KuraException kuraException) {}
        try {
            int lcpEchoInterval = NetworkConfiguration.getLcpEchoInterval(prefix, properties);
            modemConfig.setLcpEchoInterval(lcpEchoInterval);
        }
        catch (KuraException kuraException) {}
        try {
            int lcpEchoFailure = NetworkConfiguration.getLcpEchoFailure(prefix, properties);
            modemConfig.setLcpEchoFailure(lcpEchoFailure);
        }
        catch (KuraException kuraException) {}
        String username = (String)properties.get(String.valueOf(prefix) + "username");
        logger.trace("Username is {}", (Object)username);
        modemConfig.setUsername(username);
        boolean enabled = NetworkConfiguration.isEnabled(prefix, properties);
        modemConfig.setEnabled(enabled);
        boolean gpsEnabled = NetworkConfiguration.isGpsEnabled(prefix, properties);
        modemConfig.setGpsEnabled(gpsEnabled);
        boolean diversityEnabled = NetworkConfiguration.isDiversityEnabled(prefix, properties);
        modemConfig.setDiversityEnabled(diversityEnabled);
        return modemConfig;
    }

    private static boolean isGpsEnabled(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "gpsEnabled";
        boolean gpsEnabled = false;
        if (properties.get(key) != null) {
            gpsEnabled = (Boolean)properties.get(key);
            logger.trace("GPS Enabled is {}", (Object)gpsEnabled);
        } else {
            logger.trace("GPS Enabled is null");
        }
        return gpsEnabled;
    }

    private static boolean isDiversityEnabled(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "diversityEnabled";
        boolean diversityEnabled = false;
        if (properties.get(key) != null) {
            diversityEnabled = (Boolean)properties.get(key);
            logger.trace("Diversity Enabled is {}", (Object)diversityEnabled);
        } else {
            logger.trace("Diversity Enabled is null");
        }
        return diversityEnabled;
    }

    private static boolean isEnabled(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "enabled";
        boolean enabled = false;
        if (properties.get(key) != null) {
            enabled = (Boolean)properties.get(key);
            logger.trace("Enabled is {}", (Object)enabled);
        } else {
            logger.trace("Enabled is null");
        }
        return enabled;
    }

    private static int getLcpEchoFailure(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "lcpEchoFailure";
        if (properties.get(key) == null) {
            logger.trace("LCP Echo Failure is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        int lcpEchoFailure = (Integer)properties.get(key);
        logger.trace("LCP Echo Failure is {}", (Object)lcpEchoFailure);
        return lcpEchoFailure;
    }

    private static int getLcpEchoInterval(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "lcpEchoInterval";
        if (properties.get(key) == null) {
            logger.trace("LCP Echo Interval is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        int lcpEchoInterval = (Integer)properties.get(key);
        logger.trace("LCP Echo Interval is {}", (Object)lcpEchoInterval);
        return lcpEchoInterval;
    }

    private static String getActiveFilter(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "activeFilter";
        if (properties.get(key) == null) {
            logger.trace("activeFilter is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        String activeFilter = (String)properties.get(key);
        logger.trace("activeFilter is {}", (Object)activeFilter);
        return activeFilter;
    }

    private static int getIdle(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "idle";
        if (properties.get(key) == null) {
            logger.trace("idle is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        int idle = (Integer)properties.get(key);
        logger.trace("idle is {}", (Object)idle);
        return idle;
    }

    private static int getResetTimeout(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "resetTimeout";
        if (properties.get(key) == null) {
            logger.trace("resetTimeout is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        int resetTimeout = (Integer)properties.get(key);
        logger.trace("resetTimeout is {}", (Object)resetTimeout);
        return resetTimeout;
    }

    private static int getMaximumFailures(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "maxFail";
        if (properties.get(key) == null) {
            logger.trace("maxfail is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        int maxFail = (Integer)properties.get(key);
        logger.trace("maxfail is {}", (Object)maxFail);
        return maxFail;
    }

    private static boolean isPersist(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "persist";
        if (properties.get(key) == null) {
            logger.trace("persist is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        boolean persist = (Boolean)properties.get(key);
        logger.trace("persist is {}", (Object)persist);
        return persist;
    }

    private static int getPppNumber(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "pppNum";
        if (properties.get(key) == null) {
            logger.trace("PPP number is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        int pppNum = (Integer)properties.get(key);
        logger.trace("PPP number is {}", (Object)pppNum);
        return pppNum;
    }

    private static int getProfileId(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "profileId";
        if (properties.get(key) == null) {
            logger.trace("Profile id is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID);
        }
        int profileId = (Integer)properties.get(key);
        logger.trace("Profile id is {}", (Object)profileId);
        return profileId;
    }

    private static ModemConfig.PdpType getPdpType(String prefix, Map<String, Object> properties) throws KuraException {
        String pdpTypeString = (String)properties.get(String.valueOf(prefix) + "pdpType");
        ModemConfig.PdpType pdpType = ModemConfig.PdpType.UNKNOWN;
        if (pdpTypeString != null && !pdpTypeString.isEmpty()) {
            pdpType = NetworkConfiguration.parsePdpType(pdpTypeString);
        }
        logger.trace("Pdp type is {}", (Object)pdpTypeString);
        return pdpType;
    }

    private static ModemConfig.PdpType parsePdpType(String pdpTypeString) throws KuraException {
        ModemConfig.PdpType pdpType = ModemConfig.PdpType.UNKNOWN;
        try {
            pdpType = ModemConfig.PdpType.valueOf((String)pdpTypeString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Could not parse pdp type " + pdpTypeString});
        }
        return pdpType;
    }

    private static Password getPassword(String prefix, Map<String, Object> properties) throws KuraException {
        Password password = null;
        String key = String.valueOf(prefix) + "password";
        Object psswdObj = properties.get(key);
        if (psswdObj instanceof Password) {
            password = (Password)psswdObj;
        } else if (psswdObj instanceof String) {
            password = new Password((String)psswdObj);
        } else {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, new Object[]{"Invalid password type.", key, psswdObj != null ? psswdObj.getClass() : null});
        }
        return password;
    }

    private static IPAddress getIpAddress(String prefix, Map<String, Object> properties) throws KuraException {
        String ipAddressString = (String)properties.get(String.valueOf(prefix) + "ipAddress");
        IPAddress ipAddress = null;
        logger.trace("IP address is {}", (Object)ipAddressString);
        if (ipAddressString != null && !ipAddressString.isEmpty()) {
            ipAddress = NetworkConfiguration.parseIpAddress(ipAddressString);
        } else {
            logger.trace("IP address is null");
        }
        return ipAddress;
    }

    private static IPAddress parseIpAddress(String ipAddressString) throws KuraException {
        try {
            return IPAddress.parseHostAddress((String)ipAddressString);
        }
        catch (UnknownHostException unknownHostException) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Could not parse ip address " + ipAddressString});
        }
    }

    private static int getHeaderCompression(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "headerCompression";
        if (properties.get(key) == null) {
            logger.trace("Header compression is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_UNDEFINED);
        }
        int headerCompression = (Integer)properties.get(key);
        logger.trace("Header compression is {}", (Object)headerCompression);
        return headerCompression;
    }

    private static String getDialString(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "dialString";
        String dialString = (String)properties.get(key);
        logger.trace("Dial string is {}", (Object)dialString);
        return dialString;
    }

    private static int getDataCompression(String prefix, Map<String, Object> properties) throws KuraException {
        String key = String.valueOf(prefix) + "dataCompression";
        if (properties.get(key) == null) {
            logger.trace("Data compression is null");
            throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_UNDEFINED);
        }
        int dataCompression = (Integer)properties.get(key);
        logger.trace("Data compression is {}", (Object)dataCompression);
        return dataCompression;
    }

    private static ModemConfig.AuthType getAuthenticationType(String prefix, Map<String, Object> properties) throws KuraException {
        ModemConfig.AuthType authType;
        String key = String.valueOf(prefix) + "authType";
        String authTypeString = (String)properties.get(key);
        logger.trace("Auth type is {}", (Object)authTypeString);
        if (authTypeString != null && !authTypeString.isEmpty()) {
            authType = NetworkConfiguration.parseAuthenticationType(authTypeString);
        } else {
            logger.trace("Auth type is null");
            authType = ModemConfig.AuthType.NONE;
        }
        return authType;
    }

    private static ModemConfig.AuthType parseAuthenticationType(String authTypeString) throws KuraException {
        ModemConfig.AuthType authType = ModemConfig.AuthType.NONE;
        try {
            authType = ModemConfig.AuthType.valueOf((String)authTypeString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Could not parse auth type " + authTypeString});
        }
        return authType;
    }

    private static String getApn(String prefix, Map<String, Object> properties) {
        String key = String.valueOf(prefix) + "apn";
        String apn = (String)properties.get(key);
        logger.trace("APN is {}", (Object)apn);
        return apn;
    }

    private static void addNetConfigIP4Properties(NetConfigIP4 nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "autoconnect", nc.isAutoConnect());
        properties.put(String.valueOf(netIfConfigPrefix) + "ip4.status", nc.getStatus().toString());
        StringBuilder sbDnsAddresses = new StringBuilder();
        if (nc.getDnsServers() != null) {
            for (IP4Address ip : nc.getDnsServers()) {
                if (sbDnsAddresses.length() != 0) {
                    sbDnsAddresses.append(",");
                }
                sbDnsAddresses.append(ip.getHostAddress());
            }
        }
        properties.put(String.valueOf(netIfConfigPrefix) + "ip4.dnsServers", sbDnsAddresses.toString());
        if (nc.isDhcp()) {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient4.enabled", true);
        } else {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient4.enabled", false);
            if (nc.getAddress() != null) {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.address", ((IP4Address)nc.getAddress()).getHostAddress());
            } else {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.address", "");
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "ip4.prefix", nc.getNetworkPrefixLength());
            if (nc.getGateway() != null) {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.gateway", ((IP4Address)nc.getGateway()).getHostAddress());
            } else {
                properties.put(String.valueOf(netIfConfigPrefix) + "ip4.gateway", "");
            }
            StringBuilder sbWinsAddresses = new StringBuilder();
            if (nc.getWinsServers() != null) {
                for (IP4Address ip : nc.getWinsServers()) {
                    if (sbWinsAddresses.length() != 0) {
                        sbWinsAddresses.append(",");
                    }
                    sbWinsAddresses.append(ip.getHostAddress());
                }
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "winsServers", sbWinsAddresses.toString());
            StringBuilder sbDomains = new StringBuilder();
            if (nc.getDomains() != null) {
                for (String domain : nc.getDomains()) {
                    if (sbDomains.length() != 0) {
                        sbDomains.append(",");
                    }
                    sbDomains.append(domain);
                }
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "domains", sbDomains.toString());
        }
    }

    private static void addNetConfigIP6Properties(NetConfigIP6 nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "ip6.status", nc.getStatus().toString());
        if (nc.isDhcp()) {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient6.enabled", true);
        } else {
            properties.put(String.valueOf(netIfConfigPrefix) + "dhcpClient6.enabled", false);
            if (nc.getAddress() != null) {
                properties.put(String.valueOf(netIfConfigPrefix) + "address", ((IP6Address)nc.getAddress()).getHostAddress());
            }
            StringBuilder sbDnsAddresses = new StringBuilder();
            for (IP6Address ip : nc.getDnsServers()) {
                if (sbDnsAddresses.length() != 0) {
                    sbDnsAddresses.append(",");
                }
                sbDnsAddresses.append(ip.getHostAddress());
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "ip6.dnsServers", sbDnsAddresses.toString());
            StringBuilder sbDomains = new StringBuilder();
            for (String domain : nc.getDomains()) {
                if (sbDomains.length() != 0) {
                    sbDomains.append(",");
                }
                sbDomains.append(domain);
            }
            properties.put(String.valueOf(netIfConfigPrefix) + "domains", sbDomains.toString());
        }
    }

    private void addDhcpServerConfig4(DhcpServerConfig4 nc, String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.enabled", nc.isEnabled());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.defaultLeaseTime", nc.getDefaultLeaseTime());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.maxLeaseTime", nc.getMaximumLeaseTime());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.prefix", nc.getPrefix());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.rangeStart", nc.getRangeStart().toString());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.rangeEnd", nc.getRangeEnd().toString());
        properties.put(String.valueOf(netIfConfigPrefix) + "dhcpServer4.passDns", nc.isPassDns());
    }

    private static void addFirewallNatConfig(String netIfConfigPrefix, Map<String, Object> properties) {
        properties.put(String.valueOf(netIfConfigPrefix) + "nat.enabled", true);
    }

    private void addInterfaceConfiguration(String interfaceName, NetInterfaceType type, Map<String, Object> props) throws UnknownHostException, KuraException {
        if (type == null) {
            logger.error("Null type for {}", (Object)interfaceName);
            return;
        }
        switch (type) {
            case LOOPBACK: {
                LoopbackInterfaceConfigImpl loopbackInterfaceConfig = new LoopbackInterfaceConfigImpl(interfaceName);
                ArrayList<NetInterfaceAddressConfigImpl> loopbackInterfaceAddressConfigs = new ArrayList<NetInterfaceAddressConfigImpl>();
                loopbackInterfaceAddressConfigs.add(new NetInterfaceAddressConfigImpl());
                loopbackInterfaceConfig.setNetInterfaceAddresses(loopbackInterfaceAddressConfigs);
                this.populateNetInterfaceConfiguration(loopbackInterfaceConfig, props);
                this.netInterfaceConfigs.put(interfaceName, loopbackInterfaceConfig);
                break;
            }
            case ETHERNET: {
                EthernetInterfaceConfigImpl ethernetInterfaceConfig = new EthernetInterfaceConfigImpl(interfaceName);
                ArrayList<NetInterfaceAddressConfigImpl> ethernetInterfaceAddressConfigs = new ArrayList<NetInterfaceAddressConfigImpl>();
                ethernetInterfaceAddressConfigs.add(new NetInterfaceAddressConfigImpl());
                ethernetInterfaceConfig.setNetInterfaceAddresses(ethernetInterfaceAddressConfigs);
                this.populateNetInterfaceConfiguration(ethernetInterfaceConfig, props);
                this.netInterfaceConfigs.put(interfaceName, ethernetInterfaceConfig);
                break;
            }
            case WIFI: {
                WifiInterfaceConfigImpl wifiInterfaceConfig = new WifiInterfaceConfigImpl(interfaceName);
                ArrayList<WifiInterfaceAddressConfigImpl> wifiInterfaceAddressConfigs = new ArrayList<WifiInterfaceAddressConfigImpl>();
                wifiInterfaceAddressConfigs.add(new WifiInterfaceAddressConfigImpl());
                wifiInterfaceConfig.setNetInterfaceAddresses(wifiInterfaceAddressConfigs);
                this.populateNetInterfaceConfiguration(wifiInterfaceConfig, props);
                this.netInterfaceConfigs.put(interfaceName, wifiInterfaceConfig);
                break;
            }
            case MODEM: {
                ModemInterfaceConfigImpl modemInterfaceConfig = new ModemInterfaceConfigImpl(interfaceName);
                ArrayList<ModemInterfaceAddressConfigImpl> modemInterfaceAddressConfigs = new ArrayList<ModemInterfaceAddressConfigImpl>();
                modemInterfaceAddressConfigs.add(new ModemInterfaceAddressConfigImpl());
                modemInterfaceConfig.setNetInterfaceAddresses(modemInterfaceAddressConfigs);
                this.populateNetInterfaceConfiguration(modemInterfaceConfig, props);
                this.netInterfaceConfigs.put(interfaceName, modemInterfaceConfig);
                break;
            }
            case UNKNOWN: {
                logger.trace("Found interface of unknown type in current configuration: {}", (Object)interfaceName);
                break;
            }
            default: {
                logger.error("Unsupported type {} for interface {}", (Object)type.toString(), (Object)interfaceName);
            }
        }
    }

    private void populateNetInterfaceConfiguration(AbstractNetInterface<? extends NetInterfaceAddressConfig> netInterfaceConfig, Map<String, Object> props) throws UnknownHostException, KuraException {
        int n;
        int n2;
        String[] stringArray;
        String upKey;
        String ptpKey;
        String loopbackKey;
        String macAddressKey;
        String firmwardVersionKey;
        String driverVersionKey;
        String driverKey;
        String mtuConfig;
        String interfaceName = netInterfaceConfig.getName();
        StringBuilder keyBuffer = new StringBuilder();
        keyBuffer.append("net.interface.").append(interfaceName).append(".type");
        NetInterfaceType interfaceType = NetInterfaceType.valueOf((String)((String)props.get(keyBuffer.toString())));
        logger.trace("Populating interface: {} of type {}", (Object)interfaceName, (Object)interfaceType);
        StringBuilder sbPrefix = new StringBuilder();
        sbPrefix.append("net.interface.").append(interfaceName).append(".");
        String netIfReadOnlyPrefix = sbPrefix.toString();
        String netIfPrefix = sbPrefix.append("config.").toString();
        String netIfConfigPrefix = sbPrefix.toString();
        String stateConfig = String.valueOf(netIfReadOnlyPrefix) + "state";
        if (props.containsKey(stateConfig)) {
            try {
                NetInterfaceState state = (NetInterfaceState)props.get(stateConfig);
                logger.trace("got state: {}", (Object)state);
                netInterfaceConfig.setState(state);
            }
            catch (Exception e) {
                logger.error("Could not process State configuration. Retaining current value.", (Throwable)e);
            }
        }
        boolean autoConnect = false;
        String autoConnectKey = String.valueOf(netIfPrefix) + "autoconnect";
        if (props.containsKey(autoConnectKey)) {
            autoConnect = (Boolean)props.get(autoConnectKey);
            logger.trace("got autoConnect: {}", (Object)autoConnect);
            netInterfaceConfig.setAutoConnect(autoConnect);
        }
        if (props.containsKey(mtuConfig = String.valueOf(netIfPrefix) + "mtu")) {
            int mtu = (Integer)props.get(mtuConfig);
            logger.trace("got MTU: {}", (Object)mtu);
            netInterfaceConfig.setMTU(mtu);
        }
        if (props.containsKey(driverKey = String.valueOf(netIfReadOnlyPrefix) + "driver")) {
            String driver = (String)props.get(driverKey);
            logger.trace("got Driver: {}", (Object)driver);
            netInterfaceConfig.setDriver(driver);
        }
        if (props.containsKey(driverVersionKey = String.valueOf(netIfReadOnlyPrefix) + "driver.version")) {
            String driverVersion = (String)props.get(driverVersionKey);
            logger.trace("got Driver Version: {}", (Object)driverVersion);
            netInterfaceConfig.setDriverVersion(driverVersion);
        }
        if (props.containsKey(firmwardVersionKey = String.valueOf(netIfReadOnlyPrefix) + "firmware.version")) {
            String firmwareVersion = (String)props.get(firmwardVersionKey);
            logger.trace("got Firmware Version: {}", (Object)firmwareVersion);
            netInterfaceConfig.setFirmwareVersion(firmwareVersion);
        }
        if (props.containsKey(macAddressKey = String.valueOf(netIfReadOnlyPrefix) + "mac")) {
            String macAddress = (String)props.get(macAddressKey);
            logger.trace("got Mac Address: {}", (Object)macAddress);
            netInterfaceConfig.setHardwareAddress(NetUtil.hardwareAddressToBytes((String)macAddress));
        }
        if (props.containsKey(loopbackKey = String.valueOf(netIfReadOnlyPrefix) + "loopback")) {
            Boolean isLoopback = (Boolean)props.get(loopbackKey);
            logger.trace("got Is Loopback: {}", (Object)isLoopback);
            netInterfaceConfig.setLoopback(isLoopback);
        }
        if (props.containsKey(ptpKey = String.valueOf(netIfReadOnlyPrefix) + "ptp")) {
            Boolean isPtp = (Boolean)props.get(ptpKey);
            logger.trace("got Is PtP: {}", (Object)isPtp);
            netInterfaceConfig.setPointToPoint(isPtp);
        }
        if (props.containsKey(upKey = String.valueOf(netIfReadOnlyPrefix) + "up")) {
            Boolean isUp = (Boolean)props.get(upKey);
            logger.trace("got Is Up: {}", (Object)isUp);
            netInterfaceConfig.setUp(isUp);
            if (isUp.booleanValue()) {
                netInterfaceConfig.setState(NetInterfaceState.ACTIVATED);
            } else {
                netInterfaceConfig.setState(NetInterfaceState.DISCONNECTED);
            }
        } else {
            logger.trace("Setting state to");
            netInterfaceConfig.setState(NetInterfaceState.DISCONNECTED);
        }
        String virtualKey = String.valueOf(netIfReadOnlyPrefix) + "virtual";
        if (props.containsKey(virtualKey)) {
            Boolean isVirtual = (Boolean)props.get(virtualKey);
            logger.trace("got Is Virtual: {}", (Object)isVirtual);
            netInterfaceConfig.setVirtual(isVirtual);
        }
        String vendorId = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.id");
        String vendorName = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.vendor.name");
        String productId = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.product.id");
        String productName = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.product.name");
        String usbBusNumber = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.busNumber");
        String usbDevicePath = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "usb.devicePath");
        if (vendorId != null && productId != null) {
            UsbNetDevice usbDevice = new UsbNetDevice(vendorId, productId, vendorName, productName, usbBusNumber, usbDevicePath, interfaceName);
            logger.trace("adding usbDevice: {}, port: {}", (Object)usbDevice, (Object)usbDevice.getUsbPort());
            netInterfaceConfig.setUsbDevice((UsbDevice)usbDevice);
        }
        if (netInterfaceConfig instanceof EthernetInterfaceConfigImpl) {
            String linkUpKey = String.valueOf(netIfReadOnlyPrefix) + "eth.link.up";
            if (props.containsKey(linkUpKey)) {
                Boolean linkUp = (Boolean)props.get(linkUpKey);
                logger.trace("got Is Link Up: {}", (Object)linkUp);
                ((EthernetInterfaceConfigImpl)netInterfaceConfig).setLinkUp(linkUp);
            }
        } else if (netInterfaceConfig instanceof WifiInterfaceConfigImpl) {
            String[] capabilities;
            String capabilitiesString;
            String capabilitiesKey = String.valueOf(netIfReadOnlyPrefix) + "wifi.capabilities";
            if (props.containsKey(capabilitiesKey) && (capabilitiesString = (String)props.get(capabilitiesKey)) != null && (capabilities = capabilitiesString.split(" ")) != null && capabilities.length > 0) {
                EnumSet<WifiInterface.Capability> capabilitiesEnum = EnumSet.noneOf(WifiInterface.Capability.class);
                stringArray = capabilities;
                n2 = capabilities.length;
                n = 0;
                while (n < n2) {
                    String string = stringArray[n];
                    if (string != null && !string.isEmpty()) {
                        capabilitiesEnum.add(WifiInterface.Capability.valueOf((String)string));
                    }
                    ++n;
                }
                ((WifiInterfaceConfigImpl)netInterfaceConfig).setCapabilities(capabilitiesEnum);
            }
        } else if (netInterfaceConfig instanceof ModemInterfaceConfigImpl) {
            String modemPowerModeString;
            ModemInterfaceConfigImpl modemInterfaceConfig = (ModemInterfaceConfigImpl)netInterfaceConfig;
            String key = String.valueOf(netIfReadOnlyPrefix) + "manufacturer";
            if (props.containsKey(key)) {
                modemInterfaceConfig.setManufacturer((String)props.get(key));
            }
            if (props.containsKey(key = String.valueOf(netIfReadOnlyPrefix) + "model")) {
                modemInterfaceConfig.setModel((String)props.get(key));
            }
            if (props.containsKey(key = String.valueOf(netIfReadOnlyPrefix) + "revisionId")) {
                String revisionIdString = (String)props.get(key);
                modemInterfaceConfig.setRevisionId(revisionIdString.split(","));
            }
            if (props.containsKey(key = String.valueOf(netIfReadOnlyPrefix) + "serialNum")) {
                modemInterfaceConfig.setSerialNumber((String)props.get(key));
            }
            if (props.containsKey(key = String.valueOf(netIfReadOnlyPrefix) + "technologyTypes")) {
                ArrayList<ModemTechnologyType> technologyTypes = new ArrayList<ModemTechnologyType>();
                String techTypesString = (String)props.get(String.valueOf(netIfReadOnlyPrefix) + "technologyTypes");
                if (techTypesString != null && !techTypesString.isEmpty()) {
                    stringArray = techTypesString.split(",");
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        String string = stringArray[n];
                        if (string != null && !string.isEmpty()) {
                            try {
                                ModemTechnologyType modemTechType = ModemTechnologyType.valueOf((String)string);
                                technologyTypes.add(modemTechType);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                logger.error("Could not parse type {}", (Object)string);
                            }
                        }
                        ++n;
                    }
                    modemInterfaceConfig.setTechnologyTypes(technologyTypes);
                }
            }
            if (props.containsKey(key = String.valueOf(netIfConfigPrefix) + "identifier")) {
                modemInterfaceConfig.setModemIdentifier((String)props.get(key));
            }
            if (props.containsKey(key = String.valueOf(netIfConfigPrefix) + "powerMode") && (modemPowerModeString = (String)props.get(String.valueOf(netIfConfigPrefix) + "powerMode")) != null) {
                ModemPowerMode powerMode = ModemPowerMode.valueOf((String)modemPowerModeString);
                modemInterfaceConfig.setPowerMode(powerMode);
            }
            try {
                int pppNumber = NetworkConfiguration.getPppNumber(netIfConfigPrefix, props);
                modemInterfaceConfig.setPppNum(pppNumber);
            }
            catch (KuraException kuraException) {}
            key = String.valueOf(netIfConfigPrefix) + "poweredOn";
            if (props.containsKey(key) && props.get(key) != null) {
                modemInterfaceConfig.setPoweredOn((Boolean)props.get(key));
            }
        }
        String configStatus4 = null;
        String configStatus4Key = "net.interface." + interfaceName + ".config.ip4.status";
        if (props.containsKey(configStatus4Key)) {
            configStatus4 = (String)props.get(configStatus4Key);
        }
        if (configStatus4 == null) {
            configStatus4 = NetInterfaceStatus.netIPv4StatusDisabled.name();
        }
        logger.trace("Status Ipv4? {}", (Object)configStatus4);
        String configStatus6 = null;
        String configStatus6Key = "net.interface." + interfaceName + ".config.ip6.status";
        if (props.containsKey(configStatus6Key)) {
            configStatus6 = (String)props.get(configStatus6Key);
        }
        if (configStatus6 == null) {
            configStatus6 = NetInterfaceStatus.netIPv6StatusDisabled.name();
        }
        for (NetInterfaceAddressConfig netInterfaceAddressConfig : netInterfaceConfig.getNetInterfaceAddresses()) {
            String configDhcpServerEnabled;
            String configNatEnabled;
            String configDomains;
            IP4Address winsIp4;
            String configWINSs;
            IP4Address dnsIp422;
            ArrayList<NetConfig> netConfigs = new ArrayList<NetConfig>();
            if (netInterfaceAddressConfig instanceof NetInterfaceAddressConfigImpl) {
                ((NetInterfaceAddressConfigImpl)netInterfaceAddressConfig).setNetConfigs(netConfigs);
            } else if (netInterfaceAddressConfig instanceof WifiInterfaceAddressConfigImpl) {
                ((WifiInterfaceAddressConfigImpl)netInterfaceAddressConfig).setNetConfigs(netConfigs);
            } else if (netInterfaceAddressConfig instanceof ModemInterfaceAddressConfigImpl) {
                ((ModemInterfaceAddressConfigImpl)netInterfaceAddressConfig).setNetConfigs(netConfigs);
            }
            if (netInterfaceAddressConfig instanceof NetInterfaceAddressImpl) {
                logger.trace("netInterfaceAddress is instanceof NetInterfaceAddressImpl");
                NetInterfaceAddressImpl netInterfaceAddressImpl = (NetInterfaceAddressImpl)netInterfaceAddressConfig;
                String addressType = ".ip4";
                String key = "net.interface." + interfaceName + addressType + ".address";
                if (props.containsKey(key)) {
                    IPAddress address = IPAddress.parseHostAddress((String)((String)props.get(key)));
                    logger.trace("got {}: {}", (Object)key, (Object)address);
                    netInterfaceAddressImpl.setAddress(address);
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".broadcast")) {
                    IPAddress broadcast = IPAddress.parseHostAddress((String)((String)props.get(key)));
                    logger.trace("got {}: {}", (Object)key, (Object)broadcast);
                    netInterfaceAddressImpl.setBroadcast(broadcast);
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".dnsServers")) {
                    ArrayList<IPAddress> dnsServers = new ArrayList<IPAddress>();
                    String dnsServersString = (String)props.get(key);
                    logger.trace("got {}: {}", (Object)key, (Object)dnsServersString);
                    String[] stringArray2 = dnsServersString.split(",");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String dnsServer = stringArray2[n4];
                        dnsServers.add(IPAddress.parseHostAddress((String)dnsServer));
                        ++n4;
                    }
                    netInterfaceAddressImpl.setDnsServers(dnsServers);
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".gateway")) {
                    if (props.get(key) != null && !((String)props.get(key)).trim().equals("")) {
                        IPAddress gateway = IPAddress.parseHostAddress((String)((String)props.get(key)));
                        logger.trace("got {}: {}", (Object)key, (Object)gateway);
                        netInterfaceAddressImpl.setGateway(gateway);
                    } else {
                        logger.trace("got {}: null", (Object)key);
                        netInterfaceAddressImpl.setGateway(null);
                    }
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".netmask")) {
                    IPAddress netmask = IPAddress.parseHostAddress((String)((String)props.get(key)));
                    logger.trace("got {}: {}", (Object)key, (Object)netmask);
                    netInterfaceAddressImpl.setBroadcast(netmask);
                }
                if (props.containsKey(key = "net.interface." + interfaceName + addressType + ".prefix")) {
                    Short prefix = (Short)props.get(key);
                    logger.trace("got {}: {}", (Object)key, (Object)prefix);
                    netInterfaceAddressImpl.setNetworkPrefixLength(prefix);
                }
            }
            if (netInterfaceAddressConfig instanceof WifiInterfaceAddressImpl) {
                logger.trace("netInterfaceAddress is instanceof WifiInterfaceAddressImpl");
                WifiInterfaceAddressImpl wifiInterfaceAddressImpl = (WifiInterfaceAddressImpl)netInterfaceAddressConfig;
                String configWifiMode = String.valueOf(netIfPrefix) + "wifi.mode";
                if (props.containsKey(configWifiMode)) {
                    WifiMode mode = WifiMode.INFRA;
                    if (props.get(configWifiMode) != null) {
                        mode = WifiMode.valueOf((String)((String)props.get(configWifiMode)));
                    }
                    logger.trace("Adding wifiMode: {}", (Object)mode);
                    wifiInterfaceAddressImpl.setMode(mode);
                }
            }
            if (netInterfaceAddressConfig instanceof ModemInterfaceAddressConfigImpl) {
                String configConnStatus;
                logger.trace("netInterfaceAddress is instanceof ModemInterfaceAddressConfigImpl");
                ModemInterfaceAddressConfigImpl modemInterfaceAddressImpl = (ModemInterfaceAddressConfigImpl)netInterfaceAddressConfig;
                String configConnType = String.valueOf(netIfPrefix) + "connection.type";
                if (props.containsKey(configConnType)) {
                    ModemConnectionType connType = ModemConnectionType.PPP;
                    String connTypeStr = (String)props.get(configConnType);
                    if (connTypeStr != null && !connTypeStr.isEmpty()) {
                        connType = ModemConnectionType.valueOf((String)connTypeStr);
                    }
                    logger.trace("Adding modem connection type: {}", (Object)connType);
                    modemInterfaceAddressImpl.setConnectionType(connType);
                }
                if (props.containsKey(configConnStatus = String.valueOf(netIfPrefix) + "connection.status")) {
                    ModemConnectionStatus connStatus = ModemConnectionStatus.UNKNOWN;
                    String connStatusStr = (String)props.get(configConnStatus);
                    if (connStatusStr != null && !connStatusStr.isEmpty()) {
                        connStatus = ModemConnectionStatus.valueOf((String)connStatusStr);
                    }
                    logger.trace("Adding modem connection status: {}", (Object)connStatus);
                    modemInterfaceAddressImpl.setConnectionStatus(connStatus);
                }
            }
            String configDhcp4 = "net.interface." + interfaceName + ".config.dhcpClient4.enabled";
            boolean dhcpEnabled = false;
            if (props.containsKey(configDhcp4)) {
                dhcpEnabled = (Boolean)props.get(configDhcp4);
                logger.trace("DHCP 4 enabled? {}", (Object)dhcpEnabled);
            }
            NetConfigIP4 netConfigIP4 = new NetConfigIP4(NetInterfaceStatus.valueOf((String)configStatus4), autoConnect);
            netConfigs.add((NetConfig)netConfigIP4);
            if (dhcpEnabled) {
                netConfigIP4.setDhcp(true);
            } else {
                String configIp4 = "net.interface." + interfaceName + ".config.ip4.address";
                if (props.containsKey(configIp4)) {
                    String configIp4Gateway;
                    logger.trace("got {}: {}", (Object)configIp4, props.get(configIp4));
                    String addressIp4 = (String)props.get(configIp4);
                    logger.trace("IPv4 address: {}", (Object)addressIp4);
                    if (addressIp4 != null && !addressIp4.isEmpty()) {
                        IP4Address ip4Address = (IP4Address)IPAddress.parseHostAddress((String)addressIp4);
                        netConfigIP4.setAddress((IPAddress)ip4Address);
                    }
                    String configIp4Prefix = "net.interface." + interfaceName + ".config.ip4.prefix";
                    short networkPrefixLength = -1;
                    if (props.containsKey(configIp4Prefix)) {
                        if (props.get(configIp4Prefix) instanceof Short) {
                            networkPrefixLength = (Short)props.get(configIp4Prefix);
                        } else if (props.get(configIp4Prefix) instanceof String) {
                            networkPrefixLength = Short.parseShort((String)props.get(configIp4Prefix));
                        }
                        try {
                            netConfigIP4.setNetworkPrefixLength(networkPrefixLength);
                        }
                        catch (KuraException e) {
                            logger.error("Exception while setting Network Prefix length!", (Throwable)e);
                        }
                    }
                    if (props.containsKey(configIp4Gateway = "net.interface." + interfaceName + ".config.ip4.gateway")) {
                        String gatewayIp4 = (String)props.get(configIp4Gateway);
                        logger.trace("IPv4 gateway: {}", (Object)gatewayIp4);
                        if (gatewayIp4 != null && !gatewayIp4.isEmpty()) {
                            IP4Address ip4Gateway = (IP4Address)IPAddress.parseHostAddress((String)gatewayIp4);
                            netConfigIP4.setGateway((IPAddress)ip4Gateway);
                        }
                    }
                }
            }
            String configDNSs = "net.interface." + interfaceName + ".config.ip4.dnsServers";
            if (props.containsKey(configDNSs)) {
                String[] dnss;
                ArrayList<IP4Address> dnsIPs = new ArrayList<IP4Address>();
                String dnsAll = (String)props.get(configDNSs);
                String[] stringArray3 = dnss = dnsAll.split(",");
                int ip4Gateway = dnss.length;
                int gatewayIp4 = 0;
                while (gatewayIp4 < ip4Gateway) {
                    String dns = stringArray3[gatewayIp4];
                    if (dns != null && dns.length() > 0) {
                        logger.trace("IPv4 DNS: {}", (Object)dns);
                        dnsIp422 = (IP4Address)IPAddress.parseHostAddress((String)dns);
                        dnsIPs.add(dnsIp422);
                    }
                    ++gatewayIp4;
                }
                netConfigIP4.setDnsServers(dnsIPs);
            }
            if (props.containsKey(configWINSs = "net.interface." + interfaceName + ".config.ip4.winsServers")) {
                IP4Address winss;
                ArrayList<IP4Address> winsIPs = new ArrayList<IP4Address>();
                String winsAll = (String)props.get(configWINSs);
                dnsIp422 = winss = winsAll.split(",");
                int n5 = ((String[])dnsIp422).length;
                int ip4Gateway = 0;
                while (ip4Gateway < n5) {
                    IP4Address wins = dnsIp422[ip4Gateway];
                    logger.trace("WINS: {}", (Object)wins);
                    winsIp4 = (IP4Address)IPAddress.parseHostAddress((String)wins);
                    winsIPs.add(winsIp4);
                    ++ip4Gateway;
                }
                netConfigIP4.setWinsServers(winsIPs);
            }
            if (props.containsKey(configDomains = "net.interface." + interfaceName + ".config.ip4.domains")) {
                IP4Address domains;
                ArrayList<IP4Address> domainNames = new ArrayList<IP4Address>();
                String domainsAll = (String)props.get(configDomains);
                winsIp4 = domains = domainsAll.split(",");
                int dnsIp422 = ((String[])winsIp4).length;
                int n6 = 0;
                while (n6 < dnsIp422) {
                    IP4Address domain = winsIp4[n6];
                    logger.trace("IPv4 Domain: {}", (Object)domain);
                    domainNames.add(domain);
                    ++n6;
                }
                netConfigIP4.setDomains(domainNames);
            }
            if (props.containsKey(configNatEnabled = "net.interface." + interfaceName + ".config.nat.enabled")) {
                boolean natEnabled = (Boolean)props.get(configNatEnabled);
                logger.trace("NAT enabled? {}", (Object)natEnabled);
                if (natEnabled) {
                    FirewallAutoNatConfig natConfig = new FirewallAutoNatConfig(interfaceName, "unknown", true);
                    netConfigs.add((NetConfig)natConfig);
                }
            }
            if (props.containsKey(configDhcpServerEnabled = "net.interface." + interfaceName + ".config.dhcpServer4.enabled")) {
                String configDhcpServerPassDns;
                String configDhcpServerMaxLeaseTime;
                String configDhcpServerDefaultLeaseTime;
                String configDhcpServerRangeEnd;
                String configDhcpServerRangeStart;
                boolean dhcpServerEnabled = (Boolean)props.get(configDhcpServerEnabled);
                logger.trace("DHCP Server 4 enabled? {}", (Object)dhcpServerEnabled);
                IP4Address subnet = null;
                IP4Address routerAddress = dhcpEnabled ? (IP4Address)netInterfaceAddressConfig.getAddress() : (IP4Address)netConfigIP4.getAddress();
                IP4Address subnetMask = null;
                int defaultLeaseTime = -1;
                int maximumLeaseTime = -1;
                short prefix = -1;
                IP4Address rangeStart = null;
                IP4Address rangeEnd = null;
                boolean passDns = false;
                ArrayList<IP4Address> dnServers = new ArrayList<IP4Address>();
                String configDhcpServerPrefix = "net.interface." + interfaceName + ".config.dhcpServer4.prefix";
                if (props.containsKey(configDhcpServerPrefix)) {
                    if (props.get(configDhcpServerPrefix) instanceof Short) {
                        prefix = (Short)props.get(configDhcpServerPrefix);
                    } else if (props.get(configDhcpServerPrefix) instanceof String) {
                        prefix = Short.parseShort((String)props.get(configDhcpServerPrefix));
                    }
                    logger.trace("DHCP Server prefix: {}", (Object)prefix);
                }
                if (props.containsKey(configDhcpServerRangeStart = "net.interface." + interfaceName + ".config.dhcpServer4.rangeStart")) {
                    String dhcpServerRangeStart = (String)props.get(configDhcpServerRangeStart);
                    logger.trace("DHCP Server Range Start: {}", (Object)dhcpServerRangeStart);
                    if (dhcpServerRangeStart != null && !dhcpServerRangeStart.isEmpty()) {
                        rangeStart = (IP4Address)IPAddress.parseHostAddress((String)dhcpServerRangeStart);
                    }
                }
                if (props.containsKey(configDhcpServerRangeEnd = "net.interface." + interfaceName + ".config.dhcpServer4.rangeEnd")) {
                    String dhcpServerRangeEnd = (String)props.get(configDhcpServerRangeEnd);
                    logger.trace("DHCP Server Range End: {}", (Object)dhcpServerRangeEnd);
                    if (dhcpServerRangeEnd != null && !dhcpServerRangeEnd.isEmpty()) {
                        rangeEnd = (IP4Address)IPAddress.parseHostAddress((String)dhcpServerRangeEnd);
                    }
                }
                if (props.containsKey(configDhcpServerDefaultLeaseTime = "net.interface." + interfaceName + ".config.dhcpServer4.defaultLeaseTime")) {
                    if (props.get(configDhcpServerDefaultLeaseTime) instanceof Integer) {
                        defaultLeaseTime = (Integer)props.get(configDhcpServerDefaultLeaseTime);
                    } else if (props.get(configDhcpServerDefaultLeaseTime) instanceof String) {
                        defaultLeaseTime = Integer.parseInt((String)props.get(configDhcpServerDefaultLeaseTime));
                    }
                    logger.trace("DHCP Server Default Lease Time: {}", (Object)defaultLeaseTime);
                }
                if (props.containsKey(configDhcpServerMaxLeaseTime = "net.interface." + interfaceName + ".config.dhcpServer4.maxLeaseTime")) {
                    if (props.get(configDhcpServerMaxLeaseTime) instanceof Integer) {
                        maximumLeaseTime = (Integer)props.get(configDhcpServerMaxLeaseTime);
                    } else if (props.get(configDhcpServerMaxLeaseTime) instanceof String) {
                        maximumLeaseTime = Integer.parseInt((String)props.get(configDhcpServerMaxLeaseTime));
                    }
                    logger.trace("DHCP Server Maximum Lease Time: {}", (Object)maximumLeaseTime);
                }
                if (props.containsKey(configDhcpServerPassDns = "net.interface." + interfaceName + ".config.dhcpServer4.passDns")) {
                    if (props.get(configDhcpServerPassDns) instanceof Boolean) {
                        passDns = (Boolean)props.get(configDhcpServerPassDns);
                    } else if (props.get(configDhcpServerPassDns) instanceof String) {
                        passDns = Boolean.parseBoolean((String)props.get(configDhcpServerPassDns));
                    }
                    logger.trace("DHCP Server Pass DNS?: {}", (Object)passDns);
                }
                if (routerAddress != null && rangeStart != null && rangeEnd != null) {
                    short prefixInt = prefix;
                    int mask = ~((1 << 32 - prefixInt) - 1);
                    String subnetMaskString = NetworkUtil.dottedQuad(mask);
                    String subnetString = NetworkUtil.calculateNetwork(routerAddress.getHostAddress(), subnetMaskString);
                    subnet = (IP4Address)IPAddress.parseHostAddress((String)subnetString);
                    subnetMask = (IP4Address)IPAddress.parseHostAddress((String)subnetMaskString);
                    dnServers.add(routerAddress);
                    DhcpServerCfg dhcpServerCfg = new DhcpServerCfg(interfaceName, dhcpServerEnabled, defaultLeaseTime, maximumLeaseTime, passDns);
                    DhcpServerCfgIP4 dhcpServerCfgIP4 = new DhcpServerCfgIP4(subnet, subnetMask, prefix, routerAddress, rangeStart, rangeEnd, dnServers);
                    try {
                        netConfigs.add((NetConfig)new DhcpServerConfigIP4(dhcpServerCfg, dhcpServerCfgIP4));
                    }
                    catch (KuraException kuraException) {
                        logger.warn("This invalid DhcpServerCfgIP4 configuration is ignored - {}, {}", (Object)dhcpServerCfg, (Object)dhcpServerCfgIP4);
                    }
                } else {
                    StringBuilder sb = new StringBuilder("Not including DhcpServerConfig - router: ");
                    sb.append(routerAddress);
                    sb.append(", range start: ");
                    sb.append(rangeStart);
                    sb.append(", range end: ");
                    sb.append(rangeEnd);
                    logger.trace(sb.toString());
                }
            }
            String configDhcp6 = "net.interface." + interfaceName + ".config.dhcpClient6.enabled";
            NetConfigIP6 netConfigIP6 = null;
            boolean dhcp6Enabled = false;
            if (props.containsKey(configDhcp6)) {
                dhcp6Enabled = (Boolean)props.get(configDhcp6);
                logger.trace("DHCP 6 enabled? {}", (Object)dhcp6Enabled);
            }
            if (!dhcp6Enabled) {
                netConfigIP6 = new NetConfigIP6(NetInterfaceStatus.valueOf((String)configStatus6), autoConnect, dhcp6Enabled);
                netConfigs.add((NetConfig)netConfigIP6);
                String configIp6 = "net.interface." + interfaceName + ".config.ip6.address";
                if (props.containsKey(configIp6)) {
                    String configDomains6;
                    String configDNSs6;
                    String addressIp6 = (String)props.get(configIp6);
                    logger.trace("IPv6 address: {}", (Object)addressIp6);
                    if (addressIp6 != null && !addressIp6.isEmpty()) {
                        IP6Address ip6Address = (IP6Address)IPAddress.parseHostAddress((String)addressIp6);
                        netConfigIP6.setAddress((IPAddress)ip6Address);
                    }
                    if (props.containsKey(configDNSs6 = "net.interface." + interfaceName + ".config.ip6.dnsServers")) {
                        String[] dnss;
                        ArrayList<IP6Address> dnsIPs = new ArrayList<IP6Address>();
                        String dnsAll = (String)props.get(configDNSs6);
                        String[] stringArray4 = dnss = dnsAll.split(",");
                        int n7 = dnss.length;
                        int dnServers = 0;
                        while (dnServers < n7) {
                            String dns = stringArray4[dnServers];
                            logger.trace("IPv6 DNS: {}", (Object)dns);
                            IP6Address dnsIp6 = (IP6Address)IPAddress.parseHostAddress((String)dns);
                            dnsIPs.add(dnsIp6);
                            ++dnServers;
                        }
                        netConfigIP6.setDnsServers(dnsIPs);
                    }
                    if (props.containsKey(configDomains6 = "net.interface." + interfaceName + ".config.ip6.domains")) {
                        String[] domains;
                        ArrayList<String> domainNames = new ArrayList<String>();
                        String domainsAll = (String)props.get(configDomains6);
                        String[] stringArray5 = domains = domainsAll.split(",");
                        int n8 = domains.length;
                        int n9 = 0;
                        while (n9 < n8) {
                            String domain = stringArray5[n9];
                            logger.trace("IPv6 Domain: {}", (Object)domain);
                            domainNames.add(domain);
                            ++n9;
                        }
                        netConfigIP6.setDomains(domainNames);
                    }
                }
            }
            if (interfaceType == NetInterfaceType.WIFI) {
                logger.trace("Adding wifi netconfig");
                WifiConfig apConfig = NetworkConfiguration.getWifiConfig(netIfConfigPrefix, WifiMode.MASTER, props);
                if (apConfig != null) {
                    logger.trace("Adding AP wifi config");
                    netConfigs.add((NetConfig)apConfig);
                } else {
                    logger.warn("no AP wifi config specified");
                }
                WifiConfig infraConfig = NetworkConfiguration.getWifiConfig(netIfConfigPrefix, WifiMode.INFRA, props);
                if (infraConfig != null) {
                    logger.trace("Adding client INFRA wifi config");
                    netConfigs.add((NetConfig)infraConfig);
                } else {
                    logger.warn("no INFRA wifi config specified");
                }
            }
            if (interfaceType != NetInterfaceType.MODEM) continue;
            logger.trace("Adding modem netconfig");
            netConfigs.add((NetConfig)NetworkConfiguration.getModemConfig(netIfConfigPrefix, props));
        }
    }
}

