/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.kura.web.shared.model.GwtUserData;

public class GwtUserConfig
extends GwtUserData
implements IsSerializable {
    private static final String PASSWORD_KEY = "password";
    private static final long serialVersionUID = 8795619406606205153L;

    public GwtUserConfig() {
    }

    public GwtUserConfig(String userName, Set<String> permissions, boolean isPasswordAuthEnabled) {
        super(userName, permissions);
        this.setPasswordAuthEnabled(isPasswordAuthEnabled);
    }

    public boolean isPasswordAuthEnabled() {
        return (Boolean)this.get("password.enabled");
    }

    public void setPasswordAuthEnabled(boolean enabled) {
        this.set("password.enabled", enabled);
    }

    public void setNewPassword(Optional<String> password) {
        if (password.isPresent()) {
            this.set(PASSWORD_KEY, password.get());
        } else {
            this.set(PASSWORD_KEY, null);
        }
    }

    public Optional<String> getNewPassword() {
        return Optional.ofNullable((String)this.get(PASSWORD_KEY));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.isPasswordAuthEnabled(), this.getNewPassword());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GwtUserConfig other = (GwtUserConfig)obj;
        return this.isPasswordAuthEnabled() == other.isPasswordAuthEnabled() && Objects.equals(this.getNewPassword(), other.getNewPassword());
    }
}

