/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.SerializationException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class GwtSecurityTokenServiceImpl
extends OsgiRemoteServiceServlet
implements GwtSecurityTokenService {
    private static final long serialVersionUID = 5333012054583792499L;
    private static ThreadLocal<HttpServletRequest> threadRequest = new ThreadLocal();
    static final String XSRF_TOKEN_KEY = "XSRF_TOKEN";

    public String processCall(String payload) throws SerializationException {
        try {
            threadRequest.set(this.getThreadLocalRequest());
            String string = super.processCall(payload);
            return string;
        }
        finally {
            threadRequest.remove();
        }
    }

    public static HttpServletRequest getRequest() {
        return threadRequest.get();
    }

    public HttpSession getHttpSession() {
        HttpServletRequest request = GwtSecurityTokenServiceImpl.getRequest();
        return request.getSession(false);
    }

    @Override
    public GwtXSRFToken generateSecurityToken() {
        HttpServletRequest httpServletRequest = GwtSecurityTokenServiceImpl.getRequest();
        Optional<Cookie> cookie = Arrays.stream(httpServletRequest.getCookies()).filter(c -> "JSESSIONID".equals(c.getName())).findAny();
        if (!cookie.isPresent() || Objects.isNull(cookie.get().getValue()) || cookie.get().getValue().isEmpty()) {
            throw new RpcTokenException("Unable to generate XSRF cookie: the session cookie is not set or empty!");
        }
        BundleContext context = FrameworkUtil.getBundle(GwtSecurityTokenServiceImpl.class).getBundleContext();
        ServiceReference ref = context.getServiceReference(CryptoService.class);
        try {
            CryptoService cryptoService = (CryptoService)ServiceLocator.getInstance().getService(ref);
            GwtXSRFToken gwtXSRFToken = new GwtXSRFToken(cryptoService.sha1Hash(cookie.get().getValue()));
            return gwtXSRFToken;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException | GwtKuraException exception) {
            throw new RpcTokenException("Unable to generate XSRF cookie: the crypto service is unavailable!");
        }
        finally {
            context.ungetService(ref);
        }
    }
}

