/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import javax.servlet.http.HttpSession;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.service.GwtPasswordAuthenticationService;

public class GwtPasswordAuthenticationServiceImpl
extends OsgiRemoteServiceServlet
implements GwtPasswordAuthenticationService {
    private static final long serialVersionUID = 1L;
    private final UserManager userManager;
    private final String redirectPath;

    public GwtPasswordAuthenticationServiceImpl(UserManager userManager, String redirectPath) {
        this.userManager = userManager;
        this.redirectPath = redirectPath;
    }

    @Override
    public String authenticate(String username, String password) throws GwtKuraException {
        HttpSession session = Console.instance().createSession(this.getThreadLocalRequest());
        AuditContext context = AuditContext.currentOrInternal();
        context.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), username);
        try {
            if (!Console.getConsoleOptions().isAuthenticationMethodEnabled("Password")) {
                throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
            }
            this.userManager.authenticateWithPassword(username, password);
            context.getProperties().put("session.id", session.getId());
            Console.instance().setAuthenticated(session, username, context.copy());
            return this.redirectPath;
        }
        catch (Exception exception) {
            session.invalidate();
            throw new GwtKuraException("unauthorized");
        }
    }
}

