/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraRuntimeException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.keystore.KeystoreServiceOptions;
import org.eclipse.kura.core.keystore.crl.CRLManager;
import org.eclipse.kura.core.keystore.crl.CRLManagerOptions;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.security.keystore.KeystoreChangedEvent;
import org.eclipse.kura.security.keystore.KeystoreService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemKeystoreServiceImpl
implements KeystoreService,
ConfigurableComponent {
    private static final String KURA_SERVICE_PID = "kura.service.pid";
    private static final String PEM_CERTIFICATE_REQUEST_TYPE = "CERTIFICATE REQUEST";
    private static final Logger logger = LoggerFactory.getLogger(FilesystemKeystoreServiceImpl.class);
    private ComponentContext componentContext;
    private CryptoService cryptoService;
    private ConfigurationService configurationService;
    private EventAdmin eventAdmin;
    private KeystoreServiceOptions keystoreServiceOptions;
    private CRLManagerOptions crlManagerOptions;
    private Optional<CRLManager> crlManager = Optional.empty();
    private ScheduledExecutorService selfUpdaterExecutor;
    private ScheduledFuture<?> selfUpdaterFuture;
    private String ownPid;

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void activate(ComponentContext context, Map<String, Object> properties) {
        logger.info("Bundle {} is starting!", properties.get(KURA_SERVICE_PID));
        this.componentContext = context;
        this.ownPid = (String)properties.get(KURA_SERVICE_PID);
        this.keystoreServiceOptions = new KeystoreServiceOptions(properties, this.cryptoService);
        this.selfUpdaterExecutor = Executors.newSingleThreadScheduledExecutor();
        if (this.keystoreExists(this.keystoreServiceOptions.getKeystorePath()) && this.keystoreServiceOptions.needsRandomPassword()) {
            this.changeDefaultKeystorePassword();
        }
        this.crlManagerOptions = new CRLManagerOptions(properties);
        this.updateCRLManager(this.crlManagerOptions);
        logger.info("Bundle {} has started!", properties.get(KURA_SERVICE_PID));
    }

    public void updated(Map<String, Object> properties) {
        CRLManagerOptions newCRLManagerOptions;
        logger.info("Bundle {} is updating!", properties.get(KURA_SERVICE_PID));
        KeystoreServiceOptions newOptions = new KeystoreServiceOptions(properties, this.cryptoService);
        if (!this.keystoreServiceOptions.equals(newOptions)) {
            logger.info("Perform update...");
            if (!this.keystoreServiceOptions.getKeystorePath().equals(newOptions.getKeystorePath())) {
                this.updateKeystorePath(newOptions);
            } else if (!Arrays.equals(this.keystoreServiceOptions.getKeystorePassword(this.cryptoService), newOptions.getKeystorePassword(this.cryptoService))) {
                this.updateKeystorePassword(this.keystoreServiceOptions, newOptions);
            }
            this.keystoreServiceOptions = new KeystoreServiceOptions(properties, this.cryptoService);
        }
        if (!this.crlManagerOptions.equals(newCRLManagerOptions = new CRLManagerOptions(properties))) {
            this.crlManagerOptions = newCRLManagerOptions;
            this.updateCRLManager(newCRLManagerOptions);
        }
        logger.info("Bundle {} has updated!", properties.get(KURA_SERVICE_PID));
    }

    public void deactivate() {
        logger.info("Bundle {} is deactivating!", this.keystoreServiceOptions.getProperties().get(KURA_SERVICE_PID));
        if (this.selfUpdaterFuture != null && !this.selfUpdaterFuture.isDone()) {
            logger.info("Self updater task running. Stopping it");
            this.selfUpdaterFuture.cancel(true);
        }
        this.shutdownCRLManager();
    }

    private boolean keystoreExists(String keystorePath) {
        boolean result = false;
        File fKeyStore = new File(keystorePath);
        if (fKeyStore.exists()) {
            result = true;
        }
        return result;
    }

    private void updateKeystorePath(KeystoreServiceOptions newOptions) {
        if (!this.keystoreExists(newOptions.getKeystorePath())) {
            return;
        }
        if (!this.isKeyStoreAccessible(newOptions.getKeystorePath(), newOptions.getKeystorePassword(this.cryptoService))) {
            logger.warn("Keystore {} not accessible!", (Object)newOptions.getKeystorePath());
        }
    }

    private void changeDefaultKeystorePassword() {
        char[] oldPassword = this.keystoreServiceOptions.getKeystorePassword(this.cryptoService);
        if (this.isDefaultFromCrypto()) {
            oldPassword = this.cryptoService.getKeyStorePassword(this.keystoreServiceOptions.getKeystorePath());
        }
        char[] newPassword = new BigInteger(160, new SecureRandom()).toString(32).toCharArray();
        try {
            this.changeKeyStorePassword(this.keystoreServiceOptions.getKeystorePath(), oldPassword, newPassword);
            HashMap<String, Object> props = new HashMap<String, Object>(this.keystoreServiceOptions.getProperties());
            props.put("keystore.password", new String(this.cryptoService.encryptAes(newPassword)));
            this.keystoreServiceOptions = new KeystoreServiceOptions(props, this.cryptoService);
            this.updatePasswordInConfigService(newPassword);
        }
        catch (Exception e) {
            logger.warn("Keystore password change failed", (Throwable)e);
        }
    }

    private synchronized void changeKeyStorePassword(String location, char[] oldPassword, char[] newPassword) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableEntryException {
        KeyStore keystore = this.loadKeystore(location, oldPassword);
        FilesystemKeystoreServiceImpl.updateKeyEntriesPasswords(keystore, oldPassword, newPassword);
        this.saveKeystore(location, newPassword, keystore);
    }

    private void saveKeystore(String keyStoreFileName, char[] keyStorePassword, KeyStore ks) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream tsOutStream = new FileOutputStream(keyStoreFileName);){
            ks.store(tsOutStream, keyStorePassword);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void updatePasswordInConfigService(char[] newPassword) {
        String pid = this.keystoreServiceOptions.getPid();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.keystoreServiceOptions.getProperties());
        props.put("keystore.path", this.keystoreServiceOptions.getKeystorePath());
        props.put("keystore.password", new Password(newPassword));
        props.put("randomize.password", false);
        this.selfUpdaterFuture = this.selfUpdaterExecutor.scheduleAtFixedRate(() -> {
            try {
                if (this.componentContext.getServiceReference() != null && this.configurationService.getComponentConfiguration(pid) != null && this.configurationService.getComponentConfiguration(pid).getDefinition() != null) {
                    this.configurationService.updateConfiguration(pid, props);
                    throw new KuraRuntimeException(KuraErrorCode.CONFIGURATION_SNAPSHOT_TAKING, new Object[]{"Updated. The task will be terminated."});
                }
                logger.info("No service or configuration available yet.");
            }
            catch (KuraException e) {
                logger.warn("Cannot get/update configuration for pid: {}", (Object)pid, (Object)e);
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private boolean isDefaultFromCrypto() {
        char[] cryptoPassword = this.cryptoService.getKeyStorePassword(this.keystoreServiceOptions.getKeystorePath());
        if (cryptoPassword == null) {
            return false;
        }
        return this.isKeyStoreAccessible(this.keystoreServiceOptions.getKeystorePath(), cryptoPassword);
    }

    private boolean isKeyStoreAccessible(String location, char[] password) {
        try {
            this.loadKeystore(location, password);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private KeyStore loadKeystore(String keyStore, char[] keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream tsReadStream = new FileInputStream(keyStore);){
            ks.load(tsReadStream, keyStorePassword);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ks;
    }

    private void updateKeystorePassword(KeystoreServiceOptions oldOptions, KeystoreServiceOptions newOptions) {
        try {
            this.changeKeyStorePassword(oldOptions.getKeystorePassword(this.cryptoService), newOptions.getKeystorePassword(this.cryptoService));
            this.cryptoService.setKeyStorePassword(this.keystoreServiceOptions.getKeystorePath(), newOptions.getKeystorePassword(this.cryptoService));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException exception) {
            logger.warn("Failed to change keystore password");
        }
        catch (KuraException kuraException) {
            logger.warn("Failed to persist keystore password");
        }
        catch (GeneralSecurityException generalSecurityException) {
            logger.warn("Failed to load keystore");
        }
    }

    private void changeKeyStorePassword(char[] oldPassword, char[] newPassword) throws IOException, GeneralSecurityException, KuraException {
        KeyStore keystore = this.getKeyStore();
        FilesystemKeystoreServiceImpl.updateKeyEntriesPasswords(keystore, oldPassword, newPassword);
        this.saveKeystore(keystore, newPassword);
    }

    private static void updateKeyEntriesPasswords(KeyStore keystore, char[] oldPassword, char[] newPassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keystore.isKeyEntry(alias)) continue;
            KeyStore.PasswordProtection oldPP = new KeyStore.PasswordProtection(oldPassword);
            KeyStore.Entry entry = keystore.getEntry(alias, oldPP);
            KeyStore.PasswordProtection newPP = new KeyStore.PasswordProtection(newPassword);
            keystore.setEntry(alias, entry, newPP);
        }
    }

    public synchronized KeyStore getKeyStore() throws KuraException {
        KeyStore ks = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream tsReadStream = new FileInputStream(this.keystoreServiceOptions.getKeystorePath());){
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                char[] keystorePassword = this.keystoreServiceOptions.getKeystorePassword(this.cryptoService);
                ks.load(tsReadStream, keystorePassword);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | GeneralSecurityException e) {
            logger.warn("Failed to get the KeyStore {}", (Object)this.keystoreServiceOptions.getKeystorePath());
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get the KeyStore"});
        }
        return ks;
    }

    public KeyStore.Entry getEntry(String alias) throws KuraException {
        if (Objects.isNull(alias)) {
            throw new IllegalArgumentException("Key Pair alias cannot be null!");
        }
        KeyStore ks = this.getKeyStore();
        try {
            if (ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || ks.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
                return ks.getEntry(alias, new KeyStore.PasswordProtection(this.keystoreServiceOptions.getKeystorePassword(this.cryptoService)));
            }
            return ks.getEntry(alias, null);
        }
        catch (GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get the entry " + alias});
        }
    }

    public Map<String, KeyStore.Entry> getEntries() throws KuraException {
        HashMap<String, KeyStore.Entry> result = new HashMap<String, KeyStore.Entry>();
        KeyStore ks = this.getKeyStore();
        try {
            ArrayList<String> aliases = Collections.list(ks.aliases());
            for (String alias : aliases) {
                KeyStore.Entry tempEntry = this.getEntry(alias);
                result.put(alias, tempEntry);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get the entries"});
        }
    }

    /*
     * Loose catch block
     */
    public String getCSR(KeyPair keypair, X500Principal principal, String signerAlg) throws KuraException {
        if (Objects.isNull(principal) || Objects.isNull(keypair) || Objects.isNull(signerAlg) || signerAlg.trim().isEmpty()) {
            throw new IllegalArgumentException("Input parameters cannot be null!");
        }
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(principal, keypair.getPublic());
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(signerAlg);
        ContentSigner signer = null;
        try {
            signer = csBuilder.build(keypair.getPrivate());
        }
        catch (OperatorCreationException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get CSR"});
        }
        PKCS10CertificationRequest csr = p10Builder.build(signer);
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try {
                String string;
                JcaPEMWriter pemWriter;
                StringWriter str;
                block21: {
                    block20: {
                        str = new StringWriter();
                        pemWriter = new JcaPEMWriter((Writer)str);
                        PemObject pemCSR = new PemObject(PEM_CERTIFICATE_REQUEST_TYPE, csr.getEncoded());
                        pemWriter.writeObject((PemObjectGenerator)pemCSR);
                        pemWriter.flush();
                        string = str.toString();
                        if (pemWriter == null) break block20;
                        pemWriter.close();
                    }
                    if (str == null) break block21;
                    str.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (pemWriter != null) {
                                pemWriter.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (str != null) {
                                str.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[]{"Failed to get CSR"});
        }
    }

    public String getCSR(String alias, X500Principal principal, String signerAlg) throws KuraException {
        if (Objects.isNull(principal) || Objects.isNull(alias) || alias.trim().isEmpty() || Objects.isNull(signerAlg) || signerAlg.trim().isEmpty()) {
            throw new IllegalArgumentException("Input parameters cannot be null!");
        }
        KeyStore.Entry entry = this.getEntry(alias);
        if (entry == null) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
        PublicKey publicKey = ((KeyStore.PrivateKeyEntry)entry).getCertificate().getPublicKey();
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return this.getCSR(keyPair, principal, signerAlg);
    }

    public List<KeyManager> getKeyManagers(String algorithm) throws KuraException {
        if (Objects.isNull(algorithm)) {
            throw new IllegalArgumentException("Algorithm cannot be null!");
        }
        KeyStore ks = this.getKeyStore();
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, this.keystoreServiceOptions.getKeystorePassword(this.cryptoService));
            return Arrays.asList(kmf.getKeyManagers());
        }
        catch (GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get the key managers for algorithm " + algorithm});
        }
    }

    public void deleteEntry(String alias) throws KuraException {
        if (Objects.isNull(alias)) {
            throw new IllegalArgumentException("Alias cannot be null!");
        }
        Optional<KeyStore.Entry> currentEntry = Optional.ofNullable(this.getEntry(alias));
        if (!currentEntry.isPresent()) {
            return;
        }
        KeyStore ks = this.getKeyStore();
        try {
            ks.deleteEntry(alias);
            this.saveKeystore(ks);
            boolean crlStoreChanged = false;
            crlStoreChanged = this.tryRemoveFromCrlManagement(currentEntry.get());
            if (!crlStoreChanged) {
                this.postChangedEvent();
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to delete entry " + alias});
        }
    }

    private void saveKeystore(KeyStore ks) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.saveKeystore(ks, this.keystoreServiceOptions.getKeystorePassword(this.cryptoService));
    }

    private void saveKeystore(KeyStore ks, char[] password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream tsOutStream = new FileOutputStream(this.keystoreServiceOptions.getKeystorePath());){
            ks.store(tsOutStream, password);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setEntry(String alias, KeyStore.Entry entry) throws KuraException {
        if (Objects.isNull(alias) || alias.trim().isEmpty() || Objects.isNull(entry)) {
            throw new IllegalArgumentException("Input cannot be null or empty!");
        }
        KeyStore ks = this.getKeyStore();
        KeyStore.PasswordProtection protectionParameter = entry instanceof KeyStore.TrustedCertificateEntry ? null : new KeyStore.PasswordProtection(this.keystoreServiceOptions.getKeystorePassword(this.cryptoService));
        try {
            ks.setEntry(alias, entry, protectionParameter);
            this.saveKeystore(ks);
            if (!this.tryAddToCrlManagement(entry)) {
                this.postChangedEvent();
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to set the entry " + alias});
        }
    }

    public List<String> getAliases() throws KuraException {
        KeyStore ks = this.getKeyStore();
        try {
            return Collections.list(ks.aliases());
        }
        catch (GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get aliases"});
        }
    }

    public void createKeyPair(String alias, String algorithm, int keySize, String signatureAlgorithm, String attributes) throws KuraException {
        this.createKeyPair(alias, algorithm, keySize, signatureAlgorithm, attributes, new SecureRandom());
    }

    public void createKeyPair(String alias, String algorithm, int keySize, String signatureAlgorithm, String attributes, SecureRandom secureRandom) throws KuraException {
        if (Objects.isNull(algorithm) || algorithm.trim().isEmpty() || Objects.isNull(secureRandom) || Objects.isNull(alias) || Objects.isNull(attributes) || attributes.trim().isEmpty() || Objects.isNull(signatureAlgorithm) || signatureAlgorithm.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameters cannot be null or empty!");
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm);
            keyGen.initialize(keySize, secureRandom);
            KeyPair keyPair = keyGen.generateKeyPair();
            this.setEntry(alias, new KeyStore.PrivateKeyEntry(keyPair.getPrivate(), this.generateCertificateChain(keyPair, signatureAlgorithm, attributes)));
        }
        catch (GeneralSecurityException | OperatorCreationException throwable) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
    }

    public X509Certificate[] generateCertificateChain(KeyPair keyPair, String signatureAlgorithm, String attributes) throws OperatorCreationException, CertificateException {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        X500Name dnName = new X500Name(attributes);
        BigInteger certSerialNumber = new BigInteger(Long.toString(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(dnName, certSerialNumber, startDate, endDate, dnName, subjectPublicKeyInfo);
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider((Provider)bcProvider).build(keyPair.getPrivate());
        X509CertificateHolder certificateHolder = certificateBuilder.build(contentSigner);
        return new X509Certificate[]{new JcaX509CertificateConverter().getCertificate(certificateHolder)};
    }

    private void updateCRLManager(CRLManagerOptions newCRLManagerOptions) {
        this.shutdownCRLManager();
        if (this.crlManagerOptions.isCrlManagementEnabled()) {
            CRLManager currentCRLManager = new CRLManager(this.crlManagerOptions.getStoreFile().orElseGet(() -> new File(String.valueOf(this.keystoreServiceOptions.getKeystorePath()) + ".crl")), 5000L, newCRLManagerOptions.getCrlCheckIntervalMs(), newCRLManagerOptions.getCrlUpdateIntervalMs(), this.getCRLVerifier(newCRLManagerOptions));
            currentCRLManager.setListener(Optional.of(this::postChangedEvent));
            for (URI uri : newCRLManagerOptions.getCrlURIs()) {
                currentCRLManager.addDistributionPoint(Collections.singleton(uri));
            }
            try {
                for (KeyStore.Entry e : this.getEntries().values()) {
                    KeyStore.TrustedCertificateEntry certEntry;
                    Certificate cert;
                    if (!(e instanceof KeyStore.TrustedCertificateEntry) || !((cert = (certEntry = (KeyStore.TrustedCertificateEntry)e).getTrustedCertificate()) instanceof X509Certificate)) continue;
                    currentCRLManager.addTrustedCertificate((X509Certificate)cert);
                }
            }
            catch (Exception e) {
                logger.warn("failed to add current trusted certificates to CRL manager", (Throwable)e);
            }
            this.crlManager = Optional.of(currentCRLManager);
        }
    }

    private CRLManager.CRLVerifier getCRLVerifier(CRLManagerOptions options) {
        if (!options.isCRLVerificationEnabled()) {
            return crl -> true;
        }
        return crl -> {
            try {
                KeyStore.TrustedCertificateEntry trustedCertEntry;
                KeyStore.Entry e;
                Iterator<KeyStore.Entry> iterator = this.getEntries().values().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while (!((e = iterator.next()) instanceof KeyStore.TrustedCertificateEntry) || !this.verifyCRL(crl, trustedCertEntry = (KeyStore.TrustedCertificateEntry)e));
                return true;
            }
            catch (Exception e) {
                logger.warn("Exception verifying CRL", (Throwable)e);
                return false;
            }
        };
    }

    private Optional<X509Certificate> extractCertificate(KeyStore.Entry entry) {
        if (!(entry instanceof KeyStore.TrustedCertificateEntry)) {
            return Optional.empty();
        }
        KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
        Certificate certificate = trustedCertificateEntry.getTrustedCertificate();
        if (!(certificate instanceof X509Certificate)) {
            return Optional.empty();
        }
        return Optional.of((X509Certificate)certificate);
    }

    private boolean tryAddToCrlManagement(KeyStore.Entry entry) {
        Optional<X509Certificate> certificate = this.extractCertificate(entry);
        Optional<CRLManager> currentCrlManager = this.crlManager;
        if (certificate.isPresent() && currentCrlManager.isPresent()) {
            return currentCrlManager.get().addTrustedCertificate(certificate.get());
        }
        return false;
    }

    private boolean tryRemoveFromCrlManagement(KeyStore.Entry entry) {
        Optional<X509Certificate> certificate = this.extractCertificate(entry);
        Optional<CRLManager> currentCrlManager = this.crlManager;
        if (certificate.isPresent() && this.crlManager.isPresent()) {
            return currentCrlManager.get().removeTrustedCertificate(certificate.get());
        }
        return false;
    }

    private boolean verifyCRL(X509CRL crl, KeyStore.TrustedCertificateEntry trustedCertEntry) {
        try {
            crl.verify(trustedCertEntry.getTrustedCertificate().getPublicKey());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void shutdownCRLManager() {
        if (this.crlManager.isPresent()) {
            this.crlManager.get().close();
            this.crlManager = Optional.empty();
        }
    }

    public Collection<CRL> getCRLs() {
        Optional<CRLManager> currentCRLManager = this.crlManager;
        if (!currentCRLManager.isPresent()) {
            return Collections.emptyList();
        }
        return new ArrayList<CRL>(currentCRLManager.get().getCrls());
    }

    public CertStore getCRLStore() throws KuraException {
        Optional<CRLManager> currentCRLManager = this.crlManager;
        try {
            if (!currentCRLManager.isPresent()) {
                return CertStore.getInstance("Collection", new CollectionCertStoreParameters());
            }
            return currentCRLManager.get().getCertStore();
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
    }

    private void postChangedEvent() {
        this.eventAdmin.postEvent((Event)new KeystoreChangedEvent(this.ownPid));
    }
}

