/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceDiscovery;

public class AggregatingServiceDiscovery
implements ServiceDiscovery {
    private final List<ServiceDiscovery> delegates;

    public AggregatingServiceDiscovery(List<ServiceDiscovery> delegates) {
        this.delegates = Collections.unmodifiableList(delegates);
    }

    public List<ServiceDiscovery> getDelegates() {
        return this.delegates;
    }

    @Override
    public List<ServiceDefinition> getServices(String name) {
        return this.delegates.stream().flatMap(d -> d.getServices(name).stream()).collect(Collectors.toList());
    }

    public static AggregatingServiceDiscovery wrap(ServiceDiscovery ... delegates) {
        return new AggregatingServiceDiscovery(Arrays.asList(delegates));
    }
}

