/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinServlet
extends HttpServlet {
    private static final long serialVersionUID = -556598856721497972L;
    private static Logger logger = LoggerFactory.getLogger(SkinServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        File fResourceFile;
        String resourceName = request.getPathInfo();
        try {
            fResourceFile = this.checkFile(resourceName);
        }
        catch (IOException | GwtKuraException exception) {
            return;
        }
        if (resourceName.endsWith(".css")) {
            response.setContentType("text/css");
            this.streamText(fResourceFile, response);
        } else if (resourceName.endsWith(".js")) {
            response.setContentType("text/javascript");
            this.streamText(fResourceFile, response);
        } else if (resourceName.endsWith(".jpg") || resourceName.endsWith(".png")) {
            response.setContentType("image/png");
            this.streamBinary(fResourceFile, response);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void streamText(File fResourceFile, HttpServletResponse response) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileReader fr = new FileReader(fResourceFile);
                try {
                    try (PrintWriter w = response.getWriter();){
                        char[] buffer = new char[1024];
                        int iRead = fr.read(buffer);
                        while (iRead != -1) {
                            w.write(buffer, 0, iRead);
                            iRead = fr.read(buffer);
                        }
                    }
                    if (fr == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
                fr.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error loading skin resource", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void streamBinary(File fResourceFile, HttpServletResponse response) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileInputStream in = new FileInputStream(fResourceFile);
                try {
                    try (ServletOutputStream o = response.getOutputStream();){
                        byte[] buf = new byte[1024];
                        int len = 0;
                        while ((len = in.read(buf)) >= 0) {
                            o.write(buf, 0, len);
                        }
                    }
                    if (in == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error loading skin resource", (Throwable)e);
        }
    }

    private File checkFile(String resourceName) throws GwtKuraException, IOException {
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> kuraStyleDirStream = Files.list(Paths.get(systemService.getKuraStyleDirectory(), new String[0]));){
            Optional<Path> fResourcePath = kuraStyleDirStream.filter(filePath -> filePath.toFile().isFile()).filter(filePath -> filePath.toFile().getAbsolutePath().endsWith(resourceName)).findFirst();
            if (!fResourcePath.isPresent()) {
                logger.warn("Resource File {} does not exist", (Object)resourceName);
                throw new IOException("Resource File " + resourceName + " does not exist");
            }
            return fResourcePath.get().toFile();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

